<?php
/**
 * The default template for displaying content. 
 *
 * @package lightblog
 * @since lightblog 1.0
 */
 
?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
<div class="articlecontainer">
	
    <?php lightblogkt_post_thumbnail(); ?>
    <div class="clear"></div>	
	<div class="row">
	<?php if ( is_sticky() && is_home() && ! is_paged() )
    echo '<div class="sticky featured-post">' . esc_html__( 'Sticky', 'lightblogkt' ) . '</div>';
	?>
	<header class="entry-header three_fourth columns">
		<?php
			the_title( sprintf( '<h2 class="entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h2>' );
		?>
	</header><!-- .entry-header -->

	<div class="clear"></div> 
	<div class="one_fourth columns">
		<?php if ( 'post' === get_post_type() ) { ?>
        <div class="entry-utility">
            
            <div class="date"> <?php the_time(get_option('date_format')); ?></div>  
            <div class="user"><?php esc_html_e('By','lightblogkt'); ?> <a href="<?php echo esc_url(get_author_posts_url( get_the_author_meta( 'ID' ) ));?>"><?php the_author();?></a></div>
            <?php if ( ! is_singular() && ! post_password_required() && ( comments_open() || get_comments_number() ) ) { ?>
                <?php 
                    $css_class = 'zero-comments';
                    $number    = (int) get_comments_number( get_the_ID() );
                    
                    if ( 1 === $number )
                        $css_class = 'one-comment';
                    elseif ( 1 < $number )
                        $css_class = 'multiple-comments';
                ?>
                
                 <div class="comment <?php echo esc_attr($css_class); ?>">
                     <?php 
                    
                        comments_popup_link( 
                            esc_html__( 'No Comments', 'lightblogkt' ), 
                            esc_html__( '1 Comment', 'lightblogkt' ), 
                            esc_html__( '% Comments', 'lightblogkt' ),
                            esc_attr($css_class),
                            esc_html__( 'Comments Closed', 'lightblogkt' )
                        );
                     ?>
                </div>
             <?php } ?>
             <div class="category"><?php esc_html_e('in','lightblogkt'); ?> <?php the_category(', '); ?></div>  
            <div class="clear"></div>  
        </div>  
        <?php } ?>  
	</div>
	<div class="three_fourth columns">
        <div class="entry-content">
            <?php the_excerpt(''); ?>
        </div>
            
            <?php
                wp_link_pages( array(
                'before'      => '<div class="page-links"><span class="page-links-title">' . esc_html__( 'Pages : ', 'lightblogkt' ) . '</span>',
                'after'       => '</div>',
                'link_before' => '<span>',
                'link_after'  => '</span>',
                ) );
            ?>
            
            <?php if(!is_single()){?>
            <a href="<?php the_permalink(); ?>" class="more-link"><?php esc_html_e('Continue Reading','lightblogkt'); ?></a>
            <?php }?>
    
        
    </div>
    </div>
    <div class="clear"></div>
</div>
</article><!-- end post -->

 