<?php
/**
 * The sidebar containing the main widget area.
 *
 * @package Legacy Videography
 */


?>

<aside id="secondary" class="widget-area" role="complementary">
	<?php dynamic_sidebar( 'primary-sidebar' ); ?>
</aside><!-- #secondary -->

<?php if ( ! is_active_sidebar( 'primary-sidebar' ) ) { ?>

	<aside id="secondary" class="widget-area" role="complementary">
		<!-- Search -->
		<aside id="search-3" class="widget widget_search">
			<h2 class="widget-title"><?php esc_html_e('Search Here', 'legacy-videography'); ?></h2>
			<?php get_search_form(); ?>
		</aside>
		<!-- Categories -->
		<aside id="categories" class="widget widget_categories" role="complementary" aria-label="<?php esc_attr_e( 'secondsidebar', 'legacy-videography' ); ?>">
		    <h2 class="widget-title"><?php esc_html_e('Categories', 'legacy-videography'); ?></h2>
		    <ul>
		        <?php
		        $args = array(
		            'title_li' => '',
		        );
		        wp_list_categories($args);
		        ?>
		    </ul>
		</aside>
		<!-- Archive -->
		<aside id="archive" class="widget widget_archive" role="complementary" aria-label="<?php esc_attr_e( 'secondsidebar', 'legacy-videography' ); ?>">
		    <h2 class="widget-title"><?php esc_html_e('Archive List', 'legacy-videography'); ?></h2>
		    <ul>
		        <?php wp_get_archives('type=monthly'); ?>
		    </ul>
		</aside>
		<!-- Tag Sidebar -->
		<aside id="tag-sidebar" class="widget widget_tag_cloud" role="complementary" aria-label="<?php esc_attr_e( 'thirdsidebar', 'legacy-videography' ); ?>">
		    <h2 class="widget-title"><?php esc_html_e('Popular Tags', 'legacy-videography'); ?></h2>
		    <div class="tagcloud">
		        <?php
		        $legacy_videography_tags = get_tags(array(
		            'orderby' => 'count',
		            'order'   => 'DESC',
		            'number'  => 20, // You can change the number of tags displayed
		        ));

		        if ($legacy_videography_tags) {
		            foreach ($legacy_videography_tags as $legacy_videography_tag) {
		                $legacy_videography_tag_link = get_tag_link($legacy_videography_tag->term_id);
		                $legacy_videography_tag_name = $legacy_videography_tag->name;
		                $legacy_videography_tag_count = $legacy_videography_tag->count;
		                echo '<a href="' . esc_url($legacy_videography_tag_link) . '" class="tag-link" title="' . esc_attr($legacy_videography_tag_name) . ' (' . $legacy_videography_tag_count . ' posts)">' . esc_html($legacy_videography_tag_name) . '</a> ';
		            }
		        } else {
		            echo '<p>' . esc_html__('No tags found.', 'legacy-videography') . '</p>';
		        }
		        ?>
		    </div>
		</aside>	
	</aside>

<?php } ?>
