<?php
// Enqueue theme styles and custom inline CSS
function legacy_videography_enqueue_styles() {
    wp_enqueue_style('legacy-videography-style', get_stylesheet_uri());
}
add_action('wp_enqueue_scripts', 'legacy_videography_enqueue_styles');

// custom header
    add_theme_support('custom-header', array(
            'width'                  => 1920, 
            'height'                 => 400,  
            'flex-height'            => true,
            'flex-width'             => true,
            'header-text'            => true, // Enable or disable header text
            'default-text-color'     => '000000', // Default header text color
            'wp-head-callback'       => 'legacy_videography_header_style',
        ) );

// custom-background
    add_theme_support( 'custom-background', array(
          'default-color' => 'ffffff',
        ));

// Style the header
function legacy_videography_header_style() {
    $legacy_videography_header_image = get_header_image();    
    $legacy_videography_header_text_color = get_header_textcolor();
   
     if (get_theme_support('custom-header', 'default-text-color') !== $legacy_videography_header_text_color || !empty($legacy_videography_header_image)) {
            ?>
        <style type="text/css" id="entr-header-css">
            <?php
            // Has a Custom Header been added?
            if (!empty($legacy_videography_header_image)) :
                ?>
                 #custom-header {
                    background-image: url(<?php header_image(); ?>);
                    background-repeat: no-repeat;
                    background-position: 50% 50%;
                    -webkit-background-size: cover;
                    -moz-background-size:    cover;
                    -o-background-size:      cover;
                    background-size:         cover;
                }
            <?php endif; ?> 
            <?php
                if ('blank' === $legacy_videography_header_text_color) :
                ?>
                    .site-title a,.site-description {
                        color: #<?php echo esc_attr( $legacy_videography_header_text_color ); ?>;
                    }
                <?php elseif ('' !== $legacy_videography_header_text_color) : ?>
                    .site-title a,.site-description {
                        color: #<?php echo esc_attr($legacy_videography_header_text_color); ?>;
                    }            
                <?php endif; ?>
        </style>
    <?php
        }
    }
// site-title-checkbox
// Remove "Display Site Title and Tagline" checkbox from Customizer
function legacy_videography_remove_header_text_display_checkbox( $wp_customize ) {
    $wp_customize->remove_control( 'display_header_text' ); // Removes the checkbox
}
add_action( 'customize_register', 'legacy_videography_remove_header_text_display_checkbox', 11 );

/**
* Custom logo
*/
function legacy_videography_logo_setup(){
    add_theme_support('custom-logo', array(
        'height' => 65,
        'width' => 350,
        'flex-height' => true,
        'flex-width' => true,
    ));
}
add_action('after_setup_theme', 'legacy_videography_logo_setup');

// logo resizer
function legacy_videography_logo_dynamic_css() {
    $legacy_videography_logo_width = get_theme_mod( 'legacy_videography_logo_width', 150 );
    ?>
    <style type="text/css">
        .logo .custom-logo {
            max-width: <?php echo esc_attr( $legacy_videography_logo_width ); ?>px;
            height: auto;
        }
    </style>
    <?php
}
add_action( 'wp_head', 'legacy_videography_logo_dynamic_css' );

// buttons
function legacy_videography_custom_button_styles() {
    $legacy_videography_radius = get_theme_mod( 'legacy_videography_button_border_radius', '6px' );
    $legacy_videography_padding = get_theme_mod( 'legacy_videography_button_padding', '10px 35px' );
    ?>
    <style type="text/css">
        .btn,
        .button,
        button,
        input[type="submit"],
        .wp-block-button__link,#blog-section .read-more a,.read-more a,a.btn-slid.btn {
            border-radius: <?php echo esc_attr($legacy_videography_radius); ?>;
            padding: <?php echo esc_attr($legacy_videography_padding); ?>;
        }
    </style>
    <?php
}
add_action( 'wp_head', 'legacy_videography_custom_button_styles' );

function legacy_videography_customize_fonts() {
    $legacy_videography_body_font = get_theme_mod('legacy_videography_body_font_family', 'Jost, serif');
    $legacy_videography_heading_font = get_theme_mod('legacy_videography_heading_font_family', 'Jost, serif');

    // Extract Google font names (e.g., Roboto from "Roboto, sans-serif")
    $legacy_videography_body_font_name = trim(explode(',', $legacy_videography_body_font)[0]);
    $legacy_videography_heading_font_name = trim(explode(',', $legacy_videography_heading_font)[0]);

    // Generate Google Fonts URL
    $legacy_videography_google_font_url = 'https://fonts.googleapis.com/css2?family=' . urlencode($legacy_videography_body_font_name) . '&family=' . urlencode($legacy_videography_heading_font_name) . '&display=swap';

    // Enqueue fonts
    wp_enqueue_style('legacy-videography-fonts', $legacy_videography_google_font_url, array(), null);

    // Custom inline style for font application
    $custom_css = "
        body, p, span, label, div {
            font-family: {$legacy_videography_body_font};
        }
        h1, h2, h3, h4, h5, h6 {
            font-family: {$legacy_videography_heading_font};
        }
    ";
    wp_add_inline_style('legacy-videography-fonts', $custom_css);
}
add_action('wp_enqueue_scripts', 'legacy_videography_customize_fonts');

// page title box
function legacy_videography_page_title_dynamic_styles() {
    $bg_type = get_theme_mod('legacy_videography_page_bg_radio', '');
    $bg_color = get_theme_mod('legacy_videography_page_bg_color', '');
    $bg_image = get_theme_mod('legacy_videography_page_bg_image', '');
    $global_color = get_theme_mod('legacy_videography_global_color1', '#FC6900');

    $legacy_videography_dynamic_css = '';

    if ($bg_type === 'image' && !empty($bg_image)) {
        $legacy_videography_dynamic_css .= '.page-title {';
        $legacy_videography_dynamic_css .= 'background-image: url("' . esc_url($bg_image) . '");';
        $legacy_videography_dynamic_css .= 'background-size: cover;';
        $legacy_videography_dynamic_css .= 'background-position: center;';
        $legacy_videography_dynamic_css .= '}';
    } elseif ($bg_type === 'color' && !empty($bg_color)) {
        $legacy_videography_dynamic_css .= '.page-title {';
        $legacy_videography_dynamic_css .= 'background-color: ' . esc_attr($bg_color) . ';';
        $legacy_videography_dynamic_css .= '}';
    } else {
        // Fallback to global theme color
        $legacy_videography_dynamic_css .= '.page-title {';
        $legacy_videography_dynamic_css .= 'background-color: ' . esc_attr($global_color) . ';';
        $legacy_videography_dynamic_css .= '}';
    }

    if (!empty($legacy_videography_dynamic_css)) {
        echo '<style type="text/css">' . $legacy_videography_dynamic_css . '</style>';
    }
}
add_action('wp_head', 'legacy_videography_page_title_dynamic_styles', 20);