<?php
/**
 * Theme Customizer Controls
 *
 * @package Legacy Videography
 */

if ( ! function_exists( 'legacy_videography_customizer_page_register' ) ) :
function legacy_videography_customizer_page_register( $wp_customize ) {
 
 	$wp_customize->add_section(
        'legacy_videography_page_settings',
        array (
            'priority'      => 25,
            'capability'    => 'edit_theme_options',
            'title'         => esc_html__( 'Page Settings', 'legacy-videography' )
        )
    );

    // Info label
     $wp_customize->add_setting( 
        'legacy_videography_label_page_title_hide_settings', 
        array(
            'sanitize_callback' => 'legacy_videography_sanitize_title',
        ) 
    );

    $wp_customize->add_control( 
        new Legacy_Videography_Title_Info_Control( $wp_customize, 'legacy_videography_label_page_title_hide_settings', 
        array(
            'label'       => esc_html__( 'Hide Page Title', 'legacy-videography' ),
            'section'     => 'legacy_videography_page_settings',
            'type'        => 'legacy-videography-title',
            'settings'    => 'legacy_videography_label_page_title_hide_settings',
        ) 
    ));  

    // Hide page title section
    $wp_customize->add_setting(
        'legacy_videography_enable_page_title',
        array(
            'type' => 'theme_mod',
            'default'           => true,
            'sanitize_callback' => 'legacy_videography_sanitize_checkbox'
        )
    );

    $wp_customize->add_control(
        new Legacy_Videography_Toggle_Control( $wp_customize, 'legacy_videography_enable_page_title', 
        array(
            'settings'      => 'legacy_videography_enable_page_title',
            'section'       => 'legacy_videography_page_settings',
            'type'          => 'legacy-videography-toggle',
            'label'         => esc_html__( 'Show Page Title Section:', 'legacy-videography' ),
            'description'   => '',           
        )
    ));

    // Info label
    $wp_customize->add_setting( 
        'legacy_videography_label_page_title_bg_settings', 
        array(
            'sanitize_callback' => 'legacy_videography_sanitize_title',
        ) 
    );

    $wp_customize->add_control( 
        new Legacy_Videography_Title_Info_Control( $wp_customize, 'legacy_videography_label_page_title_bg_settings', 
        array(
            'label'       => esc_html__( 'Page Title Background', 'legacy-videography' ),
            'section'     => 'legacy_videography_page_settings',
            'type'        => 'title',
            'settings'    => 'legacy_videography_label_page_title_bg_settings',
            'active_callback' => 'legacy_videography_page_title_enable',
        ) 
    ));

    // Background selection
    $wp_customize->add_setting(
        'legacy_videography_page_bg_radio',
        array(
            'type' => 'theme_mod',
            'default'           => 'color',
            'sanitize_callback' => 'legacy_videography_sanitize_select'
        )
    );

    $wp_customize->add_control(
    	new Legacy_Videography_Text_Radio_Control( $wp_customize, 'legacy_videography_page_bg_radio',
        array(
            'settings'      => 'legacy_videography_page_bg_radio',
            'section'       => 'legacy_videography_page_settings',
            'type'          => 'radio',
            'label'         => esc_html__( 'Choose Page Title Background Color or Background Image:', 'legacy-videography' ),
            'description'   => esc_html__('This setting will change the background of the page title area.', 'legacy-videography'),
            'choices' => array(
                            'color' => esc_html__('Background Color','legacy-videography'),
                            'image' => esc_html__('Background Image','legacy-videography'),
                            ),
            'active_callback' => 'legacy_videography_page_title_enable',
        )
    ));

    // Background color
    $wp_customize->add_setting(
        'legacy_videography_page_bg_color',
        array(
            'type' => 'theme_mod',
            'default'           => '',
            'sanitize_callback' => 'sanitize_hex_color'
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'legacy_videography_page_bg_color',
            array(
                'label'      => esc_html__( 'Select Background Color', 'legacy-videography' ),
                'description'   => esc_html__('This setting will add background color to the page title area if Background Color was selected above.', 'legacy-videography'),
                'section'    => 'legacy_videography_page_settings',
                'settings'   => 'legacy_videography_page_bg_color',
                'active_callback' => 'legacy_videography_page_title_color_enable',
            )
        )
    );

    // Background image
    $wp_customize->add_setting(
        'legacy_videography_page_bg_image',
        array(
            'type' => 'theme_mod',
            'sanitize_callback' => 'esc_url_raw'
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Image_Control(
            $wp_customize,
            'legacy_videography_page_bg_image',
            array(
                'label'       => esc_html__( 'Upload Background Image', 'legacy-videography' ),
                'description' => esc_html__('This setting will add a background image to the page title area if Background Image was selected above.', 'legacy-videography'),
                'section'     => 'legacy_videography_page_settings',
                'settings'    => 'legacy_videography_page_bg_image',
                'active_callback' => 'legacy_videography_page_title_image_enable',
            )
        )
    );
    
}
endif;

add_action( 'customize_register', 'legacy_videography_customizer_page_register' );