<?php
/**
 * Theme Customizer Controls
 *
 * @package Legacy Videography
 */

if ( ! function_exists( 'legacy_videography_customizer_footer_register' ) ) :
function legacy_videography_customizer_footer_register( $wp_customize ) {
 	
 	$wp_customize->add_section(
        'legacy_videography_footer_settings',
        array (
            'priority'      => 30,
            'capability'    => 'edit_theme_options',
            'title'         => esc_html__( 'Footer Settings', 'legacy-videography' )
        )
    );

    // Title label
	$wp_customize->add_setting( 
		'legacy_videography_label_footer_settings_title', 
		array(
		    'sanitize_callback' => 'legacy_videography_sanitize_title',
		) 
	);

	$wp_customize->add_control( 
		new Legacy_Videography_Title_Info_Control( $wp_customize, 'legacy_videography_label_footer_settings_title', 
		array(
		    'label'       => esc_html__( 'Footer Settings', 'legacy-videography' ),
		    'section'     => 'legacy_videography_footer_settings',
		    'type'        => 'legacy-videography-title',
		    'settings'    => 'legacy_videography_label_footer_settings_title',
		) 
	));

	// Copyright text
    $wp_customize->add_setting(
        'legacy_videography_footer_copyright_text',
        array(
            'type' => 'theme_mod',
            'sanitize_callback' => 'legacy_videography_sanitize_textarea_field'
        )
    );

    $wp_customize->add_control(
        'legacy_videography_footer_copyright_text',
        array(
            'settings'      => 'legacy_videography_footer_copyright_text',
            'section'       => 'legacy_videography_footer_settings',
            'type'          => 'textarea',
            'label'         => esc_html__( 'Footer Copyright Text', 'legacy-videography' )
        )
    );
}
endif;

add_action( 'customize_register', 'legacy_videography_customizer_footer_register' );