<?php
/**
 * Theme Customizer Controls
 *
 * @package Legacy Videography
 */

if ( ! function_exists( 'legacy_videography_customizer_home_destination_register' ) ) :
function legacy_videography_customizer_home_destination_register( $wp_customize ) {

    $wp_customize->add_section(
        'legacy_videography_home_destination_settings',
        array (
            'priority'      => 25,
            'capability'    => 'edit_theme_options',
            'title'         => esc_html__( 'Team Settings', 'legacy-videography' )
        )
    );

    // Title label
    $wp_customize->add_setting( 
        'legacy_videography_label_product_settings_title', 
        array(
            'sanitize_callback' => 'legacy_videography_sanitize_title',
        ) 
    );

    $wp_customize->add_control( 
        new Legacy_Videography_Title_Info_Control( $wp_customize, 'legacy_videography_label_product_settings_title', 
        array(
            'label'       => esc_html__( 'Team Settings', 'legacy-videography' ),
            'section'     => 'legacy_videography_home_destination_settings',
            'type'        => 'legacy-videography-title',
            'settings'    => 'legacy_videography_label_product_settings_title',
        ) 
    ));

    $wp_customize->add_setting(
        'legacy_videography_destination_small_heading',
        array(
            'default'           => '',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );

    $wp_customize->add_control(
        'legacy_videography_destination_small_heading',
        array(
            'label'           => sprintf( esc_html__( 'Small Heading', 'legacy-videography' ), ),
            'section'         => 'legacy_videography_home_destination_settings',
            'settings'        => 'legacy_videography_destination_small_heading' ,
            'type'            => 'text',
        )
    );

    $wp_customize->add_setting(
        'legacy_videography_destination_main_heading',
        array(
            'default'           => '',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );

    $wp_customize->add_control(
        'legacy_videography_destination_main_heading',
        array(
            'label'           => sprintf( esc_html__( 'Main Heading', 'legacy-videography' ), ),
            'section'         => 'legacy_videography_home_destination_settings',
            'settings'        => 'legacy_videography_destination_main_heading' ,
            'type'            => 'text',
        )
    );
}
endif;

add_action( 'customize_register', 'legacy_videography_customizer_home_destination_register' );