<?php
/**
 * Theme Customizer Controls
 *
 * @package Legacy Videography
 */

if ( ! function_exists( 'legacy_videography_customizer_home_banner_register' ) ) :
function legacy_videography_customizer_home_banner_register( $wp_customize ) {
 	
 	$wp_customize->add_section(
        'legacy_videography_home_banner_settings',
        array (
            'priority'      => 25,
            'capability'    => 'edit_theme_options',
            'title'         => esc_html__( 'Banner Settings', 'legacy-videography' )
        )
    );

    // Title label
	$wp_customize->add_setting( 
		'legacy_videography_label_banner_settings_title', 
		array(
		    'sanitize_callback' => 'legacy_videography_sanitize_title',
		) 
	);

	$wp_customize->add_control( 
		new Legacy_Videography_Title_Info_Control( $wp_customize, 'legacy_videography_label_banner_settings_title', 
		array(
		    'label'       => esc_html__( 'Banner Settings', 'legacy-videography' ),
		    'section'     => 'legacy_videography_home_banner_settings',
		    'type'        => 'legacy-videography-title',
		    'settings'    => 'legacy_videography_label_banner_settings_title',
		) 
	));

    // Hide page title section
    $wp_customize->add_setting(
        'legacy_videography_home_enable_banner_settings',
        array(
            'type' => 'theme_mod',
            'default'           => false,
            'sanitize_callback' => 'legacy_videography_sanitize_checkbox'
        )
    );

    $wp_customize->add_control(
        new Legacy_Videography_Toggle_Control( $wp_customize, 'legacy_videography_home_enable_banner_settings', 
        array(
            'settings'      => 'legacy_videography_home_enable_banner_settings',
            'section'       => 'legacy_videography_home_banner_settings',
            'type'          => 'legacy-videography-toggle',
            'label'         => esc_html__( 'Show Banner Settings', 'legacy-videography' ),
            'description'   => '',           
        )
    ));

     $wp_customize->add_setting('legacy_videography_slide_number',array(
        'default' => '',
        'sanitize_callback' => 'legacy_videography_sanitize_number',
    ));
    $wp_customize->add_control('legacy_videography_slide_number',array(
        'label' => __('Number of slides to show','legacy-videography'),
        'section' => 'legacy_videography_home_banner_settings',
        'type'    => 'number',
        'input_attrs' => array(
            'min'  => 1,
            'max'  => 5,
        ),
    ));
      $legacy_videography_banner_count =  get_theme_mod('legacy_videography_slide_number');

        for($i=1; $i<=$legacy_videography_banner_count; $i++ ) {  

    // Button Image
    $wp_customize->add_setting(
        'legacy_videography_slide_image'.$i,
        array(
            'default'           => '',
            'sanitize_callback' => 'legacy_videography_sanitize_image',

        )
    );
    
    $wp_customize->add_control(
        new WP_Customize_Image_Control(
            $wp_customize, 'legacy_videography_slide_image'.$i, 
            array(
                'label'           => sprintf( esc_html__( 'Banner Image ', 'legacy-videography' ).$i, ),
                'settings'  => 'legacy_videography_slide_image'.$i,
                'section'   => 'legacy_videography_home_banner_settings'
            ) 
        )
    );

    // Banner Heading
    $wp_customize->add_setting(
        'legacy_videography_slide_sub_heading'.$i,
        array(
            'default'           => '',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );

    $wp_customize->add_control(
        'legacy_videography_slide_sub_heading'.$i,
        array(
            'label'           => sprintf( esc_html__( 'Short Banner Heading ', 'legacy-videography' ).$i, ),
            'section'         => 'legacy_videography_home_banner_settings',
            'settings'        => 'legacy_videography_slide_sub_heading'.$i ,
            'type'            => 'text',
        )
    );

    // Banner Heading
	$wp_customize->add_setting(
        'legacy_videography_slide_heading'.$i,
        array(
            'default'           => '',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );

    $wp_customize->add_control(
        'legacy_videography_slide_heading'.$i,
        array(
            'label'           => sprintf( esc_html__( 'Banner Heading ', 'legacy-videography' ).$i, ),
            'section'         => 'legacy_videography_home_banner_settings',
            'settings'        => 'legacy_videography_slide_heading'.$i ,
            'type'            => 'text',
        )
    );

    // Banner Heading
    $wp_customize->add_setting(
        'legacy_videography_slide_text'.$i,
        array(
            'default'           => '',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );

    $wp_customize->add_control(
        'legacy_videography_slide_text'.$i,
        array(
            'label'           => sprintf( esc_html__( 'Banner Text ', 'legacy-videography' ).$i, ),
            'section'         => 'legacy_videography_home_banner_settings',
            'settings'        => 'legacy_videography_slide_text'.$i ,
            'type'            => 'text',
        )
    );

    // banner Button
    $wp_customize->add_setting(
        'legacy_videography_slide_btntext'.$i,
        array(
            'default'           => '',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );

    $wp_customize->add_control(
        'legacy_videography_slide_btntext'.$i,
        array(
            'label'           => sprintf( esc_html__( 'Banner Button Text ', 'legacy-videography' ).$i, ),
            'section'         => 'legacy_videography_home_banner_settings',
            'settings'        => 'legacy_videography_slide_btntext'.$i ,
            'type'            => 'text',
        )
    );

    // banner Button
    $wp_customize->add_setting(
        'legacy_videography_slide_btnurl'.$i,
        array(
            'default'           => '',
            'sanitize_callback' => 'esc_url_raw',
        )
    );

    $wp_customize->add_control(
        'legacy_videography_slide_btnurl'.$i,
        array(
            'label'           => sprintf( esc_html__( 'Banner Button Link ', 'legacy-videography' ).$i, ),
            'section'         => 'legacy_videography_home_banner_settings',
            'settings'        => 'legacy_videography_slide_btnurl'.$i ,
            'type'            => 'url',
        )
    );

    }
}
endif;

add_action( 'customize_register', 'legacy_videography_customizer_home_banner_register' );