<?php
/**
 * @package Legacy Videography
 */

/**
 * Footer
 */
if (! function_exists( 'legacy_videography_footer_copyrights' ) ):
    function legacy_videography_footer_copyrights() {
        ?>
            <div class="row">
                <div class="copyrights">
                    <p>
                        <?php
                            if("" != esc_html(get_theme_mod( 'legacy_videography_footer_copyright_text'))) :
                                echo esc_html(get_theme_mod( 'legacy_videography_footer_copyright_text'));
                                if(get_theme_mod('legacy_videography_en_footer_credits',true)) :
                                    ?> 
                                    <span class="copyrg-link"><a href="<?php echo esc_url(LEGACY_VIDEOGRAPHY_AUT); ?>" target="_blank" rel="nofollow noopener"><?php esc_html_e(' | Legacy Videography WordPress Theme','legacy-videography') ?></a><?php esc_html_e(' by Legacy Themes','legacy-videography') ?></span>
                                    <?php   
                                endif;
                            else :
                                echo date_i18n(
                                    /* translators: Copyright date format, see https://secure.php.net/date */
                                    _x( 'Y', 'copyright date format', 'legacy-videography' )
                                );
                                ?>
                                    <a href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php bloginfo( 'name' ); ?></a>
                                    <span class="copyrg-link"><a href="<?php echo esc_url(LEGACY_VIDEOGRAPHY_AUT); ?>" target="_blank" rel="nofollow noopener"><?php esc_html_e(' | Legacy Videography WordPress Theme','legacy-videography') ?></a><?php esc_html_e(' by Legacy Themes','legacy-videography') ?></span>
                                <?php
                            endif;
                        ?>
                    </p>
                </div>
            </div>
        <?php    
    }
endif;
add_action( 'legacy_videography_action_footer', 'legacy_videography_footer_copyrights' );

/**
 * Page Title Settings
 */
if ( ! function_exists( 'legacy_videography_show_page_title' ) ) :
    function legacy_videography_show_page_title() {
        if ( ! is_front_page() ) {
            ?>
            <div class="page-title"> 
                <div class="content-section img-overlay">
                    <div class="container">
                        <div class="row text-center">
                            <div class="col-md-12">
                                <div class="section-title"> 
                                    <?php
                                    // WooCommerce Pages
                                    if ( function_exists( 'is_shop' ) && is_shop() ) {
                                        // Shop Page
                                        echo '<h1 class="main-title">' . esc_html__( 'Shop Page', 'legacy-videography' ) . '</h1>';

                                    } elseif ( function_exists( 'is_product' ) && is_product() ) {
                                        // Single Product Page
                                        echo '<h1 class="main-title">' . esc_html__( 'Single Product Page', 'legacy-videography' ) . '</h1>';

                                    } elseif ( function_exists( 'is_checkout' ) && is_checkout() ) {
                                        // Checkout Page
                                        echo '<h1 class="main-title">' . esc_html__( 'Checkout', 'legacy-videography' ) . '</h1>';

                                    } elseif ( function_exists( 'is_account_page' ) && is_account_page() ) {
                                        // My Account Page
                                        echo '<h1 class="main-title">' . esc_html__( 'My Account', 'legacy-videography' ) . '</h1>';

                                    } elseif ( is_home() ) {
                                        // Blog Index Page
                                        echo '<h1 class="main-title">' . esc_html__( 'Blog Page', 'legacy-videography' ) . '</h1>';

                                    } elseif ( is_singular( 'post' ) ) {
                                        // Single Blog Post
                                        echo '<h1 class="main-title">' . get_the_title() . '</h1>';

                                    } elseif ( is_category() ) {
                                        echo '<h1 class="main-title">' . single_cat_title( '', false ) . '</h1>';

                                    } elseif ( is_tag() ) {
                                        echo '<h1 class="main-title">' . single_tag_title( '', false ) . '</h1>';

                                    } elseif ( is_author() ) {
                                        echo '<h1 class="main-title">' . get_the_author() . '</h1>';

                                    } elseif ( is_archive() ) {
                                        echo '<h1 class="main-title">' . get_the_archive_title() . '</h1>';

                                    } elseif ( is_search() ) {
                                        echo '<h1 class="main-title">' . esc_html__( 'Search Results', 'legacy-videography' ) . '</h1>';

                                    } elseif ( is_404() ) {
                                        echo '<h1 class="main-title">' . esc_html__( 'Page Not Found', 'legacy-videography' ) . '</h1>';

                                    } else {
                                        // Default for all other pages
                                        echo '<h1 class="main-title">' . get_the_title() . '</h1>';
                                    }
                                    ?>
                                </div>                      
                            </div>
                        </div>
                    </div>  
                </div>
            </div>  <!-- End page-title --> 
            <?php
        }
    }
endif;

// Register page title action globally
add_action( 'legacy_videography_get_page_title', 'legacy_videography_show_page_title' );


/**
 * Home Banner Section
 */
if (! function_exists( 'legacy_videography_home_banner_section' ) ):
    function legacy_videography_home_banner_section() {
        if (true === get_theme_mod('legacy_videography_home_enable_banner_settings', false)) : ?>

            <section id="main-banner-wrap" class="life-coach-slider">
                <div class="slider-sec">
                    <div class="owl-carousel main-slider">
                        <?php 
                        $legacy_videography_slide_number = get_theme_mod("legacy_videography_slide_number"); 
                        for ($i = 1; $i <= $legacy_videography_slide_number; $i++) { 
                            $legacy_videography_slide_image = get_theme_mod('legacy_videography_slide_image'.$i, '');
                            if (!empty($legacy_videography_slide_image)) { ?>
                                <div class="slide-item position-relative">
                                    <img class="slide-bg" src="<?php echo esc_url($legacy_videography_slide_image); ?>">
                                    <div class="slide-content">
                                        <?php 
                                        // Sub Heading
                                        $legacy_videography_sub_heading = get_theme_mod('legacy_videography_slide_sub_heading'.$i, '');
                                        if (!empty($legacy_videography_sub_heading)) { ?>
                                            <h6 class="slider-sub-heading"><i class="bi bi-camera-video-fill me-2"></i><?php echo esc_html($legacy_videography_sub_heading); ?></h6>
                                        <?php } ?>

                                        <?php 
                                        // Main Heading
                                        $legacy_videography_heading = get_theme_mod('legacy_videography_slide_heading'.$i, '');
                                        if (!empty($legacy_videography_heading)) { ?>
                                            <h1 class="slider-heading"><?php echo esc_html($legacy_videography_heading); ?></h1>
                                        <?php } ?>

                                        <?php 
                                        // Paragraph
                                        $legacy_videography_paragraph = get_theme_mod('legacy_videography_slide_text'.$i, '');
                                        if (!empty($legacy_videography_paragraph)) { ?>
                                            <p class="slider-paragraph"><?php echo esc_html($legacy_videography_paragraph); ?></p>
                                        <?php } ?>  

                                        <?php 
                                        // Button
                                        $legacy_videography_button_url  = get_theme_mod('legacy_videography_slide_btnurl'.$i, '');
                                        $legacy_videography_button_text = get_theme_mod('legacy_videography_slide_btntext'.$i, '');
                                        if (!empty($legacy_videography_button_url) || !empty($legacy_videography_button_text)) { ?>
                                            <a class="slider-button btn" href="<?php echo esc_url($legacy_videography_button_url); ?>">
                                                <?php echo esc_html($legacy_videography_button_text); ?>
                                            </a>
                                        <?php } ?>  
                                    </div>
                                </div>
                            <?php }
                        } ?>
                    </div>
                </div>
            </section>
    <?php endif;
    }
endif;
add_action( 'legacy_videography_action_home_banner', 'legacy_videography_home_banner_section' );


/**
 * Home destination Section
 */
if ( ! function_exists( 'legacy_videography_home_team_section' ) ) :
    function legacy_videography_home_team_section() {
        ?>
        <section id="destination-wrap" class="py-5">
            <div class="container">
                <div class="inner-wrap">
                    <div class="destination-head-box text-center mb-5">
                        <?php
                        $legacy_videography_destination_small_heading = get_theme_mod( 'legacy_videography_destination_small_heading', 'Our Team' );
                        if ( ! empty( $legacy_videography_destination_small_heading ) ) { ?>
                            <h6 class="destn-sm-hd"><i class="bi bi-camera-video-fill me-2"></i><?php echo esc_html( $legacy_videography_destination_small_heading ); ?></h6>
                        <?php } ?>

                        <?php
                        $legacy_videography_destination_main_heading = get_theme_mod( 'legacy_videography_destination_main_heading', 'Our Best Videographer' );
                        if ( ! empty( $legacy_videography_destination_main_heading ) ) { ?>
                            <h3 class="destn-main-hd pt-0"><?php echo esc_html( $legacy_videography_destination_main_heading ); ?></h3>
                        <?php } ?>
                    </div>

                    <div class="destination-box">
                        <div class="owl-carousel center-slider">
                            <?php
                                $legacy_videography_post_query5 = new WP_Query(array( 
                                    'post_type'      => 'team',
                                    'posts_per_page' => 6,
                                ));

                                $i=1;
                                while( $legacy_videography_post_query5->have_posts() ) : 
                                    $legacy_videography_post_query5->the_post(); ?>
                                    
                                    <div class="destination-inn text-center">
                                        <div class="img-box-destn">
                                            <?php 
                                            if ( has_post_thumbnail() ) { 
                                                echo get_the_post_thumbnail( get_the_ID(), 'full' ); 
                                            } else { 
                                                echo '<img src="' . esc_url( get_template_directory_uri() . '/img/team.png' ) . '"/>';
                                            } 
                                            ?>
                                            <div class="box-content">
                                                <h4 class="title mb-0 p-0">    
                                                    <a href="<?php echo esc_url( get_permalink() ); ?>"><?php the_title(); ?></a>
                                                </h4>

                                                <?php 
                                                $terms = get_the_terms( get_the_ID(), 'team_designation' ); 
                                                if ( ! empty( $terms ) && ! is_wp_error( $terms ) ) {
                                                    echo '<div class="category-div">';
                                                    foreach ( $terms as $term ) {
                                                        echo '<a href="' . esc_url( get_term_link( $term ) ) . '"><span>' . esc_html( $term->name ) . '</span></a>';

                                                    }
                                                    echo '</div>';
                                                }
                                                ?>
                                                <?php
                                                    // Get social links for this member
                                                    $social_links = get_post_meta( get_the_ID(), 'social', true );

                                                    if ( ! empty( $social_links ) ) {
                                                        echo '<div class="team-social-icons">';
                                                        foreach ( $social_links as $link ) {
                                                            $id  = isset( $link['id'] ) ? $link['id'] : '';
                                                            $url = isset( $link['url'] ) ? $link['url'] : '';

                                                            if ( $url ) {
                                                                // Print social icon (FontAwesome)
                                                                echo '<a href="' . esc_url( $url ) . '" target="_blank" rel="noopener">';
                                                                echo '<i class="fab fa-' . esc_attr( $id ) . '"></i>';
                                                                echo '</a>';
                                                            }
                                                        }
                                                        echo '</div>';
                                                    }
                                                    ?>
                                            </div>
                                        </div>
                                    </div>

                                <?php 
                                $i++;
                                endwhile;
                                wp_reset_postdata();
                                ?>
                        </div> 
                    </div>
                </div>                
            </div>
        </section>
        <?php    
    }
endif;
add_action( 'legacy_videography_action_home_team', 'legacy_videography_home_team_section' );

/**
 * Home page another adding Section
 */
if (! function_exists( 'legacy_videography_home_extra_section' ) ):
    function legacy_videography_home_extra_section() {
        ?>
        <div id="custom-home-extra-content">
            <div class="container">
              <?php while ( have_posts() ) : the_post(); ?>
                <?php the_content(); ?>
              <?php endwhile; ?>
            </div>
        </div>
        <?php    
    }
endif;
add_action( 'legacy_videography_action_home_extra', 'legacy_videography_home_extra_section' );