<?php
/**
 * Template part for displaying header menu
 *
 * @package Legacy Videography
 */

?>
<?php
    $legacy_videography_page_val= is_front_page() ? 'home':'page' ;

?>

<header id="<?php echo esc_attr($legacy_videography_page_val);?>-inner" class="elementer-menu-anchor theme-menu-wrapper full-width-menu style1 page" role="banner">
    <?php
        if(true===get_theme_mod('legacy_videography_enable_highlighted area',true) && is_front_page()){
            ?><a class="skip-link screen-reader-text" href="#content"><?php esc_html_e('skip to content','legacy-videography'); ?> </a> <?php
        }
        else{
        ?><a class="skip-link screen-reader-text" href="#main"><?php esc_html_e('skip to content','legacy-videography');?></a> <?php
    }
    ?>
    <div id="header-main" class="header-wrapper">
        <div id="custom-header">
            <?php if ( display_header_text() ) : ?>
            <div id="topbar">
                <div class="container">
                    <div class="header-top-main py-2">
                        <div class="ri8-logo">
                            <div class="logo <?php echo (has_custom_logo() ? 'has-logo' : 'no-logo'); ?>" itemscope itemtype="https://schema.org/Organization">
                                <?php 
                                    // Display custom logo if available
                                    if ( has_custom_logo() ) {
                                        legacy_videography_custom_logo();
                                    }

                                    // Display sticky header logo if enabled
                                    if ( get_theme_mod( 'legacy_videography_enable_logo_stickyheader', false ) ) {
                                        $legacy_videography_alt_logo = esc_url( get_theme_mod( 'legacy_videography_logo_stickyheader' ) );
                                        if ( ! empty( $legacy_videography_alt_logo ) ) {
                                            ?>
                                            <a id="logo-alt" class="logo-alt" href="<?php echo esc_url( home_url( '/' ) ); ?>">
                                                <img src="<?php echo esc_url( $legacy_videography_alt_logo ); ?>" alt="<?php esc_attr_e( 'logo', 'legacy-videography' ); ?>">
                                            </a>
                                            <?php
                                        }
                                    }

                                    // Site title and tagline settings
                                    $legacy_videography_show_title   = get_theme_mod( 'legacy_videography_display_site_title', true );
                                    $legacy_videography_show_tagline = get_theme_mod( 'legacy_videography_display_site_tagline', false );
                                    $legacy_videography_header_class = $legacy_videography_show_title ? 'site-title' : 'screen-reader-text';

                                    // Display site title
                                    if ( $legacy_videography_show_title && get_bloginfo( 'name' ) ) {
                                        if ( is_front_page() ) {
                                            ?>
                                            <h1 class="<?php echo esc_attr( $legacy_videography_header_class ); ?>">
                                                <a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php echo esc_html( get_bloginfo( 'name' ) ); ?></a>
                                            </h1>
                                            <?php
                                        } else {
                                            ?>
                                            <p class="<?php echo esc_attr( $legacy_videography_header_class ); ?>">
                                                <a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php echo esc_html( get_bloginfo( 'name' ) ); ?></a>
                                            </p>
                                            <?php
                                        }
                                    }

                                    // Display tagline
                                    if ( $legacy_videography_show_tagline ) {
                                        $legacy_videography_description = get_bloginfo( 'description', 'display' );
                                        if ( $legacy_videography_description || is_customize_preview() ) {
                                            ?>
                                            <p class="site-description"><?php echo esc_html( $legacy_videography_description ); ?></p>
                                            <?php
                                        }
                                    }
                                ?>
                            </div>
                        </div>
                        <div class="ri8-right-box">
                            <div class="row">
                                <div class="col-xl-8 col-lg-8 col-md-8 col-12 text-center text-lg-start text-md-start align-self-center ri8-mail">
                                    <?php $legacy_videography_topbar_email_address = get_theme_mod('legacy_videography_topbar_email_address', 'videographer@example.com' );
                                                if ( ! empty( $legacy_videography_topbar_email_address ) ) { ?>
                                        <span class="tbr-adrs mb-0 me-5"><i class="bi bi-envelope-fill me-2"></i>
                                            <?php echo esc_html( $legacy_videography_topbar_email_address ); ?></span>
                                    <?php } ?>
                                    <?php $legacy_videography_topbar_phone_no = get_theme_mod('legacy_videography_topbar_phone_no', '+001 122 334 455' );
                                        if ( ! empty( $legacy_videography_topbar_phone_no ) ) { ?>
                                        <span class="tbr-call-no mb-0 mb-lg-0"><i class="bi bi-telephone-fill mail-icon me-2"></i>
                                            <?php echo esc_html( $legacy_videography_topbar_phone_no ); ?></span>
                                    <?php } ?>
                                </div>
                                <div class="col-xl-4 col-lg-4 col-md-4 col-12 align-self-center text-center text-lg-end text-md-end ri8-soco">
                                    <div class="follow-us my-2 my-lg-0">
                                        <?php
                                            $legacy_videography_social_media1_heading = get_theme_mod( 'legacy_videography_social_media1_heading', 'www.facebook.com' );
                                            if ( ! empty( $legacy_videography_social_media1_heading ) ) { ?>
                                            <a href="<?php echo esc_url( $legacy_videography_social_media1_heading ); ?>"><i class="bi bi-facebook me-3"></i></a>
                                        <?php } ?>
                                        <?php
                                            $legacy_videography_social_media2_heading = get_theme_mod( 'legacy_videography_social_media2_heading', 'www.instagram.com' );
                                            if ( ! empty( $legacy_videography_social_media2_heading ) ) { ?>
                                            <a href="<?php echo esc_url( $legacy_videography_social_media2_heading ); ?>"><i class="bi bi-instagram me-3"></i></a>
                                        <?php } ?>
                                        <?php
                                            $legacy_videography_social_media3_heading = get_theme_mod( 'legacy_videography_social_media3_heading', 'www.twitter.com' );
                                            if ( ! empty( $legacy_videography_social_media3_heading ) ) { ?>
                                            <a href="<?php echo esc_url( $legacy_videography_social_media3_heading ); ?>"><i class="bi bi-twitter-x me-3"></i></a>
                                        <?php } ?>
                                        <?php
                                            $legacy_videography_social_media4_heading = get_theme_mod( 'legacy_videography_social_media4_heading', 'www.youtube.com' );
                                            if ( ! empty( $legacy_videography_social_media4_heading ) ) { ?>
                                            <a href="<?php echo esc_url( $legacy_videography_social_media4_heading ); ?>"><i class="bi bi-youtube me-3"></i></a>
                                        <?php } ?>
                                        <?php
                                            $legacy_videography_social_media5_heading = get_theme_mod( 'legacy_videography_social_media5_heading', 'www.pinterest.com' );
                                            if ( ! empty( $legacy_videography_social_media5_heading ) ) { ?>
                                            <a href="<?php echo esc_url( $legacy_videography_social_media5_heading ); ?>"><i class="bi bi-pinterest me-3"></i></a>
                                        <?php } ?>
                                        <?php
                                            $legacy_videography_social_media6_heading = get_theme_mod( 'legacy_videography_social_media6_heading', 'www.linkedin.com' );
                                            if ( ! empty( $legacy_videography_social_media6_heading ) ) { ?>
                                            <a href="<?php echo esc_url( $legacy_videography_social_media6_heading ); ?>"><i class="bi bi-linkedin me-3"></i></a>
                                        <?php } ?>
                                    </div>
                                </div>
                            </div>
                            <div class="header-main-1">
                            <div class="header-bg"></div>
                                <div class="row  m-0 py-2">
                                    <div class="col-lg-8 col-md-3 col-6 align-self-center"> 
                                        <div class="top-menu-wrapper">
                                            <div class="navigation_header">
                                                <div class="toggle-nav mobile-menu">
                                                    <button onclick="legacy_videography_openNav()"><i class="bi bi-list"></i></button>
                                                </div>
                                                <div id="mySidenav" class="nav sidenav">
                                                    <nav id="site-navigation" class="main-navigation navbar navbar-expand-xl" aria-label="<?php esc_attr_e( 'Top Menu', 'legacy-videography' ); ?>">
                                                        <?php {
                                                                wp_nav_menu(
                                                                    array(
                                                                        'theme_location' => 'primary',
                                                                        'container_class' => 'navi clearfix navbar-nav' ,
                                                                        'menu_class'     => 'menu clearfix', 
                                                                        'items_wrap'     => '<ul id="%1$s" class="%2$s">%3$s</ul>',
                                                                        'fallback_cb' => 'wp_page_menu',
                                                                    )
                                                                );
                                                            } ?>
                                                    </nav>
                                                    <a href="javascript:void(0)" class="closebtn mobile-menu" onclick="legacy_videography_closeNav()"><i class="bi bi-x"></i></a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-1 col-md-3 col-6 align-self-center  text-lg-end text-center text-md-end hdr-icns">
                                        <?php if(get_theme_mod('legacy_videography_search_hide',true)=="1"){ ?>
                                            <div class="search-container py-2">
                                                <button id="search-icon" class="search-icon">
                                                    <i class="bi bi-search"></i>
                                                </button>
                                                <div id="search-form" class="search-form">
                                                    <?php get_search_form(); ?>
                                                </div>
                                            </div>
                                        <?php } ?>
                                    </div>
                                    <div class="col-lg-3 col-md-6 col-12 align-self-center text-center text-md-end text-lg-end">
                                        <div class="tbr-book-btn">
                                            <?php
                                                $legacy_videography_topbar_book_button_link = get_theme_mod( 'legacy_videography_topbar_book_button_link', '#' );
                                                if ( ! empty( $legacy_videography_topbar_book_button_link ) ) { ?>
                                                <div class="topbar-button py-2">
                                                    <a href="<?php echo esc_url( $legacy_videography_topbar_book_button_link ); ?>"><?php echo esc_html('Make Appointment','legacy-videography'); ?></a>
                                                </div> 
                                            <?php } ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div> 
                    </div>
                </div>
            </div>
            <?php endif; ?>
        </div>
    </div>    
</header>

<div class="clearfix"></div>
<div id="content" class="elementor-menu-anchor"></div>

<div class="content-wrap">