<?php
/**
 * Theme Customizer Controls
 *
 * @package Legacy Videography
 */

if ( ! function_exists( 'legacy_videography_customizer_typography_setting_register' ) ) :
function legacy_videography_customizer_typography_setting_register( $wp_customize ) {

    // Add Typography Panel for Body and Heading
    $wp_customize->add_panel(
        'legacy_videography_typography_settings_panel',
        array(
            'priority'      => 30,
            'capability'    => 'edit_theme_options',
            'title'         => esc_html__( 'Typography Settings', 'legacy-videography' ),
        )
    );

    // Section Body Typography
    $wp_customize->add_section(
        'legacy_videography_body_typography_settings',
        array(
            'priority'      => 25,
            'capability'    => 'edit_theme_options',
            'title'         => esc_html__( 'Body', 'legacy-videography' ),
            'panel'         => 'legacy_videography_typography_settings_panel',
        )
    );

    // Body Font Family Setting
    $wp_customize->add_setting(
        'legacy_videography_body_font_family',
        array(
            'default'           => 'Jost, serif', // Default font
            'sanitize_callback' => 'legacy_videography_sanitize_font_family', // Custom sanitize function
        )
    );
    $wp_customize->add_control( new Legacy_Videography_Font_Select_Control(
    $wp_customize,
    'legacy_videography_body_font_family',
    array(
        'label'   => esc_html__( 'Body Font Family', 'legacy-videography' ),
        'section' => 'legacy_videography_body_typography_settings',
        'choices' => legacy_videography_get_google_fonts(),
    )
    ));

    // Section Heading Typography
    $wp_customize->add_section(
        'legacy_videography_heading_typography_settings',
        array(
            'priority'      => 25,
            'capability'    => 'edit_theme_options',
            'title'         => esc_html__( 'Heading', 'legacy-videography' ),
            'panel'         => 'legacy_videography_typography_settings_panel',
        )
    );

    // Heading Font Family Setting
    $wp_customize->add_setting(
        'legacy_videography_heading_font_family',
        array(
            'default'           => 'Jost, serif', // Default font
            'sanitize_callback' => 'legacy_videography_sanitize_font_family', // Custom sanitize function
        )
    );
    $wp_customize->add_control( new Legacy_Videography_Font_Select_Control(
    $wp_customize,
    'legacy_videography_heading_font_family',
    array(
        'label'   => esc_html__( 'Heading Font Family', 'legacy-videography' ),
        'section' => 'legacy_videography_heading_typography_settings',
        'choices' => legacy_videography_get_google_fonts(),
    )
    ));
}
endif;

add_action( 'customize_register', 'legacy_videography_customizer_typography_setting_register' );

// Function to fetch Google Fonts
function legacy_videography_get_google_fonts() {
    // Add Google Fonts to be available for selection
    return array(
        'Outfit, serif' => 'Outfit', 
        'Arial, sans-serif'   => 'Arial',
        'Georgia, serif'      => 'Georgia',
        'Verdana, sans-serif' => 'Verdana',
        'Times New Roman, serif' => 'Times New Roman',
        'Roboto, sans-serif'  => 'Roboto',
        'Open Sans, sans-serif' => 'Open Sans',
        'Lora, serif'         => 'Lora',
        'Merriweather, serif' => 'Merriweather',
        'Montserrat, sans-serif' => 'Montserrat',
        // Add more Google fonts as needed
    );
}

// Sanitize Google Fonts input
function legacy_videography_sanitize_font_family( $value ) {
    $allowed_fonts = array('Outfit, serif','Arial, sans-serif', 'Georgia, serif', 'Verdana, sans-serif','Times New Roman, serif', 'Roboto, sans-serif', 'Open Sans, sans-serif',
        'Lora, serif', 'Merriweather, serif', 'Montserrat, sans-serif',
        // Add more allowed fonts to this array
    );

    if ( in_array( $value, $allowed_fonts ) ) {
        return $value;
    } else {
        return 'Outfit, serif'; // Default fallback font
    }
}

function legacy_videography_sanitize_title( $value ) {
    return sanitize_text_field( $value );
}
