<?php
/**
 * Theme Customizer Controls
 *
 * @package Legacy Videography
 */

if ( ! function_exists( 'legacy_videography_customizer_header_register' ) ) :
function legacy_videography_customizer_header_register( $wp_customize ) {

    $wp_customize->add_section(
        'legacy_videography_home_header_settings',
        array (
            'priority'      => 25,
            'capability'    => 'edit_theme_options',
            'title'         => esc_html__( 'Header Settings', 'legacy-videography' )
        )
    );

    // Title label
    $wp_customize->add_setting( 
        'legacy_videography_label_header_settings_title', 
        array(
            'sanitize_callback' => 'legacy_videography_sanitize_title',
        ) 
    );

    $wp_customize->add_control( 
        new Legacy_Videography_Title_Info_Control( $wp_customize, 'legacy_videography_label_header_settings_title', 
        array(
            'label'       => esc_html__( 'Contact Detail', 'legacy-videography' ),
            'section'     => 'legacy_videography_home_header_settings',
            'type'        => 'legacy-videography-title',
            'settings'    => 'legacy_videography_label_header_settings_title',
        ) 
    ));

    $wp_customize->add_setting(
        'legacy_videography_topbar_email_address',
        array(
            'default'           => 'videographer@example.com',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );

    $wp_customize->add_control(
        'legacy_videography_topbar_email_address',
        array(
            'label'           => sprintf( esc_html__( 'Email Address', 'legacy-videography' ), ),
            'section'         => 'legacy_videography_home_header_settings',
            'settings'        => 'legacy_videography_topbar_email_address' ,
            'type'            => 'text',
        )
    );

    $wp_customize->add_setting(
        'legacy_videography_topbar_phone_no',
        array(
            'default'           => '+088 235 235 427',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );

    $wp_customize->add_control(
        'legacy_videography_topbar_phone_no',
        array(
            'label'           => sprintf( esc_html__( 'Contact No', 'legacy-videography' ), ),
            'section'         => 'legacy_videography_home_header_settings',
            'settings'        => 'legacy_videography_topbar_phone_no' ,
            'type'            => 'text',
        )
    );

     // Title label
    $wp_customize->add_setting( 
        'legacy_videography_label_social_meida_settings_title', 
        array(
            'sanitize_callback' => 'legacy_videography_sanitize_title',
        ) 
    );

    $wp_customize->add_control( 
        new Legacy_Videography_Title_Info_Control( $wp_customize, 'legacy_videography_label_social_meida_settings_title', 
        array(
            'label'       => esc_html__( 'Social Media Links', 'legacy-videography' ),
            'section'     => 'legacy_videography_home_header_settings',
            'type'        => 'legacy-videography-title',
            'settings'    => 'legacy_videography_label_social_meida_settings_title',
        ) 
    ));

    // Facebook Link
    $wp_customize->add_setting(
        'legacy_videography_social_media1_heading',
        array(
            'default'           => 'www.facebook.com',
            'sanitize_callback' => 'esc_url_raw',
        )
    );

    $wp_customize->add_control(
        'legacy_videography_social_media1_heading',
        array(
            'label'           => sprintf( esc_html__( 'Facebook Link', 'legacy-videography' ), ),
            'section'         => 'legacy_videography_home_header_settings',
            'settings'        => 'legacy_videography_social_media1_heading' ,
            'type'            => 'url',
        )
    );

    // Instagram Link
    $wp_customize->add_setting(
        'legacy_videography_social_media2_heading',
        array(
            'default'           => 'www.instagram.com',
            'sanitize_callback' => 'esc_url_raw',
        )
    );

    $wp_customize->add_control(
        'legacy_videography_social_media2_heading',
        array(
            'label'           => sprintf( esc_html__( 'Instagram Link', 'legacy-videography' ), ),
            'section'         => 'legacy_videography_home_header_settings',
            'settings'        => 'legacy_videography_social_media2_heading' ,
            'type'            => 'url',
        )
    );

    // Twitter Link
    $wp_customize->add_setting(
        'legacy_videography_social_media3_heading',
        array(
            'default'           => 'www.twitter.com',
            'sanitize_callback' => 'esc_url_raw',
        )
    );

    $wp_customize->add_control(
        'legacy_videography_social_media3_heading',
        array(
            'label'           => sprintf( esc_html__( 'Twitter Link', 'legacy-videography' ), ),
            'section'         => 'legacy_videography_home_header_settings',
            'settings'        => 'legacy_videography_social_media3_heading' ,
            'type'            => 'url',
        )
    );

    // Youtube Link
    $wp_customize->add_setting(
        'legacy_videography_social_media4_heading',
        array(
            'default'           => 'www.youtube.com',
            'sanitize_callback' => 'esc_url_raw',
        )
    );

    $wp_customize->add_control(
        'legacy_videography_social_media4_heading',
        array(
            'label'           => sprintf( esc_html__( 'Youtube Link', 'legacy-videography' ), ),
            'section'         => 'legacy_videography_home_header_settings',
            'settings'        => 'legacy_videography_social_media4_heading' ,
            'type'            => 'url',
        )
    );

    // Pinterest Link
    $wp_customize->add_setting(
        'legacy_videography_social_media5_heading',
        array(
            'default'           => 'www.pinterest.com',
            'sanitize_callback' => 'esc_url_raw',
        )
    );

    $wp_customize->add_control(
        'legacy_videography_social_media5_heading',
        array(
            'label'           => sprintf( esc_html__( 'Pinterest Link', 'legacy-videography' ), ),
            'section'         => 'legacy_videography_home_header_settings',
            'settings'        => 'legacy_videography_social_media5_heading' ,
            'type'            => 'url',
        )
    );

    // Linkedin Link
    $wp_customize->add_setting(
        'legacy_videography_social_media6_heading',
        array(
            'default'           => 'www.linkedin.com',
            'sanitize_callback' => 'esc_url_raw',
        )
    );

    $wp_customize->add_control(
        'legacy_videography_social_media6_heading',
        array(
            'label'           => sprintf( esc_html__( 'Linkedin Link', 'legacy-videography' ), ),
            'section'         => 'legacy_videography_home_header_settings',
            'settings'        => 'legacy_videography_social_media6_heading' ,
            'type'            => 'url',
        )
    );

    // Title label
    $wp_customize->add_setting( 
        'legacy_videography_label_header_search_settings_title', 
        array(
            'sanitize_callback' => 'legacy_videography_sanitize_title',
        ) 
    );

    $wp_customize->add_control( 
        new Legacy_Videography_Title_Info_Control( $wp_customize, 'legacy_videography_label_header_search_settings_title', 
        array(
            'label'       => esc_html__( 'Search Bar', 'legacy-videography' ),
            'section'     => 'legacy_videography_home_header_settings',
            'type'        => 'legacy-videography-title',
            'settings'    => 'legacy_videography_label_header_search_settings_title',
        ) 
    ));

     // Hide Search bar
    $wp_customize->add_setting(
        'legacy_videography_search_hide',
        array(
            'type' => 'theme_mod',
            'default'           => false,
            'sanitize_callback' => 'legacy_videography_sanitize_checkbox'
        )
    );

    $wp_customize->add_control(
        new Legacy_Videography_Toggle_Control( $wp_customize, 'legacy_videography_search_hide', 
        array(
            'settings'      => 'legacy_videography_search_hide',
            'section'       => 'legacy_videography_home_header_settings',
            'type'          => 'legacy-videography-toggle',
            'label'         => esc_html__( 'Show\Hide Search', 'legacy-videography' ),
            'description'   => '',           
        )
    ));

    // topbar buttons

    // Title label
    $wp_customize->add_setting( 
        'legacy_videography_label_header_button_settings_title', 
        array(
            'sanitize_callback' => 'legacy_videography_sanitize_title',
        ) 
    );

    $wp_customize->add_control( 
        new Legacy_Videography_Title_Info_Control( $wp_customize, 'legacy_videography_label_header_button_settings_title', 
        array(
            'label'       => esc_html__( 'Tobar Button', 'legacy-videography' ),
            'section'     => 'legacy_videography_home_header_settings',
            'type'        => 'legacy-videography-title',
            'settings'    => 'legacy_videography_label_header_button_settings_title',
        ) 
    ));

    $wp_customize->add_setting(
        'legacy_videography_topbar_book_button_link',
        array(
            'default'           => '#',
            'sanitize_callback' => 'esc_url_raw',
        )
    );

    $wp_customize->add_control(
        'legacy_videography_topbar_book_button_link',
        array(
            'label'           => sprintf( esc_html__( 'Header Button Link', 'legacy-videography' ), ),
            'section'         => 'legacy_videography_home_header_settings',
            'settings'        => 'legacy_videography_topbar_book_button_link' ,
            'type'            => 'url',
        )
    );
}
endif;

add_action( 'customize_register', 'legacy_videography_customizer_header_register' );