<?php
/**
 * Theme Customizer Controls
 *
 * @package Legacy Videography
 */

if ( ! function_exists( 'legacy_videography_customizer_global_color_setting_register' ) ) :
function legacy_videography_customizer_global_color_setting_register( $wp_customize ) {
 
 	// $wp_customize->add_section(
    //     'legacy_videography_global_color_settings',
    //     array (
    //         'priority'      => 40,
    //         'capability'    => 'edit_theme_options',
    //         'title'         => esc_html__( 'Global Color Settings', 'legacy-videography' )
    //     )
    // );

    // Title label
	$wp_customize->add_setting( 
		'legacy_videography_theme_color_settings', 
		array(
		    'sanitize_callback' => 'legacy_videography_sanitize_title',
		) 
	);

	$wp_customize->add_control( 
		new Legacy_Videography_Title_Info_Control( $wp_customize, 'legacy_videography_theme_color_settings', 
		array(
		    'label'       => esc_html__( 'Global Color Settings', 'legacy-videography' ),
		    'section'     => 'legacy_videography_global_color_settings',
		    'type'        => 'legacy-videography-title',
		    'settings'    => 'legacy_videography_theme_color_settings',
		) 
	));

	$wp_customize->add_setting('legacy_videography_global_color1',
        array(
            'type' => 'theme_mod',
            'default'           => '#FC6900',
            'sanitize_callback' => 'sanitize_hex_color'
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'legacy_videography_global_color1',
            array(
                'label'      => esc_html__( 'Global Color1', 'legacy-videography' ),
                'section'    => 'legacy_videography_global_color_settings',
                'settings'   => 'legacy_videography_global_color1',
            )
        )
    ); 

    $wp_customize->add_setting('legacy_videography_global_color2',
        array(
            'type' => 'theme_mod',
            'default'           => '#222222',
            'sanitize_callback' => 'sanitize_hex_color'
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'legacy_videography_global_color2',
            array(
                'label'      => esc_html__( 'Global Color2', 'legacy-videography' ),
                'section'    => 'legacy_videography_global_color_settings',
                'settings'   => 'legacy_videography_global_color2',
            )
        )
    );   

}
endif;

add_action( 'customize_register', 'legacy_videography_customizer_global_color_setting_register' );