<?php
/**
 * Theme Customizer Controls
 *
 * @package Legacy Videography
 */

if ( ! function_exists( 'legacy_videography_customizer_general_setting_register' ) ) :
function legacy_videography_customizer_general_setting_register( $wp_customize ) {
 
 	$wp_customize->add_section(
        'legacy_videography_general_settings',
        array (
            'priority'      => 25,
            'capability'    => 'edit_theme_options',
            'title'         => esc_html__( 'General Settings', 'legacy-videography' )
        )
    );

 	// Add general Panel for preloader and scrolltop
    $wp_customize->add_panel(
        'legacy_videography_general_settings_panel',
        array(
            'priority'      => 30,
            'capability'    => 'edit_theme_options',
            'title'         => esc_html__( 'General Settings', 'legacy-videography' ),
        )
    );

    // Section preloader
    $wp_customize->add_section(
        'legacy_videography_prelodr_settings',
        array(
            'priority'      => 25,
            'capability'    => 'edit_theme_options',
            'title'         => esc_html__( 'Preloader', 'legacy-videography' ),
            'panel'         => 'legacy_videography_general_settings_panel',
        )
    );

    // Title label
	$wp_customize->add_setting( 
		'legacy_videography_preloader_settings', 
		array(
		    'sanitize_callback' => 'legacy_videography_sanitize_title',
		) 
	);

	$wp_customize->add_control( 
		new Legacy_Videography_Title_Info_Control( $wp_customize, 'legacy_videography_preloader_settings', 
		array(
		    'label'       => esc_html__( 'Preloader Settings', 'legacy-videography' ),
		    'section'     => 'legacy_videography_prelodr_settings',
		    'type'        => 'legacy-videography-title',
		    'settings'    => 'legacy_videography_preloader_settings',
		) 
	));

	// Add an option to enable the preloader
	$wp_customize->add_setting( 
		'legacy_videography_enable_preloader', 
		array(
		    'default'           => false,
		    'type'              => 'theme_mod',
		    'sanitize_callback' => 'legacy_videography_sanitize_checkbox',
		) 
	);

	$wp_customize->add_control( 
		new Legacy_Videography_Toggle_Control( $wp_customize, 'legacy_videography_enable_preloader', 
		array(
		    'label'       => esc_html__( 'Show Preloader', 'legacy-videography' ),
		    'section'     => 'legacy_videography_prelodr_settings',
		    'type'        => 'legacy-videography-toggle',
		    'settings'    => 'legacy_videography_enable_preloader',
		) 
	));


    // Section Body Typography
    $wp_customize->add_section(
        'legacy_videography_scrol_settings',
        array(
            'priority'      => 30,
            'capability'    => 'edit_theme_options',
            'title'         => esc_html__( 'Scroll Top', 'legacy-videography' ),
            'panel'         => 'legacy_videography_general_settings_panel',
        )
    );


	// Title label
	$wp_customize->add_setting( 
		'legacy_videography_scroll_top_settings', 
		array(
		    'sanitize_callback' => 'legacy_videography_sanitize_title',
		) 
	);

	$wp_customize->add_control( 
		new Legacy_Videography_Title_Info_Control( $wp_customize, 'legacy_videography_scroll_top_settings', 
		array(
		    'label'       => esc_html__( 'Scroll Top Settings', 'legacy-videography' ),
		    'section'     => 'legacy_videography_scrol_settings',
		    'type'        => 'legacy-videography-title',
		    'settings'    => 'legacy_videography_scroll_top_settings',
		) 
	));

	// Add an option to enable the scrolltop
	$wp_customize->add_setting( 
		'legacy_videography_enable_scrolltop', 
		array(
		    'default'           => true,
		    'type'              => 'theme_mod',
		    'sanitize_callback' => 'legacy_videography_sanitize_checkbox',
		) 
	);

	$wp_customize->add_control( 
		new Legacy_Videography_Toggle_Control( $wp_customize, 'legacy_videography_enable_scrolltop', 
		array(
		    'label'       => esc_html__( 'Show Scroll Top', 'legacy-videography' ),
		    'section'     => 'legacy_videography_scrol_settings',
		    'type'        => 'legacy-videography-toggle',
		    'settings'    => 'legacy_videography_enable_scrolltop',
		) 
	));

	 $wp_customize->add_section(
        'legacy_videography_button_settings',
        array(
            'priority'      => 25,
            'capability'    => 'edit_theme_options',
            'title'         => esc_html__( 'Buttons', 'legacy-videography' ),
            'panel'         => 'legacy_videography_general_settings_panel',
        )
    );

	 // Border Radius Setting
	$wp_customize->add_setting(
	    'legacy_videography_button_border_radius',
	    array(
	        'default'           => '6px',
	        'sanitize_callback' => 'sanitize_text_field',
	        'transport'         => 'refresh',
	    )
	);

	$wp_customize->add_control(
	    'legacy_videography_button_border_radius',
	    array(
	        'type'     => 'text',
	        'label'    => esc_html__( 'Button Border Radius (e.g. 4px, 50%)', 'legacy-videography' ),
	        'section'  => 'legacy_videography_button_settings',
	    )
	);

	// Button Padding Setting
	$wp_customize->add_setting(
	    'legacy_videography_button_padding',
	    array(
	        'default'           => '10px 35px',
	        'sanitize_callback' => 'sanitize_text_field',
	        'transport'         => 'refresh',
	    )
	);

	$wp_customize->add_control(
	    'legacy_videography_button_padding',
	    array(
	        'type'     => 'text',
	        'label'    => esc_html__( 'Button Padding (e.g. 10px 20px)', 'legacy-videography' ),
	        'section'  => 'legacy_videography_button_settings',
	    )
	);


}
endif;

add_action( 'customize_register', 'legacy_videography_customizer_general_setting_register' );