<?php
/**
 * Theme Customizer Controls
 *
 * @package Legacy Videography
 */

if ( ! function_exists( 'legacy_videography_customizer_blog_register' ) ) :
function legacy_videography_customizer_blog_register( $wp_customize ) {
	
	$wp_customize->add_panel(
        'legacy_videography_blog_settings_panel',
        array (
            'priority'      => 30,
            'capability'    => 'edit_theme_options',
            'title'         => esc_html__( 'Blog Settings', 'legacy-videography' ),
        )
    );

	// Section Posts
    $wp_customize->add_section(
        'legacy_videography_posts_settings',
        array (
            'priority'      => 25,
            'capability'    => 'edit_theme_options',
            'title'         => esc_html__( 'Posts', 'legacy-videography' ),
            'panel'          => 'legacy_videography_blog_settings_panel',
        )
    ); 

	// Title label
	$wp_customize->add_setting( 
		'legacy_videography_label_post_meta_show', 
		array(
		    'sanitize_callback' => 'legacy_videography_sanitize_title',
		) 
	);

	$wp_customize->add_control( 
		new Legacy_Videography_Title_Info_Control( $wp_customize, 'legacy_videography_label_post_meta_show', 
		array(
		    'label'       => esc_html__( 'Posts Meta', 'legacy-videography' ),
		    'section'     => 'legacy_videography_posts_settings',
		    'type'        => 'legacy-videography-title',
		    'settings'    => 'legacy_videography_label_post_meta_show',
		) 
	));

	// Add an option to enable the date
	$wp_customize->add_setting( 
		'legacy_videography_enable_posts_meta_date', 
		array(
		    'default'           => true,
		    'type'              => 'theme_mod',
		    'sanitize_callback' => 'legacy_videography_sanitize_checkbox',
		) 
	);

	$wp_customize->add_control( 
		new Legacy_Videography_Toggle_Control( $wp_customize, 'legacy_videography_enable_posts_meta_date', 
		array(
		    'label'       => esc_html__( 'Show Date', 'legacy-videography' ),
		    'section'     => 'legacy_videography_posts_settings',
		    'type'        => 'legacy-videography-toggle',
		    'settings'    => 'legacy_videography_enable_posts_meta_date',
		) 
	));

	// Add an option to enable the author
	$wp_customize->add_setting( 
		'legacy_videography_enable_posts_meta_author', 
		array(
		    'default'           => true,
		    'type'              => 'theme_mod',
		    'sanitize_callback' => 'legacy_videography_sanitize_checkbox',
		) 
	);

	$wp_customize->add_control( 
		new Legacy_Videography_Toggle_Control( $wp_customize, 'legacy_videography_enable_posts_meta_author', 
		array(
		    'label'       => esc_html__( 'Show Author', 'legacy-videography' ),
		    'section'     => 'legacy_videography_posts_settings',
		    'type'        => 'legacy-videography-toggle',
		    'settings'    => 'legacy_videography_enable_posts_meta_author',
		) 
	));

	// Add an option to enable the comments
	$wp_customize->add_setting( 
		'legacy_videography_enable_posts_meta_comments', 
		array(
		    'default'           => true,
		    'type'              => 'theme_mod',
		    'sanitize_callback' => 'legacy_videography_sanitize_checkbox',
		) 
	);

	$wp_customize->add_control( 
		new Legacy_Videography_Toggle_Control( $wp_customize, 'legacy_videography_enable_posts_meta_comments', 
		array(
		    'label'       => esc_html__( 'Show Comments', 'legacy-videography' ),
		    'section'     => 'legacy_videography_posts_settings',
		    'type'        => 'legacy-videography-toggle',
		    'settings'    => 'legacy_videography_enable_posts_meta_comments',
		) 
	));

	// Title label
	$wp_customize->add_setting( 
		'legacy_videography_label_sidebar_layout', 
		array(
		    'sanitize_callback' => 'legacy_videography_sanitize_title',
		) 
	);

	$wp_customize->add_control( 
		new Legacy_Videography_Title_Info_Control( $wp_customize, 'legacy_videography_label_sidebar_layout', 
		array(
		    'label'       => esc_html__( 'Sidebar', 'legacy-videography' ),
		    'section'     => 'legacy_videography_posts_settings',
		    'type'        => 'legacy-videography-title',
		    'settings'    => 'legacy_videography_label_sidebar_layout',
		) 
	));

	// Sidebar layout
    $wp_customize->add_setting(
        'legacy_videography_blog_sidebar_layout',
        array(
            'default'			=> 'right',
            'type'				=> 'theme_mod',
            'capability'		=> 'edit_theme_options',
            'sanitize_callback'	=> 'legacy_videography_sanitize_select'
        )
    );
    $wp_customize->add_control(
        new Legacy_Videography_Radio_Image_Control( $wp_customize,'legacy_videography_blog_sidebar_layout',
            array(
                'settings'		=> 'legacy_videography_blog_sidebar_layout',
                'section'		=> 'legacy_videography_posts_settings',
                'label'			=> esc_html__( 'Sidebar Layout', 'legacy-videography' ),
                'choices'		=> array(
                    'right'	        => LEGACY_VIDEOGRAPHY_DIR_URI . '/inc/customizer/assets/images/cr.png',
                    'left' 	        => LEGACY_VIDEOGRAPHY_DIR_URI . '/inc/customizer/assets/images/cl.png',
                    'three_colm'	        => LEGACY_VIDEOGRAPHY_DIR_URI . '/inc/customizer/assets/images/c3.png',
                    'four_colm'	        => LEGACY_VIDEOGRAPHY_DIR_URI . '/inc/customizer/assets/images/c4.png',
                    'grid_layout'	        => LEGACY_VIDEOGRAPHY_DIR_URI . '/inc/customizer/assets/images/c5.png',
                    'grid_left_sidebar'	        => LEGACY_VIDEOGRAPHY_DIR_URI . '/inc/customizer/assets/images/c6.png',
                    'grid_right_sidebar'	        => LEGACY_VIDEOGRAPHY_DIR_URI . '/inc/customizer/assets/images/c7.png',
                    'no' 	        => LEGACY_VIDEOGRAPHY_DIR_URI . '/inc/customizer/assets/images/cn.png',
                )
            )
        )
    );

    // Title label
	$wp_customize->add_setting( 
		'legacy_videography_label_blog_excerpt', 
		array(
		    'sanitize_callback' => 'legacy_videography_sanitize_title',
		) 
	);

	$wp_customize->add_control( 
		new Legacy_Videography_Title_Info_Control( $wp_customize, 'legacy_videography_label_blog_excerpt', 
		array(
		    'label'       => esc_html__( 'Post Excerpt', 'legacy-videography' ),
		    'section'     => 'legacy_videography_posts_settings',
		    'type'        => 'legacy-videography-title',
		    'settings'    => 'legacy_videography_label_blog_excerpt',
		) 
	));

	// add post excerpt textbox
    $wp_customize->add_setting(
        'legacy_videography_posts_excerpt_length',
        array(
            'type' => 'theme_mod',
            'default'           => 30,
            'sanitize_callback' => 'legacy_videography_sanitize_number',
        )
    );

    $wp_customize->add_control(
        'legacy_videography_posts_excerpt_length',
        array(
            'settings'      => 'legacy_videography_posts_excerpt_length',
            'section'       => 'legacy_videography_posts_settings',
            'type'          => 'number',
            'label'         => esc_html__( 'Post Excerpt Length', 'legacy-videography' ),
        )
    );

    // add readmore textbox
    $wp_customize->add_setting(
        'legacy_videography_posts_readmore_text',
        array(
            'type' => 'theme_mod',
            'default'           => esc_html__( 'READ MORE', 'legacy-videography' ),
            'sanitize_callback' => 'legacy_videography_sanitize_text_field',
        )
    );

    $wp_customize->add_control(
        'legacy_videography_posts_readmore_text',
        array(
            'settings'      => 'legacy_videography_posts_readmore_text',
            'section'       => 'legacy_videography_posts_settings',
            'type'          => 'textbox',
            'label'         => esc_html__( 'Read More Text', 'legacy-videography' ),
        )
    );

    //=========================================================================

	// Section Single Post
    $wp_customize->add_section(
        'legacy_videography_single_post_settings',
        array (
            'priority'      => 25,
            'capability'    => 'edit_theme_options',
            'title'         => esc_html__( 'Single Post', 'legacy-videography' ),
            'panel'          => 'legacy_videography_blog_settings_panel',
        )
    ); 


    // Title label
	$wp_customize->add_setting( 
		'legacy_videography_label_single_post_category_show', 
		array(
		    'sanitize_callback' => 'legacy_videography_sanitize_title',
		) 
	);

	$wp_customize->add_control( 
		new Legacy_Videography_Title_Info_Control( $wp_customize, 'legacy_videography_label_single_post_category_show', 
		array(
		    'label'       => esc_html__( 'Post Category', 'legacy-videography' ),
		    'section'     => 'legacy_videography_single_post_settings',
		    'type'        => 'legacy-videography-title',
		    'settings'    => 'legacy_videography_label_single_post_category_show',
		) 
	));

	// Add an option to enable the category
	$wp_customize->add_setting( 
		'legacy_videography_enable_single_post_cat', 
		array(
		    'default'           => true,
		    'type'              => 'theme_mod',
		    'sanitize_callback' => 'legacy_videography_sanitize_checkbox',
		) 
	);

	$wp_customize->add_control( 
		new Legacy_Videography_Toggle_Control( $wp_customize, 'legacy_videography_enable_single_post_cat', 
		array(
		    'label'       => esc_html__( 'Show Category', 'legacy-videography' ),
		    'section'     => 'legacy_videography_single_post_settings',
		    'type'        => 'legacy-videography-toggle',
		    'settings'    => 'legacy_videography_enable_single_post_cat',
		) 
	));

	// add category textbox
    $wp_customize->add_setting(
        'legacy_videography_single_post_category_text',
        array(
            'type' => 'theme_mod',
            'default'           => esc_html__( 'Category:', 'legacy-videography' ),
            'sanitize_callback' => 'legacy_videography_sanitize_text_field',
        )
    );

    $wp_customize->add_control(
        'legacy_videography_single_post_category_text',
        array(
            'settings'      => 'legacy_videography_single_post_category_text',
            'section'       => 'legacy_videography_single_post_settings',
            'type'          => 'textbox',
            'label'         => esc_html__( 'Category Text', 'legacy-videography' ),
        )
    );

	// Title label
	$wp_customize->add_setting( 
		'legacy_videography_label_single_post_tag_show', 
		array(
		    'sanitize_callback' => 'legacy_videography_sanitize_title',
		) 
	);

	$wp_customize->add_control( 
		new Legacy_Videography_Title_Info_Control( $wp_customize, 'legacy_videography_label_single_post_tag_show', 
		array(
		    'label'       => esc_html__( 'Post Tags', 'legacy-videography' ),
		    'section'     => 'legacy_videography_single_post_settings',
		    'type'        => 'legacy-videography-title',
		    'settings'    => 'legacy_videography_label_single_post_tag_show',
		) 
	));

	// Add an option to enable the tags
	$wp_customize->add_setting( 
		'legacy_videography_enable_single_post_tags', 
		array(
		    'default'           => true,
		    'type'              => 'theme_mod',
		    'sanitize_callback' => 'legacy_videography_sanitize_checkbox',
		) 
	);

	$wp_customize->add_control( 
		new Legacy_Videography_Toggle_Control( $wp_customize, 'legacy_videography_enable_single_post_tags', 
		array(
		    'label'       => esc_html__( 'Show Tags', 'legacy-videography' ),
		    'section'     => 'legacy_videography_single_post_settings',
		    'type'        => 'legacy-videography-toggle',
		    'settings'    => 'legacy_videography_enable_single_post_tags',
		) 
	));

	// Title label
	$wp_customize->add_setting( 
		'legacy_videography_label_single_pos_meta_show', 
		array(
		    'sanitize_callback' => 'legacy_videography_sanitize_title',
		) 
	);

	$wp_customize->add_control( 
		new Legacy_Videography_Title_Info_Control( $wp_customize, 'legacy_videography_label_single_pos_meta_show', 
		array(
		    'label'       => esc_html__( 'Post Meta', 'legacy-videography' ),
		    'section'     => 'legacy_videography_single_post_settings',
		    'type'        => 'legacy-videography-title',
		    'settings'    => 'legacy_videography_label_single_pos_meta_show',
		) 
	));

	// Add an option to enable the date
	$wp_customize->add_setting( 
		'legacy_videography_enable_single_post_meta_date', 
		array(
		    'default'           => true,
		    'type'              => 'theme_mod',
		    'sanitize_callback' => 'legacy_videography_sanitize_checkbox',
		) 
	);

	$wp_customize->add_control( 
		new Legacy_Videography_Toggle_Control( $wp_customize, 'legacy_videography_enable_single_post_meta_date', 
		array(
		    'label'       => esc_html__( 'Show Date', 'legacy-videography' ),
		    'section'     => 'legacy_videography_single_post_settings',
		    'type'        => 'legacy-videography-toggle',
		    'settings'    => 'legacy_videography_enable_single_post_meta_date',
		) 
	));

	// Add an option to enable the author
	$wp_customize->add_setting( 
		'legacy_videography_enable_single_post_meta_author', 
		array(
		    'default'           => true,
		    'type'              => 'theme_mod',
		    'sanitize_callback' => 'legacy_videography_sanitize_checkbox',
		) 
	);

	$wp_customize->add_control( 
		new Legacy_Videography_Toggle_Control( $wp_customize, 'legacy_videography_enable_single_post_meta_author', 
		array(
		    'label'       => esc_html__( 'Show Author', 'legacy-videography' ),
		    'section'     => 'legacy_videography_single_post_settings',
		    'type'        => 'legacy-videography-toggle',
		    'settings'    => 'legacy_videography_enable_single_post_meta_author',
		) 
	));

	// Add an option to enable the comments
	$wp_customize->add_setting( 
		'legacy_videography_enable_single_post_meta_comments', 
		array(
		    'default'           => true,
		    'type'              => 'theme_mod',
		    'sanitize_callback' => 'legacy_videography_sanitize_checkbox',
		) 
	);

	$wp_customize->add_control( 
		new Legacy_Videography_Toggle_Control( $wp_customize, 'legacy_videography_enable_single_post_meta_comments', 
		array(
		    'label'       => esc_html__( 'Show Comments', 'legacy-videography' ),
		    'section'     => 'legacy_videography_single_post_settings',
		    'type'        => 'legacy-videography-toggle',
		    'settings'    => 'legacy_videography_enable_single_post_meta_comments',
		) 
	));

	// Title label
	$wp_customize->add_setting( 
		'legacy_videography_label_single_pos_nav_show', 
		array(
		    'sanitize_callback' => 'legacy_videography_sanitize_title',
		) 
	);

	$wp_customize->add_control( 
		new Legacy_Videography_Title_Info_Control( $wp_customize, 'legacy_videography_label_single_pos_nav_show', 
		array(
		    'label'       => esc_html__( 'Post Navigation', 'legacy-videography' ),
		    'section'     => 'legacy_videography_single_post_settings',
		    'type'        => 'legacy-videography-title',
		    'settings'    => 'legacy_videography_label_single_pos_nav_show',
		) 
	));

    // add next article textbox
    $wp_customize->add_setting(
        'legacy_videography_single_post_next_article_text',
        array(
            'type' => 'theme_mod',
            'default'           => esc_html__( 'Next Article', 'legacy-videography' ),
            'sanitize_callback' => 'legacy_videography_sanitize_text_field',
        )
    );

    $wp_customize->add_control(
        'legacy_videography_single_post_next_article_text',
        array(
            'settings'      => 'legacy_videography_single_post_next_article_text',
            'section'       => 'legacy_videography_single_post_settings',
            'type'          => 'textbox',
            'label'         => esc_html__( 'Next Article Text', 'legacy-videography' ),
            'description'         => esc_html__( 'You can change the text displayed in the single post navigation', 'legacy-videography' ),
        )
    );

    // add previous article textbox
    $wp_customize->add_setting(
        'legacy_videography_single_post_previous_article_text',
        array(
            'type' => 'theme_mod',
            'default'           => esc_html__( 'Previous Article', 'legacy-videography' ),
            'sanitize_callback' => 'legacy_videography_sanitize_text_field',
        )
    );

    $wp_customize->add_control(
        'legacy_videography_single_post_previous_article_text',
        array(
            'settings'      => 'legacy_videography_single_post_previous_article_text',
            'section'       => 'legacy_videography_single_post_settings',
            'type'          => 'textbox',
            'label'         => esc_html__( 'Previous Article Text', 'legacy-videography' ),
            'description'         => esc_html__( 'You can change the text displayed in the single post navigation', 'legacy-videography' ),
        )
    );
    
	// Title label
	$wp_customize->add_setting( 
		'legacy_videography_label_single_sidebar_layout', 
		array(
		    'sanitize_callback' => 'legacy_videography_sanitize_title',
		) 
	);

	$wp_customize->add_control( 
		new Legacy_Videography_Title_Info_Control( $wp_customize, 'legacy_videography_label_single_sidebar_layout', 
		array(
		    'label'       => esc_html__( 'Sidebar', 'legacy-videography' ),
		    'section'     => 'legacy_videography_single_post_settings',
		    'type'        => 'legacy-videography-title',
		    'settings'    => 'legacy_videography_label_single_sidebar_layout',
		) 
	));

	// Sidebar layout
    $wp_customize->add_setting(
        'legacy_videography_blog_single_sidebar_layout',
        array(
            'default'			=> 'no',
            'type'				=> 'theme_mod',
            'capability'		=> 'edit_theme_options',
            'sanitize_callback'	=> 'legacy_videography_sanitize_select'
        )
    );
    $wp_customize->add_control(
        new Legacy_Videography_Radio_Image_Control( $wp_customize,'legacy_videography_blog_single_sidebar_layout',
            array(
                'settings'		=> 'legacy_videography_blog_single_sidebar_layout',
                'section'		=> 'legacy_videography_single_post_settings',
                'label'			=> esc_html__( 'Sidebar Layout', 'legacy-videography' ),
                'choices'		=> array(
                    'right'	        => LEGACY_VIDEOGRAPHY_DIR_URI . '/inc/customizer/assets/images/cr.png',
                    'left' 	        => LEGACY_VIDEOGRAPHY_DIR_URI . '/inc/customizer/assets/images/cl.png',
                    'no' 	        => LEGACY_VIDEOGRAPHY_DIR_URI . '/inc/customizer/assets/images/cn.png',
                )
            )
        )
    );
}
endif;

add_action( 'customize_register', 'legacy_videography_customizer_blog_register' );