<?php

/**
 * Welcome Notice class.
 */
class Legacy_Videography_Welcome_Notice {

	/**
	** Constructor.
	*/
	public function __construct() {
		// Render Notice
		add_action( 'admin_notices', [$this, 'legacy_videography_render_notice'] );

		// Enque AJAX Script
		add_action( 'admin_enqueue_scripts', [$this, 'legacy_videography_admin_enqueue_scripts'], 5 );

		// Dismiss
		add_action( 'admin_enqueue_scripts', [$this, 'legacy_videography_notice_enqueue_scripts'], 5 );
		add_action( 'wp_ajax_legacy_videography_dismissed_handler', [$this, 'legacy_videography_dismissed_handler'] );

		// Reset
		add_action( 'switch_theme', [$this, 'legacy_videography_reset_notices'] );
		add_action( 'after_switch_theme', [$this, 'legacy_videography_reset_notices'] );

	}

	/**
	** Render Notice
	*/
	public function legacy_videography_render_notice() {
	global $pagenow;

	$legacy_videography_screen = get_current_screen();

	if (
		$legacy_videography_screen &&
		$legacy_videography_screen->id !== 'appearance_page_legacy-videography-theme-info' &&
		$legacy_videography_screen->id !== 'appearance_page_legacy-videography-demo'
	) {
		$legacy_videography_transient_name = sprintf('%s_activation_notice', get_template());

		if ( ! get_transient($legacy_videography_transient_name) ) {
			?>
			<div class="legacy-videography-notice notice notice-info is-dismissible" data-notice="<?php echo esc_attr($legacy_videography_transient_name); ?>">
				<button type="button" class="notice-dismiss"></button>

				<?php $this->legacy_videography_render_notice_content(); ?>
			</div>
			<?php
		}
	}
}


	/**
	** Render Notice Content
	*/
	public function legacy_videography_render_notice_content() {
		$legacy_videography_action = 'install-activate';
		$legacy_videography_redirect_url = 'admin.php?page=legacy-videography-theme-info';
		$legacy_videography_demo_redirect_url = 'themes.php?page=legacy-videography-demo';
		$legacy_videography_screen = get_current_screen();

		?>
		<div class="notice-left-icon-box">
			<span class="dashicons dashicons-businessperson notc-theme-icon"></span>
		</div>
		<div class="welcome-message">
			<div class="notc-contnt">
				<h4><?php esc_html_e('Thank you for installing Legacy Themes!', 'legacy-videography'); ?></h4>
				<h1><?php esc_html_e('Welcome to Legacy Videography WordPress Theme!', 'legacy-videography'); ?></h1>
				<p><?php esc_html_e( 'Our WordPress themes are modern, minimalist, fully responsive, SEO-friendly, and packed with features—perfect for designers, bloggers, and creative professionals across various fields.', 'legacy-videography' );?>
				</p>			
				<div class="action-buttons">
					<a href="<?php echo esc_url(admin_url($legacy_videography_redirect_url)); ?>" class="button notice-btn button-hero" data-action="<?php echo esc_attr($legacy_videography_action); ?>">
						<span class="notc-btn-txt"><?php echo esc_html__( 'Get Started with Legacy Videography', 'legacy-videography' ); ?></span>
					</a>
					<a href="<?php echo esc_url(admin_url($legacy_videography_demo_redirect_url)); ?>" class="demo-btn btn" >
						<span class="demo-btn-txt"><?php echo esc_html__( 'Demo Import', 'legacy-videography' ); ?></span>
					</a>
					<a href="<?php echo esc_url(LEGACY_VIDEOGRAPHY_THEME_BUNDLE_URL); ?>" target="_blank" class="bundle-btn btn" >
						<span class="demo-btn-txt"><?php echo esc_html__( 'Get All Themes', 'legacy-videography' ); ?></span>
					</a>
				</div>
			</div>			
		</div>
		<div class="notice-right-img-box">
			<img class="notc-right-img" src="<?php echo esc_url( get_template_directory_uri() . '/inc/activation-notice/img/notice-right.png' ); ?>" alt="<?php esc_attr_e( 'notice themes img', 'legacy-videography' ); ?>" />
		</div>

		<?php
	}

	/**
	** Reset Notice.
	*/
	public function legacy_videography_reset_notices() {
		delete_transient( sprintf( '%s_activation_notice', get_template() ) );
	}

	/**
	** Dismissed handler
	*/
	public function legacy_videography_dismissed_handler() {
		wp_verify_nonce( null );

		if ( isset( $_POST['notice'] ) ) {
			set_transient( sanitize_text_field( wp_unslash( $_POST['notice'] ) ), true, 0 );
		}
	}

	/**
	** Notice Enqunue Scripts
	*/
	public function legacy_videography_notice_enqueue_scripts( $page ) {
		
		wp_enqueue_script( 'jquery' );

		ob_start();
		?>
		<script>
			jQuery(function($) {
				$( document ).on( 'click', '.legacy-videography-notice .notice-dismiss', function () {
					jQuery.post( 'ajax_url', {
						action: 'legacy_videography_dismissed_handler',
						notice: $( this ).closest( '.legacy-videography-notice' ).data( 'notice' ),
					});
					$( '.legacy-videography-notice' ).hide();
				} );
			});
		</script>
		<?php
		$script = str_replace( 'ajax_url', admin_url( 'admin-ajax.php' ), ob_get_clean() );

		wp_add_inline_script( 'jquery', str_replace( ['<script>', '</script>'], '', $script ) );
	}

	/**
	** Register scripts and styles for welcome notice.
	*/
	public function legacy_videography_admin_enqueue_scripts( $page ) {
		// Enqueue Styles.
		wp_enqueue_style( 'legacy-videography-welcome-notic-css', get_template_directory_uri() . '/inc/activation-notice/css/notice-bar.css' );
	}

}

new Legacy_Videography_Welcome_Notice();