<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Leento
 */

?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<?php if ( has_post_thumbnail() ) : ?>
			<figure class="imageTpost">
				<a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>">
					<img src="<?php the_post_thumbnail_url('leento-image-post'); ?>"/>
				</a>
			</figure>	
	<?php endif; ?>
	<header class="entry-header">
		<?php the_title( '<h2 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' );
		if ( 'post' === get_post_type() ) : ?>
		<div class="entry-meta">
			<?php leento_posted_on(); ?>
		</div><!-- .entry-meta -->
		<?php
		endif; ?>
	</header><!-- .entry-header -->

	<div class="entry-summary">
			<?php the_excerpt(); ?>
		</div><!-- .entry-summary -->

	<footer class="entry-footer">
		<?php leento_entry_footer() ?>
		<span class="read-more"><a href="<?php echo esc_url(get_permalink()); ?>"><?php esc_html_e("Read More", "leento")?></a><i class="fa spaceLeft fa-caret-right"></i></span>
	</footer><!-- .entry-footer -->
</article><!-- #post-<?php the_ID(); ?> -->
