<?php
/**
 * Custom template tags for this theme
 *
 * Eventually, some of the functionality here could be replaced by core features.
 *
 * @package Leento
 */

if ( ! function_exists( 'leento_post_nav' ) ) :
/**
 * Display navigation to next/previous post when applicable.
 */
function leento_post_nav() {
	// Don't print empty markup if there's nowhere to navigate.
	$previous = ( is_attachment() ) ? get_post( get_post()->post_parent ) : get_adjacent_post( false, '', true );
	$next     = get_adjacent_post( false, '', false );

	if ( ! $next && ! $previous ) {
		return;
	}
	?>
	<nav class="navigation post-navigation" role="navigation">
		<h1 class="screen-reader-text"><?php esc_html_e( 'Post navigation', 'leento' ); ?></h1>
		<div class="nav-links">
			<?php
				previous_post_link( '<div class="nav-previous">%link</div>', '<i class="fa fa-3x fa-angle-left"></i> <div class="meta-nav" aria-hidden="true"><small>' . __( 'Previous Post', 'leento' ) . ' ' . '</small><span>%title</span></div><span class="screen-reader-text">' . __( 'Previous post link', 'leento' ) . '</span> ' );
				next_post_link( '<div class="nav-next">%link</div>', '<div class="meta-nav" aria-hidden="true"><small>' . __( 'Next Post', 'leento' ) . '</small><span>%title</span></div> <i class="fa fa-3x fa-angle-right"></i> ' . '<span class="screen-reader-text">' . __( 'Next Post link', 'leento' ) . '</span> ' );
			?>
		</div><!-- .nav-links -->
	</nav><!-- .navigation -->
	<?php
}
endif;   
 
if ( ! function_exists( 'leento_posted_on' ) ) :
	/**
	 * Prints HTML with meta information for the current post-date/time and author.
	 */
	function leento_posted_on() {
		$time_string = '<time class="entry-date published updated" datetime="%1$s">%2$s</time>';
		if ( get_the_time( 'U' ) !== get_the_modified_time( 'U' ) ) {
			$time_string = '<time class="entry-date published" datetime="%1$s">%2$s</time><time class="updated" datetime="%3$s">%4$s</time>';
		}

		$time_string = sprintf( $time_string,
			esc_attr( get_the_date( 'c' ) ),
			esc_html( get_the_date() ),
			esc_attr( get_the_modified_date( 'c' ) ),
			esc_html( get_the_modified_date() )
		);

		$posted_on = '<a href="' . esc_url( get_permalink() ) . '" rel="bookmark">' . $time_string . '</a>';
		$byline = '<span class="author vcard"><a class="url fn n" href="' . esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ) . '">' . esc_html( get_the_author() ) . '</a></span>';

		echo '<span class="byline spaceBright"><i class="fa fa-user spaceRight"></i>' . $byline . '</span><span class="posted-on spaceBright"><i class="fa fa-calendar spaceRight"></i>' . $posted_on . '</span>'; // WPCS: XSS OK.
	}
endif;

/**
 * Returns true if a blog has more than 1 category.
 *
 * @return bool
 */
function leento_categorized_blog() {
	if ( false === ( $all_the_cool_cats = get_transient( 'leento_categories' ) ) ) {
		// Create an array of all the categories that are attached to posts.
		$all_the_cool_cats = get_categories( array(
			'fields'     => 'ids',
			'hide_empty' => 1,
			// We only need to know if there is more than one category.
			'number'     => 2,
		) );

		// Count the number of categories that are attached to the posts.
		$all_the_cool_cats = count( $all_the_cool_cats );

		set_transient( 'leento_categories', $all_the_cool_cats );
	}

	if ( $all_the_cool_cats > 1 ) {
		// This blog has more than 1 category so leento_categorized_blog should return true.
		return true;
	} else {
		// This blog has only 1 category so leento_categorized_blog should return false.
		return false;
	}
}

/**
 * Flush out the transients used in leento_categorized_blog.
 */
function leento_category_transient_flusher() {
	if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
		return;
	}
	// Like, beat it. Dig?
	delete_transient( 'leento_categories' );
}
add_action( 'edit_category', 'leento_category_transient_flusher' );
add_action( 'save_post',     'leento_category_transient_flusher' );


if ( ! function_exists( 'leento_entry_footer' ) ) :
	/**
	 * Prints HTML with meta information.
	 */
	function leento_entry_footer() {
		
		edit_post_link( esc_html__( 'Edit', 'leento' ), '<span class="edit-link spaceBright"><i class="fa fa-wrench spaceRight" aria-hidden="true"></i>', '</span>' );
		
		if ( ! post_password_required() && ! is_single() &&( comments_open() || get_comments_number() ) ) {
				echo '<span class="comments-link spaceBright"><i class="fa fa-comments-o spaceRight" aria-hidden="true"></i>';
				comments_popup_link(
				sprintf(
					wp_kses(
						/* translators: %s: post title */
						__( 'Leave a Comment<span class="screen-reader-text"> on %s</span>', 'leento' ),
						array(
							'span' => array(
								'class' => array(),
							),
						)
					),
					get_the_title()
				)
			);
			echo '</span>';
		}
		
		if ( 'post' == get_post_type() && is_single() ) {
			/* translators: used between list items, there is a space after the comma */
			$categories_list = get_the_category_list( esc_html__( ', ', 'leento' ) );
			if ( $categories_list && leento_categorized_blog() ) {
				echo '<span class="cat-links spaceBright"><i class="fa fa-folder-open spaceRight" aria-hidden="true"></i>' . $categories_list . '</span>';
			}
		}	
		
		if ( 'post' == get_post_type() && is_single() ) {
			/* translators: used between list items, there is a space after the comma */
			$tags_list = get_the_tag_list( ' ', esc_html__( ', ', 'leento' ) );
			if ( $tags_list ) {
				echo '<span class="tags-links spaceBright"><i class="fa fa-tag spaceRight" aria-hidden="true"></i>' . $tags_list . '</span>';
			}
		}
	}
endif;