<?php
/**
 * Leento Theme Customizer
 *
 * @package Leento
 */

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function leento_customize_register( $wp_customize ) {
	$wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';
}
add_action( 'customize_register', 'leento_customize_register' );

/**
 * Render the site title for the selective refresh partial.
 *
 * @return void
 */
function leento_customize_partial_blogname() {
	bloginfo( 'name' );
}

/**
 * Render the site tagline for the selective refresh partial.
 *
 * @return void
 */
function leento_customize_partial_blogdescription() {
	bloginfo( 'description' );
}

/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function leento_customize_preview_js() {
	wp_enqueue_script( 'leento-customizer', get_template_directory_uri() . '/js/customizer.js', array( 'customize-preview' ), '20151215', true );
}
add_action( 'customize_preview_init', 'leento_customize_preview_js' );

function leento_customizer_script() {
	wp_enqueue_style( 'leento-customizer-style', get_template_directory_uri() .'/inc/css/customizer-style.css');
}
add_action( 'customize_controls_enqueue_scripts', 'leento_customizer_script' );
/**
 * Customize Heading
 **/
if( class_exists( 'WP_Customize_Control' ) ): 
 
 class leento_Customize_Heading extends WP_Customize_Control {
		public $type = 'heading';

		public function render_content() {
			if ( !empty( $this->label ) ) : ?>
				<h3 class="leento-accordion-section-title"><?php echo esc_html( $this->label ); ?></h3>
			<?php endif;

			if($this->description){ ?>
				<span class="description customize-control-description">
				<?php echo wp_kses_post($this->description); ?>
				</span>
			<?php }
		}
	}
endif;
/**
 * Register Custom Settings
 */
function leento_custom_settings_register( $wp_customize ) {
	
	/*
	Leento Options
	=====================================================
	*/
		$wp_customize->add_panel( 'geco_leento_options_panel', array(
		'priority'       => 40,
		'capability'     => 'edit_theme_options',
		'theme_supports' => '',
		'title'          => 'Leento Options',
		'description'    => '',
	) );	
	
	/*==================THEME COLORS========================*/
	$wp_customize->add_section( 'geco_leento_colors', array(
	     'title'    => esc_attr__( 'Theme Colors', 'leento' ),
	     'priority' => 2,
		 'panel'  => 'geco_leento_options_panel',
	) );
	
	/*------------------Menu Section-----------------*/
	$wp_customize->add_setting('leento_theme_options[_heading_general]', array(
		'sanitize_callback' => 'sanitize_text_field',
		'type'       => 'option',
	));
	$wp_customize->add_control(
		new leento_Customize_Heading(
		$wp_customize,
		'leento_theme_options[_heading_general]',
		array(
			'settings'		=> 'leento_theme_options[_heading_general]',
			'section'		=> 'geco_leento_colors',
			'label'			=> __( 'Menu Section', 'leento' ),
			'priority' => 1,
		))
	);
	/*------------------Content Section-----------------*/
	$wp_customize->add_setting('leento_theme_options[_heading_content]', array(
		'sanitize_callback' => 'sanitize_text_field',
		'type'       => 'option',
	));
	$wp_customize->add_control(
		new leento_Customize_Heading(
		$wp_customize,
		'leento_theme_options[_heading_content]',
		array(
			'settings'		=> 'leento_theme_options[_heading_content]',
			'section'		=> 'geco_leento_colors',
			'label'			=> __( 'Content Section', 'leento' ),
			'priority' => 7,
		))
	);
	/*------------------Sidebar Section-----------------*/
	$wp_customize->add_setting('leento_theme_options[_heading_sidebar]', array(
		'sanitize_callback' => 'sanitize_text_field',
		'type'       => 'option',
	));
	$wp_customize->add_control(
		new leento_Customize_Heading(
		$wp_customize,
		'leento_theme_options[_heading_sidebar]',
		array(
			'settings'		=> 'leento_theme_options[_heading_sidebar]',
			'section'		=> 'geco_leento_colors',
			'label'			=> __( 'Sidebar Section', 'leento' ),
			'priority' => 13,
		))
	);
	/*------------------Footer Section-----------------*/
	$wp_customize->add_setting('leento_theme_options[_heading_footer]', array(
		'sanitize_callback' => 'sanitize_text_field',
		'type'       => 'option',
	));
	$wp_customize->add_control(
		new leento_Customize_Heading(
		$wp_customize,
		'leento_theme_options[_heading_footer]',
		array(
			'settings'		=> 'leento_theme_options[_heading_footer]',
			'section'		=> 'geco_leento_colors',
			'label'			=> __( 'Footer Section', 'leento' ),
			'priority' => 17,
		))
	);
	/*
	Start Leento Colors
	=====================================================
	*/
	
	$colors = array();
	
	$colors[] = array(
	'slug'=>'_menu_background_color', 
	'default' => '#e4e4e4',
	'label' => __('Menu Background Color', 'leento'),
	'priority' => 2,
	);
	$colors[] = array(
	'slug'=>'_menu_text_color', 
	'default' => '#6d6d6d',
	'label' => __('Menu Text Color', 'leento'),
	'priority' => 3,
	);
	$colors[] = array(
	'slug'=>'_menu_accent_color', 
	'default' => '#2667ad',
	'label' => __('Menu Accent Color', 'leento'),
	'priority' => 4,
	);
	$colors[] = array(
	'slug'=>'_back_mobile_color', 
	'default' => '#3e3e3e',
	'label' => __('Background Color (Mobile Button)', 'leento'),
	'priority' => 5,
	);
	$colors[] = array(
	'slug'=>'_text_mobile_color', 
	'default' => '#ffffff',
	'label' => __('Text Color (Mobile Button)', 'leento'),
	'priority' => 6,
	);
	$colors[] = array(
	'slug'=>'_body_content_background_color', 
	'default' => '#e6ecea',
	'label' => __('Body Background Color', 'leento'),
	'priority' => 8,
	);
	$colors[] = array(
	'slug'=>'_content_background_color', 
	'default' => '#ffffff',
	'label' => __('Content Background Color', 'leento'),
	'priority' => 9,
	);
	$colors[] = array(
	'slug'=>'_content_text_color', 
	'default' => '#757575',
	'label' => __('Content Text Color', 'leento'),
	'priority' => 10,
	);
	$colors[] = array(
	'slug'=>'_secondary_content_text_color', 
	'default' => '#2667ad',
	'label' => __('Secondary Content Text Color', 'leento'),
	'priority' => 11,
	);
	$colors[] = array(
	'slug'=>'_content_accent_color', 
	'default' => '#6d6d6d',
	'label' => __('Content Accent Color', 'leento'),
	'priority' => 12,
	);
	$colors[] = array(
	'slug'=>'_sidebar_text_color', 
	'default' => '#757575',
	'label' => __('Sidebar Text Color', 'leento'),
	'priority' => 14,
	);
	$colors[] = array(
	'slug'=>'_secondary_sidebar_text_color', 
	'default' => '#2667ad',
	'label' => __('Secondary Sidebar Text Color', 'leento'),
	'priority' => 15,
	);
	$colors[] = array(
	'slug'=>'_sidebar_accent_color', 
	'default' => '#6d6d6d',
	'label' => __('Sidebar Accent Color', 'leento'),
	'priority' => 16,
	);
	$colors[] = array(
	'slug'=>'_footer_background_color', 
	'default' => '#ffffff',
	'label' => __('Footer Background Color', 'leento'),
	'priority' => 18,
	);
	$colors[] = array(
	'slug'=>'_footer_text_color', 
	'default' => '#757575',
	'label' => __('Footer Text Color', 'leento'),
	'priority' => 19,
	);
	$colors[] = array(
	'slug'=>'_secondary_footer_text_color', 
	'default' => '#2667ad',
	'label' => __('Secondary Footer Text Color', 'leento'),
	'priority' => 20,
	);
	$colors[] = array(
	'slug'=>'_footer_accent_color', 
	'default' => '#6d6d6d',
	'label' => __('Footer Accent Color', 'leento'),
	'priority' => 21,
	);
	
	foreach( $colors as $leento_theme_options_colors ) {
		// SETTINGS
		$wp_customize->add_setting( 
			'leento_theme_options[' . $leento_theme_options_colors['slug'] . ']', array(
				'default' => $leento_theme_options_colors['default'],
				'type' => 'option', 
				'sanitize_callback' => 'sanitize_hex_color',
				'capability' => 'edit_theme_options'
			)
		);
		// CONTROLS
		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				'leento_theme_options[' . $leento_theme_options_colors['slug'] . ']', array(
					'label' => $leento_theme_options_colors['label'], 
					'section' => 'geco_leento_colors',
					'settings' =>'leento_theme_options[' . $leento_theme_options_colors['slug'] . ']',
					'priority' => $leento_theme_options_colors['priority'],
				)
			)
		);
	}
	/*=========================SOCIAL========================*/
	$wp_customize->add_section( 'geco_leento_socialmedia', array(
	     'title'    => esc_attr__( 'Social Buttons', 'leento' ),
	     'priority' => 3,
		 'panel'  => 'geco_leento_options_panel',
	) );
	
	/*
	Social Icons
	=====================================================
	*/
	$socialmedia = array();
	
	$socialmedia[] = array(
	'slug'=>'_facebookurl', 
	'default' => '',
	'label' => __('Facebook URL', 'leento')
	);
	$socialmedia[] = array(
	'slug'=>'_twitterurl', 
	'default' => '',
	'label' => __('Twitter URL', 'leento')
	);
	$socialmedia[] = array(
	'slug'=>'_linkedinurl', 
	'default' => '',
	'label' => __('Linkedin URL', 'leento')
	);
	$socialmedia[] = array(
	'slug'=>'_instagramurl', 
	'default' => '',
	'label' => __('Instagram URL', 'leento')
	);
	$socialmedia[] = array(
	'slug'=>'_youtubeurl', 
	'default' => '',
	'label' => __('YouTube URL', 'leento')
	);
	$socialmedia[] = array(
	'slug'=>'_pinteresturl', 
	'default' => '',
	'label' => __('Pinterest URL', 'leento')
	);
	$socialmedia[] = array(
	'slug'=>'_tumblrurl', 
	'default' => '',
	'label' => __('Tumblr URL', 'leento')
	);
	$socialmedia[] = array(
	'slug'=>'_flickrurl', 
	'default' => '',
	'label' => __('Flickr URL', 'leento')
	);
	$socialmedia[] = array(
	'slug'=>'_vkurl', 
	'default' => '',
	'label' => __('VK URL', 'leento')
	);
	$socialmedia[] = array(
	'slug'=>'_xingurl', 
	'default' => '',
	'label' => __('Xing URL', 'leento')
	);
	$socialmedia[] = array(
	'slug'=>'_redditurl', 
	'default' => '',
	'label' => __('Reddit URL', 'leento')
	);
	$socialmedia[] = array(
	'slug'=>'_telegramurl', 
	'default' => '',
	'label' => __('Telegram URL', 'leento')
	);
	$socialmedia[] = array(
	'slug'=>'_facebookmessengerurl', 
	'default' => '',
	'label' => __('Facebook Messenger URL', 'leento')
	);
	
	foreach( $socialmedia as $leento_theme_options ) {
		// SETTINGS
		$wp_customize->add_setting(
			'leento_theme_options[' . $leento_theme_options['slug']. ']', array(
				'default' => $leento_theme_options['default'],
				'capability'     => 'edit_theme_options',
				'sanitize_callback' => 'esc_url_raw',
				'type'     => 'option',
			)
		);
		// CONTROLS
		$wp_customize->add_control(
			'leento_theme_options[' . $leento_theme_options['slug']. ']', 
			array('label' => $leento_theme_options['label'], 
			'section'    => 'geco_leento_socialmedia',
			'settings' =>'leento_theme_options[' . $leento_theme_options['slug']. ']',
			)
		);
	}
		
}

add_action( 'customize_register', 'leento_custom_settings_register' );

function leento_sanitize_checkbox( $input ) {
	if ( $input == 1 ) {
		return 1;
	} else {
		return '';
	}
}

function leento_sanitize_select( $input ) {
	return wp_filter_nohtml_kses( $input );
}

function leento_sanitize_text( $input ) {
	return wp_kses_post( $input );
}

if( ! function_exists('leento_options')){
	function leento_options($name, $default = false) {
		$options = ( get_option( 'leento_theme_options' ) ) ? get_option( 'leento_theme_options' ) : null;
		// return the option if it exists
		if ( isset( $options[ $name ] ) ) {
			return apply_filters( "leento_theme_options_{$name}", $options[ $name ] );
		}
		// return default if nothing else
		return apply_filters( "leento_theme_options_{$name}", $default );
	}
}

/**
 * Social Buttons
 */
if ( ! function_exists( 'leento_pro_social_buttons' ) ) {
	function leento_social_buttons() {
		$openLinks = leento_options('_social_open_links', '_self');
		$facebookURL = leento_options('_facebookurl', '');
		$twitterURL = leento_options('_twitterurl', '');
		$linkedinURL = leento_options('_linkedinurl', '');
		$instagramURL = leento_options('_instagramurl', '');
		$youtubeURL = leento_options('_youtubeurl', '');
		$pinterestURL = leento_options('_pinteresturl', '');
		$tumblrURL = leento_options('_tumblrurl', '');
		$flickrURL = leento_options('_flickrurl', '');
		$vkURL = leento_options('_vkurl', '');
		$xingURL = leento_options('_xingurl', '');
		$redditURL = leento_options('_redditurl', '');
		$facebookmessengerURL = leento_options('_facebookmessengerurl', '');
		$telegramURL = leento_options('_telegramurl', '');
	?>
			<?php if ($facebookURL) : ?>
				<a href="<?php echo esc_url($facebookURL); ?>" target="<?php echo esc_attr($openLinks); ?>" title="<?php esc_attr_e( 'Facebook', 'leento' ); ?>"><i class="fa fa-facebook"><span class="screen-reader-text"><?php esc_html_e( 'Facebook', 'leento' ); ?></span></i></a>
			<?php endif; ?>
			<?php if ($twitterURL) : ?>
				<a href="<?php echo esc_url($twitterURL); ?>" target="<?php echo esc_attr($openLinks); ?>" title="<?php esc_attr_e( 'Twitter', 'leento' ); ?>"><i class="fa fa-twitter"><span class="screen-reader-text"><?php esc_html_e( 'Twitter', 'leento' ); ?></span></i></a>
			<?php endif; ?>
			<?php if ($linkedinURL) : ?>
				<a href="<?php echo esc_url($linkedinURL); ?>" target="<?php echo esc_attr($openLinks); ?>" title="<?php esc_attr_e( 'Linkedin', 'leento' ); ?>"><i class="fa fa-linkedin"><span class="screen-reader-text"><?php esc_html_e( 'Linkedin', 'leento' ); ?></span></i></a>
			<?php endif; ?>
			<?php if ($instagramURL) : ?>
				<a href="<?php echo esc_url($instagramURL); ?>" target="<?php echo esc_attr($openLinks); ?>" title="<?php esc_attr_e( 'Instagram', 'leento' ); ?>"><i class="fa fa-instagram"><span class="screen-reader-text"><?php esc_html_e( 'Instagram', 'leento' ); ?></span></i></a>
			<?php endif; ?>
			<?php if ($youtubeURL) : ?>
				<a href="<?php echo esc_url($youtubeURL); ?>" target="<?php echo esc_attr($openLinks); ?>" title="<?php esc_attr_e( 'YouTube', 'leento' ); ?>"><i class="fa fa-youtube"><span class="screen-reader-text"><?php esc_html_e( 'YouTube', 'leento' ); ?></span></i></a>
			<?php endif; ?>
			<?php if ($pinterestURL) : ?>
				<a href="<?php echo esc_url($pinterestURL); ?>" target="<?php echo esc_attr($openLinks); ?>" title="<?php esc_attr_e( 'Pinterest', 'leento' ); ?>"><i class="fa fa-pinterest"><span class="screen-reader-text"><?php esc_html_e( 'Pinterest', 'leento' ); ?></span></i></a>
			<?php endif; ?>
			<?php if ($tumblrURL) : ?>
				<a href="<?php echo esc_url($tumblrURL); ?>" target="<?php echo esc_attr($openLinks); ?>" title="<?php esc_attr_e( 'Tumblr', 'leento' ); ?>"><i class="fa fa-tumblr"><span class="screen-reader-text"><?php esc_html_e( 'Tumblr', 'leento' ); ?></span></i></a>
			<?php endif; ?>
			<?php if ($flickrURL) : ?>
				<a href="<?php echo esc_url($flickrURL); ?>" target="<?php echo esc_attr($openLinks); ?>" title="<?php esc_attr_e( 'Flickr', 'leento' ); ?>"><i class="fa fa-flickr"><span class="screen-reader-text"><?php esc_html_e( 'Flickr', 'leento' ); ?></span></i></a>
			<?php endif; ?>
			<?php if ($vkURL) : ?>
				<a href="<?php echo esc_url($vkURL); ?>" target="<?php echo esc_attr($openLinks); ?>" title="<?php esc_attr_e( 'VK', 'leento' ); ?>"><i class="fa fa-vk"><span class="screen-reader-text"><?php esc_html_e( 'VK', 'leento' ); ?></span></i></a>
			<?php endif; ?>
			<?php if ($xingURL) : ?>
				<a href="<?php echo esc_url($xingURL); ?>" target="<?php echo esc_attr($openLinks); ?>" title="<?php esc_attr_e( 'Xing', 'leento' ); ?>"><i class="fa fa-xing"><span class="screen-reader-text"><?php esc_html_e( 'Xing', 'leento' ); ?></span></i></a>
			<?php endif; ?>
			<?php if ($redditURL) : ?>
				<a href="<?php echo esc_url($redditURL); ?>" target="<?php echo esc_attr($openLinks); ?>" title="<?php esc_attr_e( 'Reddit', 'leento' ); ?>"><i class="fa fa-reddit-alien"><span class="screen-reader-text"><?php esc_html_e( 'Reddit', 'leento' ); ?></span></i></a>
			<?php endif; ?>
			<?php if ($telegramURL) : ?>
				<a href="<?php echo esc_url($telegramURL); ?>" target="<?php echo esc_attr($openLinks); ?>" title="<?php esc_attr_e( 'Telegram', 'leento' ); ?>"><i class="fa fa-telegram"><span class="screen-reader-text"><?php esc_html_e( 'Telegram', 'leento' ); ?></span></i></a>
			<?php endif; ?>
			<?php if ($facebookmessengerURL) : ?>
				<a href="<?php echo esc_url($facebookmessengerURL); ?>" target="<?php echo esc_attr($openLinks); ?>" title="<?php esc_attr_e( 'Facebook Messenger', 'leento' ); ?>"><i class="fa fa-commenting-o"><span class="screen-reader-text"><?php esc_html_e( 'Facebook Messenger', 'leento' ); ?></span></i></a>
			<?php endif; ?>
		<?php
	}
}
/**
 * Add Custom CSS to Header 
 */
function leento_custom_css_styles() {
	echo '<style type="text/css">';
	$menuBackgroundColor = leento_options('_menu_background_color', '#e4e4e4');
	$menuTextColor = leento_options('_menu_text_color', '#6d6d6d');
	$menuAccentColor = leento_options('_menu_accent_color', '#2667ad');
	$backMobileColor = leento_options('_back_mobile_color', '#3e3e3e');
	$textMobileColor = leento_options('_text_mobile_color', '#ffffff');
	$bodycontentBackgroundColor = leento_options('_body_content_background_color', '#e6ecea');
	$contentBackgroundColor = leento_options('_content_background_color', '#ffffff');
	$contentTextColor = leento_options('_content_text_color', '#757575');
	$seccontentTextColor = leento_options('_secondary_content_text_color', '#2667ad');
	$contentAccentColor = leento_options('_content_accent_color', '#6d6d6d');
	$sidebarTextColor = leento_options('_sidebar_text_color', '#757575');
	$secsidebarTextColor = leento_options('_secondary_sidebar_text_color', '#2667ad');
	$sidebarAccentColor = leento_options('_sidebar_accent_color', '#6d6d6d');
	$footerBackgroundColor = leento_options('_footer_background_color', '#ffffff');
	$footerTextColor = leento_options('_footer_text_color', '#757575');
	$secfooterTextColor = leento_options('_secondary_footer_text_color', '#2667ad');
	$footerAccentColor = leento_options('_footer_accent_color', '#6d6d6d');
	
    /* Menu Background Color */
    list($r, $g, $b) = sscanf($menuBackgroundColor, '#%02x%02x%02x'); ?>
	.main-navigation ul li:hover > a,
	.main-navigation li a:focus, 
	.main-navigation li.current-menu-item > a, 
	.main-navigation li.current-menu-parent > a,
	.main-navigation li.current-page-ancestor > a, 
	.main-navigation .current_page_item > a,
	.main-navigation .current_page_parent > a, 
	.main-navigation ul > li:hover .indicator, 
	.main-navigation li.current-menu-parent .indicator,
	.main-navigation li.current-menu-item .indicator{
		background-color: rgba(<?php echo esc_html($r).', '.esc_html($g).', '.esc_html($b); ?>,0.5);
	}
<?php /* Menu Text Color */ ?>	
	.main-navigation ul li:hover > a,
	.main-navigation li a:focus, 
	.main-navigation li.current-menu-item > a, 
	.main-navigation li.current-menu-parent > a,
	.main-navigation li.current-page-ancestor > a, 
	.main-navigation .current_page_item > a,
	.main-navigation .current_page_parent > a, 
	.main-navigation ul > li:hover .indicator, 
	.main-navigation li.current-menu-parent .indicator,
	.main-navigation li.current-menu-item .indicator{
		color: <?php echo esc_html($menuTextColor); ?>;
	}
<?php /* Menu Accent Color */ ?>	
	.main-navigation ul li > a{
		color: <?php echo esc_html($menuAccentColor); ?>;
	}
	@media screen and (max-width: 1080px)	{
		.main-navigation.toggled ul li:hover > a,
		.main-navigation.toggled ul li:hover .indicator{
			color: <?php echo esc_html($menuAccentColor); ?>;
		}
	}
<?php /* Background Color (Mobile) */ ?>	
	@media screen and (max-width: 1080px)	{
		.main-navigation .menu-toggle,
		.main-navigation.toggled .nav-menu {
			background: <?php echo esc_html($backMobileColor); ?>;
		}
	}
<?php /* Menu Text Color (Mobile) */ ?>	
	@media screen and (max-width: 1080px)	{
		.main-navigation.toggled ul li > a,
		.main-navigation.toggled ul li .indicator,
		.menu-toggle{
			color: <?php echo esc_html($textMobileColor); ?>;
		}
	}	
<?php /* Body Background Color */ ?>
	body{
		background-color: <?php echo esc_html($bodycontentBackgroundColor); ?>;
	}
<?php /* Content Background Color */ ?>
	.hentry,
	.comments-area{
		background: <?php echo esc_html($contentBackgroundColor); ?>;
	}
	.post-navigation .nav-links{
		background-color: <?php echo esc_html($contentBackgroundColor); ?>;
	}
<?php /* Content Text Color */ ?>	
	body .site-content,
	.site-content .entry-header .entry-title a,
	.site-content button,
	.site-content select, 
	.site-content optgroup, 
	.site-content textarea,
	.post-navigation .meta-nav span{
		color: <?php echo esc_html($contentTextColor); ?>;
	}
<?php /* Secondary Content Text Color */ ?>	
	.site-content a,
	.site-content a:visited,
	.post-navigation .meta-nav small,
	.post-navigation .nav-previous i, 
	.post-navigation .nav-next i,
	.post-navigation .meta-nav span:hover,
	#toTop{
		color: <?php echo esc_html($seccontentTextColor); ?>;
	}
	.site-content input[type="text"]:focus,
	.site-content input[type="email"]:focus,
	.site-content input[type="url"]:focus,
	.site-content input[type="password"]:focus,
	.site-content input[type="search"]:focus,
	.site-content input[type="number"]:focus,
	.site-content input[type="tel"]:focus,
	.site-content input[type="range"]:focus,
	.site-content input[type="date"]:focus,
	.site-content input[type="month"]:focus,
	.site-content input[type="week"]:focus,
	.site-content input[type="time"]:focus,
	.site-content input[type="datetime"]:focus,
	.site-content input[type="datetime-local"]:focus,
	.site-content input[type="color"]:focus,
	.site-content textarea:focus,
	.post-navigation .nav-links,
	.hentry,
	.error-404.not-found,
	.no-results.not-found,
	.comments-area{
		border-color: <?php echo esc_html($seccontentTextColor); ?>;
	}
	.archive header .page-title,
	body.search header .page-title{
		border-bottom: 2px solid <?php echo esc_html($seccontentTextColor); ?>;
	}
	.site-content button, 
	.site-content input[type="button"], 
	.site-content input[type="reset"], 
	.site-content input[type="submit"]{
		background: <?php echo esc_html($seccontentTextColor); ?>;
	}
	@media screen and (max-width: 1080px) {
		.main-navigation ul li .indicator,
		.main-navigation ul li:hover > a, 
		.main-navigation li a:focus, 
		.main-navigation li.current-menu-item > a, 
		.main-navigation li.current-menu-parent > a, 
		.main-navigation li.current-page-ancestor > a, 
		.main-navigation .current_page_item > a, 
		.main-navigation .current_page_parent > a, 
		.main-navigation ul > li:hover .indicator, 
		.main-navigation li.current-menu-parent .indicator, 
		.main-navigation li.current-menu-item .indicator{
			color: <?php echo esc_html($seccontentTextColor); ?>;
		}
	}
<?php /* Content Accent Color */ ?>
	a:hover, 
	a:focus,
	a:active, 
	.entry-meta a:hover, 
	.entry-summary a:hover, 
	.entry-footer a:hover, 
	#toTop:hover{
		color: <?php echo esc_html($contentAccentColor); ?>;
	}
<?php /* Sidebar Text Color */ ?>	
	body .widget-area,
	.widget-area button,
	.widget-area select, 
	.widget-area optgroup, 
	.widget-area textarea,
	.leento_side .site-branding .site-description{
		color: <?php echo esc_html($sidebarTextColor); ?>;
	}	
<?php /* Secondary Sidebar Text Color */ ?>	
	.socialHeader a,
	.widget-area a,
	.widget-area a:visited,
	.widget-area .widget-title,
	.leento_side .site-branding .site-title a{
		color: <?php echo esc_html($secsidebarTextColor); ?>;
	}
	.widget-area input[type="text"]:focus,
	.widget-area input[type="email"]:focus,
	.widget-area input[type="url"]:focus,
	.widget-area input[type="password"]:focus,
	.widget-area input[type="search"]:focus,
	.widget-area input[type="number"]:focus,
	.widget-area input[type="tel"]:focus,
	.widget-area input[type="range"]:focus,
	.widget-area input[type="date"]:focus,
	.widget-area input[type="month"]:focus,
	.widget-area input[type="week"]:focus,
	.widget-area input[type="time"]:focus,
	.widget-area input[type="datetime"]:focus,
	.widget-area input[type="datetime-local"]:focus,
	.widget-area input[type="color"]:focus,
	.widget-area textarea:focus,
	.widget-area .widget-title:after{
		border-color: <?php echo esc_html($secsidebarTextColor); ?>;
	}
	.tagcloud a::after{
		border-top: 13px solid <?php echo esc_html($secsidebarTextColor); ?>;
	}
	.widget-area .tagcloud a:hover{
		background-color: <?php echo esc_html($secsidebarTextColor); ?>;
	}
	.widget-area input[type="button"], 
	.widget-area input[type="reset"], 
	.widget-area input[type="submit"],
	#wp-calendar caption,
	.sidebar-toggle{
		background: <?php echo esc_html($secsidebarTextColor); ?>;
	}
	#wp-calendar tbody td#today {
		border: 2px solid <?php echo esc_html($secsidebarTextColor); ?>;
	}
<?php /* Sidebar Accent Color */ ?>
	a:hover, 
	a:focus,
	a:active, 
	.socialHeader a:hover, 
	.widget a:hover,
	.leento_side .site-branding .site-title a:hover{
		color: <?php echo esc_html($sidebarAccentColor); ?>;
	}	
	.widget-area input[type="submit"]:hover,
	.sidebar-toggle:focus,
	.sidebar-toggle:hover{
		background: <?php echo esc_html($sidebarAccentColor); ?>;
	}
<?php /* Footer Background Color */ ?>	
	footer.site-footer {
		background: <?php echo esc_html($footerBackgroundColor); ?>;
	}	
<?php /* Footer Text Color */ ?>	
	footer.site-footer {
		color: <?php echo esc_html($footerTextColor); ?>;
	}		
<?php /* Secondary Footer Text Color */ ?>	
	footer.site-footer a{
		color: <?php echo esc_html($secfooterTextColor); ?>;
	}
	footer.site-footer{
		border-color: <?php echo esc_html($secfooterTextColor); ?>;
	}
<?php /* Footer Accent Color */ ?>
	footer.site-footer a:hover{
		color: <?php echo esc_html($footerAccentColor); ?>;
	}
<?php 
	echo '</style>';
}
add_action('wp_head', 'leento_custom_css_styles');