<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Leento
 */

?>

	</div><!-- #content -->
</div><!-- #page -->
<footer id="colophon" class="site-footer">
	<div class="site-info">
		<span class="leento-copyright">
			<a href="<?php echo esc_url( __( 'https://wordpress.org/', 'leento' ) ); ?>"><?php
				/* translators: %s: CMS name, i.e. WordPress. */
				printf( esc_html__( 'Proudly powered by %s', 'leento' ), 'WordPress' );
			?></a>
			<span class="sep"> | </span>
			<?php
				/* translators: 1: Theme name, 2: Theme author. */
				printf( esc_html__( 'Theme: %1$s by %2$s.', 'leento' ), 'leento', '<a target="_blank" href="https://gecodigital.com/downloads/leento-theme/" rel="nofollow" title="Leento Theme">Leento Lite</a>', 'Gecodigital' );
			?>
			<?php 
				if ( function_exists( 'the_privacy_policy_link' ) ) {
					the_privacy_policy_link( '<span class="sep"> | </span>', '' );
			    }
			?>
		</span>	
		<span class="socialFooter">
			<?php leento_social_buttons(); ?>
		</span>
	</div><!-- .site-info -->
</footer><!-- #colophon -->

<a href="#top" id="toTop"><i class="fa fa-lg fa-angle-up"></i></a>
<?php wp_footer(); ?>

</body>
</html>
