<?php
/**
 * @package Lazy Sunday
 */

if ( ! isset( $content_width ) )
	$content_width = 900;

function lazysunday_sidebars() {
	register_sidebar( array(
		'id' => 'footer-sidebar1',
		'name' => __( 'Footer Sidebar 1', 'lazy-sunday' ),
		'before_widget' => '<li id="%1$s" class="widget %2$s">',
		'after_widget' => '</li>',
		'before_title' => '<h2 class="widgettitle">',
		'after_title' => '</h2>'
		)
	);
	register_sidebar( array(
		'id' => 'footer-sidebar2',
		'name' => __( 'Footer Sidebar 2', 'lazy-sunday' ),
		'before_widget' => '<li id="%1$s" class="widget %2$s">',
		'after_widget' => '</li>',
		'before_title' => '<h2 class="widgettitle">',
		'after_title' => '</h2>'
		)
	);
	register_sidebar( array(
		'id' => 'footer-sidebar3',
		'name' => __( 'Footer Sidebar 3', 'lazy-sunday' ),
		'before_widget' => '<li id="%1$s" class="widget %2$s">',
		'after_widget' => '</li>',
		'before_title' => '<h2 class="widgettitle">',
		'after_title' => '</h2>'
		)
	);
}

add_action( 'widgets_init', 'lazysunday_sidebars' );

function lazy_sunday_theme_setup() {

	register_nav_menu( 'hmenu', __( 'Horizontal Menu' , 'lazy-sunday' ) );

	add_theme_support( 'automatic-feed-links' );

	add_editor_style();

	$args = array(
		'default-color' => 'ffffff',
		'default-image' => get_template_directory_uri() . '/images/background.jpg',
	);

	$args = apply_filters( 'lazysunday_custom_background_args', $args );

	add_theme_support( 'custom-background', $args );

	add_theme_support( 'post-thumbnails' );

	set_post_thumbnail_size( 280, 100, true );

	load_theme_textdomain( 'lazy-sunday', get_template_directory() . '/languages' );

	$locale = get_locale();
	$locale_file = get_template_directory() . "/languages/$locale.php";
	if ( is_readable( $locale_file ) ) {
		require_once( $locale_file );
	}

}

add_action( 'after_setup_theme', 'lazy_sunday_theme_setup' );

function lazysunday_limit_posts_per_archive_page() {
	if ( is_category() || is_tag() || is_archive() || is_search() )
		$limit = 12;
	else
		$limit = get_option( 'posts_per_page' );

	set_query_var( 'posts_per_archive_page', $limit );
}
add_filter( 'pre_get_posts', 'lazysunday_limit_posts_per_archive_page' );

/**
 * Implement the Custom Header feature
 */
require( get_template_directory() . '/inc/custom-header.php' );