<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>

<meta http-equiv="Content-Type" content="<?php echo esc_attr(get_bloginfo('html_type')); ?>; charset=<?php echo esc_attr(get_bloginfo('charset')); ?>" />
<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.2, user-scalable=yes" />

<?php wp_head(); ?>

</head>

<body <?php body_class(); ?>>

<?php
	if ( function_exists( 'wp_body_open' ) )
	{
		wp_body_open();
	}else{
		do_action('wp_body_open');
	}
?>

<a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'laundry-cleaner' ); ?></a>

<?php if(get_theme_mod('laundry_cleaner_site_loader',false)!= ''){ ?>
    <?php if(get_theme_mod( 'laundry_cleaner_preloader_type','four-way-loader') == 'four-way-loader'){ ?>
	    <div class="cssloader">
	    	<div class="sh1"></div>
	    	<div class="sh2"></div>
	    	<h1 class="lt"><?php esc_html_e( 'loading',  'laundry-cleaner' ); ?></h1>
	    </div>
    <?php }else if(get_theme_mod( 'laundry_cleaner_preloader_type') == 'cube-loader') {?>
		<div class="cssloader">
    		<div class="loader-main ">
				<div class="triangle35b"></div>
				<div class="triangle35b"></div>
				<div class="triangle35b"></div>
			</div>
    	</div>
    <?php }?>
<?php }?>
<div class="<?php if( get_theme_mod( 'laundry_cleaner_sticky_header', false) != '') { ?>sticky-header<?php } else { ?>close-sticky main-menus<?php } ?>">
	<header id="site-navigation">
		<div class="container">
			<div class="header-inner">
				<div class="row m-0">
					<div class="col-lg-4 col-md-12 align-self-center">
						<div class="logo text-center text-lg-start">
				    		<div class="logo-image">
				    			<?php the_custom_logo(); ?>
					    	</div>
					    	<div class="logo-content">
						    	<?php
						    		if ( get_theme_mod('laundry_cleaner_display_header_title', true) == true ) :
							      		echo '<a href="' . esc_url(home_url('/')) . '" title="' . esc_attr(get_bloginfo('name')) . '">';
							      			echo esc_html(get_bloginfo('name'));
							      		echo '</a>';
							      	endif;

							      	if ( get_theme_mod('laundry_cleaner_display_header_text', true) == true ) :
						      			echo '<span>'. esc_html(get_bloginfo('description')) . '</span>';
						      		endif;
					    		?>
							</div>
						</div>
					</div>
					<div class="col-lg-2 col-md-3 mb-3 mb-md-0 align-self-center">
						<?php if ( get_theme_mod('laundry_cleaner_phone_number') ) : ?>
							<div class="row">
								<div class="col-lg-3 col-md-3 col-3 align-self-center text-center">
									<i class="fas fa-phone"></i>
								</div>
								<div class="col-lg-9 col-md-9 col-9 align-self-center">
									<h6><?php echo esc_html__('Contact Us','laundry-cleaner');?></h6>
									<p class="mb-0 info-p"><?php echo esc_html(get_theme_mod('laundry_cleaner_phone_number'));?></p>
								</div>
							</div>
						<?php endif; ?>
					</div>
					<div class="col-lg-4 col-md-5 mb-3 mb-md-0 align-self-center">
						<?php if ( get_theme_mod('laundry_cleaner_opening_time') ) : ?>
							<div class="row">
								<div class="col-lg-2 col-md-2 col-3 align-self-center text-center text-md-end">
									<i class="far fa-clock"></i>
								</div>
								<div class="col-lg-10 col-md-10 col-9 align-self-center">
									<h6><?php echo esc_html__('Open Hours','laundry-cleaner');?></h6>
									<p class="mb-0 info-p"><?php echo esc_html(get_theme_mod('laundry_cleaner_opening_time'));?></p>
								</div>
							</div>
						<?php endif; ?>
					</div>
					<div class="col-lg-2 col-md-4 text-center text-md-end align-self-center">
						<?php if ( get_theme_mod('laundry_cleaner_header_btn') || get_theme_mod('laundry_cleaner_header_btn_link') ) : ?>
							<div class="button-header">
								<a href="<?php echo esc_url(get_theme_mod('laundry_cleaner_header_btn_link'));?>" class="mb-3 mb-md-0"><?php echo esc_html(get_theme_mod('laundry_cleaner_header_btn'));?></a>
							</div>
						<?php endif; ?>
					</div>
					<div class="text-center border-top-grey">
							<div class="top-menu-wrapper">
							    <div class="navigation_header">
							        <div class="toggle-nav mobile-menu">
							            <button onclick="laundry_cleaner_openNav()">
							                <span class="dashicons dashicons-menu"></span>
							            </button>
							        </div>
							        <div id="mySidenav" class="nav sidenav">
							            <nav id="site-navigationn" class="main-navigation navbar navbar-expand-xl" aria-label="<?php esc_attr_e( 'Top Menu', 'laundry-cleaner' ); ?>">
							                <?php {
							                    wp_nav_menu(
							                        array(
							                            'theme_location' => 'main-menu',
							                            'container_class' => 'navi clearfix navbar-nav',
							                            'menu_class'     => 'menu clearfix',
							                            'items_wrap'     => '<ul id="%1$s" class="%2$s">%3$s</ul>',
							                            'fallback_cb'    => 'wp_page_menu',
							                        )
							                    );
							                } ?>
							            </nav>
							            <a href="javascript:void(0)" class="closebtn mobile-menu" onclick="laundry_cleaner_closeNav()">
							                <span class="dashicons dashicons-no"></span>
							            </a>
							        </div>
							    </div>
							</div>
					</div>
				</div>
			</div>
		</div>
	</header>
</div>