<?php if ( get_theme_mod('laundry_cleaner_blog_box_enable',false) ) : ?>

<?php $laundry_cleaner_args = array(
  'post_type' => 'post',
  'post_status' => 'publish',
  'category_name' =>  get_theme_mod('laundry_cleaner_blog_slide_category'),
  'posts_per_page' => get_theme_mod('laundry_cleaner_blog_slide_number'),
); ?>

<div class="slider pb-5">
  <div class="slider-inner-banner">
    <div class="clip-path-slider"></div>
    <?php if ( get_theme_mod('laundry_cleaner_slider_banner_image') ) : ?>
      <img class="inner-banner" src="<?php echo esc_url(get_theme_mod('laundry_cleaner_slider_banner_image'));?>">
    <?php else: ?>
      <div class="slider-alternate">
        <img src="<?php echo get_stylesheet_directory_uri() . '/assets/images/banner-slide.png'; ?>">
      </div>
    <?php endif; ?>
    <div class="owl-carousel slider-owl-position">
      <?php $laundry_cleaner_arr_posts = new WP_Query( $laundry_cleaner_args );
      $i = 1;
      if ( $laundry_cleaner_arr_posts->have_posts() ) :
        while ( $laundry_cleaner_arr_posts->have_posts() ) :
          $laundry_cleaner_arr_posts->the_post();
          ?>
          <div class="container">
            <div class="row">
              <div class="col-lg-7 col-md-6 align-self-center">
                <div class="blog_box_inner">
                  <h3><?php the_title(); ?></h3>
                  <p class="mb-4"><?php echo wp_trim_words(get_the_content(), 20); ?></p>
                  <p class="slider-button mb-0">
                    <a href="<?php echo esc_url(get_permalink($post->ID)); ?>"><?php esc_html_e('Get Started','laundry-cleaner'); ?><i class="fas fa-chevron-circle-right ms-2"></i></a>
                  </p>
                </div>
              </div>
              <div class="col-lg-5 col-md-6 align-self-center">
                <div class="blog_inner_box">
                  <?php
                    if ( has_post_thumbnail() ) :
                      the_post_thumbnail();
                    else:
                      ?>
                      <div class="slider-alternate">
                        <img src="<?php echo get_stylesheet_directory_uri() . '/assets/images/slide1.jpg'; ?>">
                      </div>
                      <?php
                    endif;
                  ?>
                </div>
                <?php if ( get_theme_mod('laundry_cleaner_slider_discount'.$i) ) : ?>                 
                  <div class="zigzag-circle">
                    <h4 class="mb-0"><span><?php esc_html_e('Get','laundry-cleaner'); ?></span><?php echo esc_html(get_theme_mod('laundry_cleaner_slider_discount'.$i));?></h4>
                  </div>
                <?php endif; ?>
                <div class="blog_inner_box_two">
                  <?php if ( get_theme_mod('laundry_cleaner_slider_image'.$i) ) : ?>
                    <img src="<?php echo esc_url(get_theme_mod('laundry_cleaner_slider_image'.$i));?>">
                  <?php else: ?>
                    <div class="slider-alternate">
                      <img src="<?php echo get_stylesheet_directory_uri() . '/assets/images/slide2.jpg'; ?>">
                    </div>
                  <?php endif; ?>
                </div>
              </div>
            </div>
          </div>
        <?php
        $i++;
      endwhile;
      wp_reset_postdata();
      endif; ?>
    </div>
  </div>
</div>

<?php endif; ?>