<?php

/**
* Get started notice
*/

add_action( 'wp_ajax_laundry_cleaner_dismissed_notice_handler', 'laundry_cleaner_ajax_notice_handler' );

/**
 * AJAX handler to store the state of dismissible notices.
 */
function laundry_cleaner_ajax_notice_handler() {
    if ( isset( $_POST['type'] ) ) {
        // Pick up the notice "type" - passed via jQuery (the "data-notice" attribute on the notice)
        $type = sanitize_text_field( wp_unslash( $_POST['type'] ) );
        // Store it in the options table
        update_option( 'dismissed-' . $type, TRUE );
    }
}

function laundry_cleaner_deprecated_hook_admin_notice() {
    // Check if it's been dismissed...
    if ( ! get_option( 'dismissed-get_started', false ) ) {
        $current_screen = get_current_screen();

        // Check screen ID correctly
        if ( 
            $current_screen && 
            $current_screen->id !== 'appearance_page_laundry-cleaner-guide-page' &&
            $current_screen->id !== 'appearance_page_laundrycleaner-wizard'
        ) {
            $laundry_cleaner_comments_theme = wp_get_theme();
            ?>
            <div class="laundry-cleaner-notice-wrapper updated notice notice-get-started-class is-dismissible" data-notice="get_started">
                <div class="laundry-cleaner-notice">
                    <div class="laundry-cleaner-notice-content">
                        <div class="laundry-cleaner-notice-heading">
                            <h2>
                                <?php esc_html_e('Thanks For Installing ', 'laundry-cleaner'); ?>
                                <?php echo esc_html( $laundry_cleaner_comments_theme ); ?>
                                <?php esc_html_e('Theme', 'laundry-cleaner'); ?>
                            </h2>
                            <p>
                                <?php
                                /* translators: %s: theme name */
                                printf(
                                    esc_html__("%s is now installed and ready to use. We've provided some links to get you started.", 'laundry-cleaner'),
                                    $laundry_cleaner_comments_theme
                                );
                                ?>
                            </p>
                        </div>
                        <div class="diplay-flex-btn">
                            <a class="button button-primary" href="<?php echo esc_url( admin_url( 'themes.php?page=laundry-cleaner-guide-page' ) ); ?>">
                                <?php echo esc_html__('GET STARTED', 'laundry-cleaner'); ?>
                            </a>
                            <a class="button button-primary" target="_blank" href="<?php echo esc_url( LAUNDRY_CLEANER_BUY_NOW ); ?>">
                                <?php echo esc_html__('GO TO PREMIUM', 'laundry-cleaner'); ?>
                            </a>
                            <a class="button button-primary import" href="<?php echo esc_url( admin_url( 'themes.php?page=laundrycleaner-wizard' ) ); ?>">
                                <?php echo esc_html__('ONE CLICK DEMO IMPORTER', 'laundry-cleaner'); ?>
                            </a>
                        </div>
                    </div>
                    <div class="laundry-cleaner-notice-img">
                        <img src="<?php echo esc_url( get_template_directory_uri() . '/assets/images/notification.png' ); ?>" alt="<?php esc_attr_e('logo', 'laundry-cleaner'); ?>">
                    </div>
                </div>
            </div>
            <?php
        }
    }
}
add_action( 'admin_notices', 'laundry_cleaner_deprecated_hook_admin_notice' );

function laundry_cleaner_admin_enqueue_scripts() {
	wp_enqueue_style( 'laundry-cleaner-admin-style', esc_url( get_template_directory_uri() ).'/css/main.css' );
	wp_enqueue_script( 'laundry-cleaner-admin-script', get_template_directory_uri() . '/js/laundry-cleaner-admin-script.js', array( 'jquery' ), '', true );
	wp_localize_script( 'laundry-cleaner-demo-script', 'laundry_cleaner_demo_object',
        array( 'ajax_url' => admin_url( 'admin-ajax.php' ) )
    );
}
add_action( 'admin_enqueue_scripts', 'laundry_cleaner_admin_enqueue_scripts' );

add_action( 'admin_menu', 'laundry_cleaner_getting_started' );
function laundry_cleaner_getting_started() {
	add_theme_page( esc_html__('Get Started', 'laundry-cleaner'), esc_html__('Get Started', 'laundry-cleaner'), 'edit_theme_options', 'laundry-cleaner-guide-page', 'laundry_cleaner_test_guide');
}

if ( ! defined( 'LAUNDRY_CLEANER_DOCS_FREE' ) ) {
define('LAUNDRY_CLEANER_DOCS_FREE',__('https://demo.misbahwp.com/docs/laundry-services-free-docs/','laundry-cleaner'));
}
if ( ! defined( 'LAUNDRY_CLEANER_DOCS_PRO' ) ) {
define('LAUNDRY_CLEANER_DOCS_PRO',__('https://demo.misbahwp.com/docs/laundry-services-pro-docs/','laundry-cleaner'));
}
if ( ! defined( 'LAUNDRY_CLEANER_BUY_NOW' ) ) {
define('LAUNDRY_CLEANER_BUY_NOW',__('https://www.misbahwp.com/products/laundry-services-wordpress-theme','laundry-cleaner'));
}
if ( ! defined( 'LAUNDRY_CLEANER_SUPPORT_FREE' ) ) {
define('LAUNDRY_CLEANER_SUPPORT_FREE',__('https://wordpress.org/support/theme/laundry-cleaner','laundry-cleaner'));
}
if ( ! defined( 'LAUNDRY_CLEANER_REVIEW_FREE' ) ) {
define('LAUNDRY_CLEANER_REVIEW_FREE',__('https://wordpress.org/support/theme/laundry-cleaner/reviews/#new-post','laundry-cleaner'));
}
if ( ! defined( 'LAUNDRY_CLEANER_DEMO_PRO' ) ) {
define('LAUNDRY_CLEANER_DEMO_PRO',__('https://demo.misbahwp.com/laundry-services/','laundry-cleaner'));
}
if( ! defined( 'LAUNDRY_CLEANER_THEME_BUNDLE' ) ) {
define('LAUNDRY_CLEANER_THEME_BUNDLE',__('https://www.misbahwp.com/products/wordpress-bundle','laundry-cleaner'));
}

function laundry_cleaner_test_guide() { ?>
	<?php $laundry_cleaner_theme = wp_get_theme(); ?>
	<div class="wrap" id="main-page">
		<div id="lefty">
			<div id="admin_links">
				<a href="<?php echo esc_url( LAUNDRY_CLEANER_DOCS_FREE ); ?>" target="_blank" class="blue-button-1"><?php esc_html_e( 'Documentation', 'laundry-cleaner' ) ?></a>
				<a href="<?php echo esc_url( admin_url('customize.php') ); ?>" id="customizer" target="_blank"><?php esc_html_e( 'Customize', 'laundry-cleaner' ); ?> </a>
				<a class="blue-button-1" href="<?php echo esc_url( LAUNDRY_CLEANER_SUPPORT_FREE ); ?>" target="_blank" class="btn3"><?php esc_html_e( 'Support', 'laundry-cleaner' ) ?></a>
				<a class="blue-button-2" href="<?php echo esc_url( LAUNDRY_CLEANER_REVIEW_FREE ); ?>" target="_blank" class="btn4"><?php esc_html_e( 'Review', 'laundry-cleaner' ) ?></a>
			</div>
			<div id="description">
				<h3><?php esc_html_e('Welcome! Thank you for choosing ','laundry-cleaner'); ?><?php echo esc_html( $laundry_cleaner_theme ); ?>  <span><?php esc_html_e('Version: ', 'laundry-cleaner'); ?><?php echo esc_html($laundry_cleaner_theme['Version']);?></span></h3>
				<div class="demo-import-box">
					<h4><?php echo esc_html__('Import homepage demo in just one click.','laundry-cleaner'); ?></h4>
					<p><?php echo esc_html__('Get started with the wordpress theme installation','laundry-cleaner'); ?></p>
					<a class="button button-primary import" href="themes.php?page=laundrycleaner-wizard"><?php echo esc_html__('ONE CLICK DEMO IMPORTER','laundry-cleaner'); ?></a>
				</div>
				<img class="img_responsive" style="width: 100%;" src="<?php echo esc_url( $laundry_cleaner_theme->get_screenshot() ); ?>" />
				<div id="description-insidee">
					<?php
						$laundry_cleaner_theme = wp_get_theme();
						echo wp_kses_post( apply_filters( 'misbah_theme_description', esc_html( $laundry_cleaner_theme->get( 'Description' ) ) ) );
					?>
				</div>
			</div>
		</div>

		<div id="righty">
			<div class="postboxx donate">
				<h3 class="hndle"><?php esc_html_e( 'Upgrade to Premium', 'laundry-cleaner' ); ?></h3>
				<div class="insidee">
					<p><?php esc_html_e('Discover upgraded pro features with premium version click to upgrade.','laundry-cleaner'); ?></p>
					<div id="admin_pro_links">
						<a class="blue-button-2" href="<?php echo esc_url( LAUNDRY_CLEANER_BUY_NOW ); ?>" target="_blank"><?php esc_html_e( 'Go Pro', 'laundry-cleaner' ); ?></a>
						<a class="blue-button-1" href="<?php echo esc_url( LAUNDRY_CLEANER_DEMO_PRO ); ?>" target="_blank"><?php esc_html_e( 'Live Demo', 'laundry-cleaner' ) ?></a>
						<a class="blue-button-2" href="<?php echo esc_url( LAUNDRY_CLEANER_DOCS_PRO ); ?>" target="_blank"><?php esc_html_e( 'Pro Docs', 'laundry-cleaner' ) ?></a>
					</div>
				</div>
				<h3 class="hndle bundle"><?php esc_html_e( 'Get All Themes', 'laundry-cleaner' ); ?></h3>
				<div class="insidee theme-bundle">
					<img width="100%" src="<?php echo esc_url( get_template_directory_uri() . '/assets/images/bundle-image.png' ); ?>" alt="<?php esc_attr_e('logo', 'laundry-cleaner'); ?>">
					<p class="offer"><?php esc_html_e('Get 100+ Perfect WordPress Theme In A Single Package at just $89."','laundry-cleaner'); ?></p>
					<p class="coupon"><?php esc_html_e('Get Our Theme Pack of 100+ WordPress Themes At 15% Off','laundry-cleaner'); ?><span class="coupon-code"><?php esc_html_e('"Bundleup15"','laundry-cleaner'); ?></span></p>
				<div id="admin_pro_linkss">
					<a class="blue-button-1" href="<?php echo esc_url( LAUNDRY_CLEANER_THEME_BUNDLE ); ?>" target="_blank"><?php esc_html_e( 'Buy All Themes - $89', 'laundry-cleaner' ) ?></a>
				</div>
				<div class="d-table">
			    <ul class="d-column">
			      <li class="feature"><?php esc_html_e('Features','laundry-cleaner'); ?></li>
			      <li class="free"><?php esc_html_e('Pro','laundry-cleaner'); ?></li>
			      <li class="plus"><?php esc_html_e('Free','laundry-cleaner'); ?></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('24hrs Priority Support','laundry-cleaner'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-yes"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('LearnPress Campatiblity','laundry-cleaner'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-yes"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Kirki Framework','laundry-cleaner'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-yes"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Advance Posttype','laundry-cleaner'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-no"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('One Click Demo Import','laundry-cleaner'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-no"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Section Reordering','laundry-cleaner'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-no"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Enable / Disable Option','laundry-cleaner'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-yes"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Multiple Sections','laundry-cleaner'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-no"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Advance Color Pallete','laundry-cleaner'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-no"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Advance Widgets','laundry-cleaner'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-yes"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Page Templates','laundry-cleaner'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-no"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Advance Typography','laundry-cleaner'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-no"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Section Background Image / Color ','laundry-cleaner'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-no"></span></li>
			    </ul>
	  		</div>
			</div>
		</div>
	</div>
<?php } ?>