<?php

if ( class_exists("Kirki")){

if ( ! defined( 'LAUNDRY_CLEANER_BUY_NOW' ) ) {
define('LAUNDRY_CLEANER_BUY_NOW',__('https://www.misbahwp.com/products/laundry-services-wordpress-theme','laundry-cleaner'));
}

	// LOGO

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'slider',
		'settings'    => 'laundry_cleaner_logo_resizer',
		'label'       => esc_html__( 'Adjust Your Logo Size ', 'laundry-cleaner' ),
		'section'     => 'title_tagline',
		'choices'     => [
			'min'  => 10,
			'max'  => 300,
			'step' => 10,
		],
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'laundry_cleaner_enable_logo_text',
		'section'     => 'title_tagline',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Enable / Disable Site Title and Tagline', 'laundry-cleaner' ) . '</h3>',
		'priority'    => 10,
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'        => 'switch',
		'settings'    => 'laundry_cleaner_display_header_title',
		'label'       => esc_html__( 'Site Title Enable / Disable Button', 'laundry-cleaner' ),
		'section'     => 'title_tagline',
		'default'     => true,
		'priority'    => 10,
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'laundry-cleaner' ),
			'off' => esc_html__( 'Disable', 'laundry-cleaner' ),
		],
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'switch',
		'settings'    => 'laundry_cleaner_display_header_text',
		'label'       => esc_html__( 'Tagline Enable / Disable Button', 'laundry-cleaner' ),
		'section'     => 'title_tagline',
		'default'     => true,
		'priority'    => 10,
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'laundry-cleaner' ),
			'off' => esc_html__( 'Disable', 'laundry-cleaner' ),
		],
	] );

	// FONT STYLE TYPOGRAPHY

	Kirki::add_panel( 'laundry_cleaner_panel_id', array(
	    'priority'    => 10,
	    'title'       => esc_html__( 'Typography', 'laundry-cleaner' ),
	) );

	Kirki::add_section( 'laundry_cleaner_font_style_section', array(
		'title'      => esc_html__( 'Typography Option',  'laundry-cleaner' ),
		'priority'   => 2,
		'capability' => 'edit_theme_options',
	) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'laundry-cleaner' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( LAUNDRY_CLEANER_BUY_NOW ) . '">' . __( 'GO TO PREMIUM', 'laundry-cleaner' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'laundry_cleaner_font_style_section',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. More Font Family Options </p><p>3. Color Pallete Setup </p><p>4. Section Reordering Facility</p><p>5. For More Options kindly Go For Premium Version.</p>', 'laundry-cleaner' ) . '</div>',
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'laundry_cleaner_all_headings_typography',
		'section'     => 'laundry_cleaner_font_style_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Heading Of All Sections',  'laundry-cleaner' ) . '</h3>',
		'priority'    => 10,
	] );

	Kirki::add_field( 'global', array(
		'type'        => 'typography',
		'settings'    => 'laundry_cleaner_all_headings_typography',
		'label'       => esc_html__( 'Heading Typography',  'laundry-cleaner' ),
		'description' => esc_html__( 'Select the typography options for your heading.',  'laundry-cleaner' ),
		'section'     => 'laundry_cleaner_font_style_section',
		'priority'    => 10,
		'default'     => array(
			'font-family'    => '',
			'variant'        => '',
		),
		'output' => array(
			array(
				'element' => array( 'h1','h2','h3','h4','h5','h6', ),
			),
		),
	) );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'laundry_cleaner_body_content_typography',
		'section'     => 'laundry_cleaner_font_style_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Body Content',  'laundry-cleaner' ) . '</h3>',
		'priority'    => 10,
	] );

	Kirki::add_field( 'global', array(
		'type'        => 'typography',
		'settings'    => 'laundry_cleaner_body_content_typography',
		'label'       => esc_html__( 'Content Typography',  'laundry-cleaner' ),
		'description' => esc_html__( 'Select the typography options for your content.',  'laundry-cleaner' ),
		'section'     => 'laundry_cleaner_font_style_section',
		'priority'    => 10,
		'default'     => array(
			'font-family'    => '',
			'variant'        => '',
		),
		'output' => array(
			array(
				'element' => array( 'body', ),
			),
		),
	) );

		// PANEL
	Kirki::add_panel( 'laundry_cleaner_panel_id_5', array(
	    'priority'    => 10,
	    'title'       => esc_html__( 'Theme Animations', 'laundry-cleaner' ),
	) );

	// ANIMATION SECTION
	Kirki::add_section( 'laundry_cleaner_section_animation', array(
	    'title'          => esc_html__( 'Animations', 'laundry-cleaner' ),
	    'priority'       => 2,
	) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'laundry-cleaner' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( LAUNDRY_CLEANER_BUY_NOW ) . '">' . __( 'GO TO PREMIUM', 'laundry-cleaner' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'laundry_cleaner_section_animation',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. More Font Family Options </p><p>3. Color Pallete Setup </p><p>4. Section Reordering Facility</p><p>5. For More Options kindly Go For Premium Version.</p>', 'laundry-cleaner' ) . '</div>',
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'switch',
		'settings'    => 'laundry_cleaner_animation_enabled',
		'label'       => esc_html__( 'Turn To Show Animation', 'laundry-cleaner' ),
		'section'     => 'laundry_cleaner_section_animation',
		'default'     => true,
		'priority'    => 10,
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'laundry-cleaner' ),
			'off' => esc_html__( 'Disable', 'laundry-cleaner' ),
		],
	] );

	// PANEL
	Kirki::add_panel( 'laundry_cleaner_panel_id_2', array(
	    'priority'    => 10,
	    'title'       => esc_html__( 'Theme Dark Mode', 'laundry-cleaner' ),
	) );

	// DARK MODE SECTION
	Kirki::add_section( 'laundry_cleaner_section_dark_mode', array(
	    'title'          => esc_html__( 'Dark Mode', 'laundry-cleaner' ),
	    'priority'       => 3,
	) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'laundry-cleaner' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( LAUNDRY_CLEANER_BUY_NOW ) . '">' . __( 'GO TO PREMIUM', 'laundry-cleaner' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'laundry_cleaner_section_dark_mode',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. Color Pallete Setup </p><p>3. Section Reordering Facility</p><p>4. For More Options kindly Go For Premium Version.</p>', 'laundry-cleaner' ) . '</div>',
	]);

	Kirki::add_field( 'theme_config_id', [
	    'type'        => 'custom',
	    'settings'    => 'laundry_cleaner_dark_colors',
	    'section'     => 'laundry_cleaner_section_dark_mode',
	    'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Dark Appearance', 'laundry-cleaner' ) . '</h3>',
	    'priority'    => 10,
	]);

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'switch',
		'settings'    => 'laundry_cleaner_is_dark_mode_enabled',
		'label'       => esc_html__( 'Turn To Dark Mode', 'laundry-cleaner' ),
		'section'     => 'laundry_cleaner_section_dark_mode',
		'default'     => false,
		'priority'    => 10,
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'laundry-cleaner' ),
			'off' => esc_html__( 'Disable', 'laundry-cleaner' ),
		],
	] );


	// PANEL
	Kirki::add_panel( 'laundry_cleaner_panel_id_3', array(
	    'priority'    => 10,
	    'title'       => esc_html__( '404 Settings / No Result', 'laundry-cleaner' ),
	) );

	// 404 SECTION
	Kirki::add_section( 'laundry_cleaner_section_404', array(
		'panel'          => 'laundry_cleaner_panel_id_3',
	    'title'          => esc_html__( '404 Settings', 'laundry-cleaner' ),
	    'priority'       => 3,
	) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'laundry-cleaner' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( LAUNDRY_CLEANER_BUY_NOW ) . '">' . __( 'GO TO PREMIUM', 'laundry-cleaner' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'laundry_cleaner_section_404',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. Color Pallete Setup </p><p>3. Section Reordering Facility</p><p>4. For More Options kindly Go For Premium Version.</p>', 'laundry-cleaner' ) . '</div>',
		'priority'    => 10,
	]);

	Kirki::add_field( 'theme_config_id', [
	    'type'        => 'custom',
	    'settings'    => 'laundry_cleaner_404_heading',
	    'section'     => 'laundry_cleaner_section_404',
	    'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( '404 Heading', 'laundry-cleaner' ) . '</h3>',
	    'priority'    => 10,
	]);

	Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'settings' => 'laundry_cleaner_404_page_title',
		'section'  => 'laundry_cleaner_section_404',
		'default'  => esc_html__('404 Not Found', 'laundry-cleaner'),
		'priority' => 10,
	] );

		Kirki::add_field( 'theme_config_id', [
	    'type'        => 'custom',
	    'settings'    => 'laundry_cleaner_404_text',
	    'section'     => 'laundry_cleaner_section_404',
	    'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( '404 Content', 'laundry-cleaner' ) . '</h3>',
	    'priority'    => 10,
	]);

	Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'settings' => 'laundry_cleaner_404_page_content',
		'section'  => 'laundry_cleaner_section_404',
		'default'  => esc_html__('Sorry, no posts matched your criteria.', 'laundry-cleaner'),
		'priority' => 10,
	] );

	// NO Result
	Kirki::add_section( 'laundry_cleaner_no_result', array(
		'panel'          => 'laundry_cleaner_panel_id_3',
	    'title'          => esc_html__( 'No Result Page Settings', 'laundry-cleaner' ),
	    'priority'       => 3,
	) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'laundry-cleaner' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( LAUNDRY_CLEANER_BUY_NOW ) . '">' . __( 'GO TO PREMIUM', 'laundry-cleaner' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'laundry_cleaner_no_result',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. Color Pallete Setup </p><p>3. Section Reordering Facility</p><p>4. For More Options kindly Go For Premium Version.</p>', 'laundry-cleaner' ) . '</div>',
		'priority'    => 10,
	]);

	Kirki::add_field( 'theme_config_id', [
	    'type'        => 'custom',
	    'settings'    => 'laundry_cleaner_not_found_heading',
	    'section'     => 'laundry_cleaner_no_result',
	    'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'No Search Result Heading', 'laundry-cleaner' ) . '</h3>',
	    'priority'    => 10,
	]);

	Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'settings' => 'laundry_cleaner_no_results_page_title',
		'section'  => 'laundry_cleaner_no_result',
		'default'  => esc_html__('404 Not Found', 'laundry-cleaner'),
		'priority' => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
	    'type'        => 'custom',
	    'settings'    => 'laundry_cleaner_not_found_text',
	    'section'     => 'laundry_cleaner_no_result',
	    'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'No Search Result Content', 'laundry-cleaner' ) . '</h3>',
	    'priority'    => 10,
	]);

	Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'settings' => 'laundry_cleaner_no_results_page_content',
		'section'  => 'laundry_cleaner_no_result',
		'default'  => esc_html__('Sorry, but nothing matched your search terms. Please try again with some different keywords.', 'laundry-cleaner'),
		'priority' => 10,
	] );
	
	// PANEL

	Kirki::add_panel( 'laundry_cleaner_panel_id', array(
	    'priority'    => 10,
	    'title'       => esc_html__( 'Theme Options', 'laundry-cleaner' ),
	) );

	//COLOR SECTION

	Kirki::add_section( 'laundry_cleaner_section_color', array(
	    'title'          => esc_html__( 'Global Color', 'laundry-cleaner' ),
	    'panel'          => 'laundry_cleaner_panel_id',
	    'priority'       => 160,
	) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'laundry-cleaner' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( LAUNDRY_CLEANER_BUY_NOW ) . '">' . __( 'GO TO PREMIUM', 'laundry-cleaner' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'laundry_cleaner_section_color',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. More Font Family Options </p><p>3. Color Pallete Setup </p><p>4. Section Reordering Facility</p><p>5. For More Options kindly Go For Premium Version.</p>', 'laundry-cleaner' ) . '</div>',
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'laundry_cleaner_global_colors',
		'section'     => 'laundry_cleaner_section_color',
		'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Here you can change your theme color on one click.', 'laundry-cleaner' ) . '</h3>',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'color',
		'settings'    => 'laundry_cleaner_first_color',
		'label'       => __( 'Choose Your First Color', 'laundry-cleaner' ),
		'section'     => 'laundry_cleaner_section_color',
		'default'     => '#22BCFF',
	] );

	// Additional Settings

	Kirki::add_section( 'laundry_cleaner_additional_settings', array(
	    'title'          => esc_html__( 'Additional Settings', 'laundry-cleaner' ),
	    'panel'          => 'laundry_cleaner_panel_id',
	    'priority'       => 160,
	) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'laundry-cleaner' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( LAUNDRY_CLEANER_BUY_NOW ) . '">' . __( 'GO TO PREMIUM', 'laundry-cleaner' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'laundry_cleaner_additional_settings',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. Color Pallete Setup </p><p>3. Section Reordering Facility</p><p>4. For More Options kindly Go For Premium Version.</p>', 'laundry-cleaner' ) . '</div>',
		'priority'    => 10,
	]);

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'settings'    => 'laundry_cleaner_scroll_enable_setting',
		'label'       => esc_html__( 'Here you can enable or disable your scroller.', 'laundry-cleaner' ),
		'section'     => 'laundry_cleaner_additional_settings',
		'default'     => '1',
		'priority'    => 10,
	] );

	new \Kirki\Field\Radio_Buttonset(
	[
		'settings'    => 'laundry_cleaner_scroll_top_position',
		'label'       => esc_html__( 'Alignment for Scroll To Top', 'laundry-cleaner' ),
		'section'     => 'laundry_cleaner_additional_settings',
		'default'     => 'Right',
		'priority'    => 10,
		'choices'     => [
			'Left'   => esc_html__( 'Left', 'laundry-cleaner' ),
			'Center' => esc_html__( 'Center', 'laundry-cleaner' ),
			'Right'  => esc_html__( 'Right', 'laundry-cleaner' ),
		],
	]
	);

	Kirki::add_field( 'theme_config_id', [
		'type'     => 'dashicons',
		'settings' => 'laundry_cleaner_scroll_top_icon',
		'label'    => esc_html__( 'Select Appropriate Scroll Top Icon', 'laundry-cleaner' ),
		'section'  => 'laundry_cleaner_additional_settings',
		'default'  => 'dashicons dashicons-arrow-up-alt',
		'priority' => 10,
	] );

	new \Kirki\Field\Select(
	[
		'settings'    => 'menu_text_transform_laundry_cleaner',
		'label'       => esc_html__( 'Menus Text Transform', 'laundry-cleaner' ),
		'section'     => 'laundry_cleaner_additional_settings',
		'default'     => 'UPPERCASE',
		'placeholder' => esc_html__( 'Choose an option', 'laundry-cleaner' ),
		'choices'     => [
			'CAPITALISE' => esc_html__( 'CAPITALISE', 'laundry-cleaner' ),
			'UPPERCASE' => esc_html__( 'UPPERCASE', 'laundry-cleaner' ),
			'LOWERCASE' => esc_html__( 'LOWERCASE', 'laundry-cleaner' ),

		],
	] );

	new \Kirki\Field\Select(
	[
		'settings'    => 'laundry_cleaner_menu_zoom',
		'label'       => esc_html__( 'Menu Transition', 'laundry-cleaner' ),
		'section'     => 'laundry_cleaner_additional_settings',
		'default' => 'Zoom Out',
		'placeholder' => esc_html__( 'Choose an option', 'laundry-cleaner' ),
		'choices'     => [
			'Zoomout' => __('Zoom Out','laundry-cleaner'),
            'Zoominn' => __('Zoom Inn','laundry-cleaner'),
            
		],
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'slider',
		'settings'    => 'laundry_cleaner_container_width',
		'label'       => esc_html__( 'Theme Container Width', 'laundry-cleaner' ),
		'section'     => 'laundry_cleaner_additional_settings',
		'default'     => 100,
		'choices'     => [
			'min'  => 50,
			'max'  => 100,
			'step' => 1,
		],
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'settings'    => 'laundry_cleaner_site_loader',
		'label'       => esc_html__( 'Here you can enable or disable your Site Loader.', 'laundry-cleaner' ),
		'section'     => 'laundry_cleaner_additional_settings',
		'default'     => false,
		'priority'    => 10,
	] );

	new \Kirki\Field\Select(
	[
		'settings'    => 'laundry_cleaner_preloader_type',
		'label'       => esc_html__( 'Preloader Type', 'laundry-cleaner' ),
		'section'     => 'laundry_cleaner_additional_settings',
		'default' => 'four-way-loader',
		'placeholder' => esc_html__( 'Choose an option', 'laundry-cleaner' ),
		'choices'     => [
			'four-way-loader' => __('Type 1','laundry-cleaner'),
            'cube-loader' => __('Type 2','laundry-cleaner'),
		],
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'settings'    => 'laundry_cleaner_sticky_header',
		'label'       => esc_html__( 'Here you can enable or disable your Sticky Header.', 'laundry-cleaner' ),
		'section'     => 'laundry_cleaner_additional_settings',
		'default'     => false,
		'priority'    => 10,
	] );

	new \Kirki\Field\Select(
	[
		'settings'    => 'laundry_cleaner_page_layout',
		'label'       => esc_html__( 'Page Layout Setting', 'laundry-cleaner' ),
		'section'     => 'laundry_cleaner_additional_settings',
		'default' => 'Right Sidebar',
		'placeholder' => esc_html__( 'Choose an option', 'laundry-cleaner' ),
		'choices'     => [
			'Left Sidebar' => __('Left Sidebar','laundry-cleaner'),
            'Right Sidebar' => __('Right Sidebar','laundry-cleaner'),
            'One Column' => __('One Column','laundry-cleaner')
		],
	] );

	if ( class_exists("woocommerce")){

	// Woocommerce Settings

	Kirki::add_section( 'laundry_cleaner_woocommerce_settings', array(
		'title'          => esc_html__( 'Woocommerce Settings', 'laundry-cleaner' ),
		'panel'          => 'laundry_cleaner_panel_id',
		'priority'       => 160,
	) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'laundry-cleaner' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( LAUNDRY_CLEANER_BUY_NOW ) . '">' . __( 'GO TO PREMIUM', 'laundry-cleaner' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'laundry_cleaner_woocommerce_settings',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. Color Pallete Setup </p><p>3. Section Reordering Facility</p><p>4. For More Options kindly Go For Premium Version.</p>', 'laundry-cleaner' ) . '</div>',
		'priority'    => 10,
	]);

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'settings'    => 'laundry_cleaner_shop_sidebar',
		'label'       => esc_html__( 'Here you can enable or disable shop page sidebar.', 'laundry-cleaner' ),
		'section'     => 'laundry_cleaner_woocommerce_settings',
		'default'     => '1',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'settings'    => 'laundry_cleaner_product_sidebar',
		'label'       => esc_html__( 'Here you can enable or disable product page sidebar.', 'laundry-cleaner' ),
		'section'     => 'laundry_cleaner_woocommerce_settings',
		'default'     => '1',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'settings'    => 'laundry_cleaner_related_product_setting',
		'label'       => esc_html__( 'Here you can enable or disable your related products.', 'laundry-cleaner' ),
		'section'     => 'laundry_cleaner_woocommerce_settings',
		'default'     => true,
		'priority'    => 10,
	] );

	new \Kirki\Field\Number(
		[
			'settings' => 'laundry_cleaner_per_columns',
			'label'    => esc_html__( 'Product Per Row', 'laundry-cleaner' ),
			'section'  => 'laundry_cleaner_woocommerce_settings',
			'default'  => 3,
			'choices'  => [
				'min'  => 1,
				'max'  => 4,
				'step' => 1,
			],
		]
	);

	new \Kirki\Field\Number(
		[
			'settings' => 'laundry_cleaner_product_per_page',
			'label'    => esc_html__( 'Product Per Page', 'laundry-cleaner' ),
			'section'  => 'laundry_cleaner_woocommerce_settings',
			'default'  => 9,
			'choices'  => [
				'min'  => 1,
				'max'  => 15,
				'step' => 1,
			],
		]
	);

	new \Kirki\Field\Number(
	[
		'settings' => 'custom_related_products_number_per_row',
		'label'    => esc_html__( 'Related Product Per Column', 'laundry-cleaner' ),
		'section'  => 'laundry_cleaner_woocommerce_settings',
		'default'  => 3,
		'choices'  => [
			'min'  => 1,
			'max'  => 4,
			'step' => 1,
		],
	]
	);

	new \Kirki\Field\Number(
	[
		'settings' => 'custom_related_products_number',
		'label'    => esc_html__( 'Related Product Per Page', 'laundry-cleaner' ),
		'section'  => 'laundry_cleaner_woocommerce_settings',
		'default'  => 3,
		'choices'  => [
			'min'  => 1,
			'max'  => 10,
			'step' => 1,
		],
	]
	);

	new \Kirki\Field\Select(
	[
		'settings'    => 'laundry_cleaner_shop_page_layout',
		'label'       => esc_html__( 'Shop Page Layout Setting', 'laundry-cleaner' ),
		'section'     => 'laundry_cleaner_woocommerce_settings',
		'default' => 'Right Sidebar',
		'placeholder' => esc_html__( 'Choose an option', 'laundry-cleaner' ),
		'choices'     => [
			'Left Sidebar' => __('Left Sidebar','laundry-cleaner'),
            'Right Sidebar' => __('Right Sidebar','laundry-cleaner')
		],
	] );

	new \Kirki\Field\Select(
	[
		'settings'    => 'laundry_cleaner_product_page_layout',
		'label'       => esc_html__( 'Product Page Layout Setting', 'laundry-cleaner' ),
		'section'     => 'laundry_cleaner_woocommerce_settings',
		'default' => 'Right Sidebar',
		'placeholder' => esc_html__( 'Choose an option', 'laundry-cleaner' ),
		'choices'     => [
			'Left Sidebar' => __('Left Sidebar','laundry-cleaner'),
            'Right Sidebar' => __('Right Sidebar','laundry-cleaner')
		],
	] );

	new \Kirki\Field\Radio_Buttonset( [
		'settings'    => 'laundry_cleaner_woocommerce_pagination_position',
		'label'       => esc_html__( 'Woocommerce Pagination Alignment', 'laundry-cleaner' ),
		'section'     => 'laundry_cleaner_woocommerce_settings',
		'default'     => 'Center',
		'priority'    => 10,
		'choices'     => [
			'Left'   => esc_html__( 'Left', 'laundry-cleaner' ),
			'Center' => esc_html__( 'Center', 'laundry-cleaner' ),
			'Right'  => esc_html__( 'Right', 'laundry-cleaner' ),
		],
	]
	);

}

	// POST SECTION

	Kirki::add_section( 'laundry_cleaner_section_post', array(
	    'title'          => esc_html__( 'Post Settings', 'laundry-cleaner' ),
	    'panel'          => 'laundry_cleaner_panel_id',
	    'priority'       => 160,
	) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'laundry-cleaner' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( LAUNDRY_CLEANER_BUY_NOW ) . '">' . __( 'GO TO PREMIUM', 'laundry-cleaner' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'laundry_cleaner_section_post',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. Color Pallete Setup </p><p>3. Section Reordering Facility</p><p>4. For More Options kindly Go For Premium Version.</p>', 'laundry-cleaner' ) . '</div>',
		'priority'    => 10,
	]);

		new \Kirki\Field\Sortable(
	[
		'settings' => 'laundry_cleaner_archive_element_sortable',
		'label'    => __( 'Archive Post Page Element Reordering', 'laundry-cleaner' ),
		'description'    => esc_html__( 'This setting is not favorable with post format.', 'laundry-cleaner' ),
		'section'  => 'laundry_cleaner_section_post',
		'default'  => [ 'option1', 'option2', 'option3', 'option4', 'option5' ],
		'choices'  => [
			'option1' => esc_html__( 'Post Image', 'laundry-cleaner' ),
			'option2' => esc_html__( 'Post Meta', 'laundry-cleaner' ),
			'option3' => esc_html__( 'Post Title', 'laundry-cleaner' ),
			'option4' => esc_html__( 'Post Content', 'laundry-cleaner' ),
			'option5' => esc_html__( 'Post Categories', 'laundry-cleaner' ),
		],
	]
	);

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'slider',
		'settings'    => 'laundry_cleaner_post_excerpt_number',
		'label'       => esc_html__( 'Post Content Range', 'laundry-cleaner' ),
		'section'     => 'laundry_cleaner_section_post',
		'default'     => 10,
		'choices'     => [
			'min'  => 0,
			'max'  => 100,
			'step' => 1,
		],
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'settings'    => 'laundry_cleaner_pagination_setting',
		'label'       => esc_html__( 'Here you can enable or disable your Pagination.', 'laundry-cleaner' ),
		'section'     => 'laundry_cleaner_section_post',
		'default'     => true,
		'priority'    => 10,
	] );

	new \Kirki\Field\Select(
	[
		'settings'    => 'laundry_cleaner_archive_sidebar_layout',
		'label'       => esc_html__( 'Archive Post Sidebar Layout Setting', 'laundry-cleaner' ),
		'section'     => 'laundry_cleaner_section_post',
		'default' => 'Right Sidebar',
		'placeholder' => esc_html__( 'Choose an option', 'laundry-cleaner' ),
		'choices'     => [
			'Left Sidebar' => __('Left Sidebar','laundry-cleaner'),
            'Right Sidebar' => __('Right Sidebar','laundry-cleaner'),
            'Three Column' => __('Three Column','laundry-cleaner'),
            'Four Column' => __('Four Column','laundry-cleaner'),
            'Grid Layout Without Sidebar' => __('Grid Layout Without Sidebar','laundry-cleaner'),
            'Grid Layout With Right Sidebar' => __('Grid Layout With Right Sidebar','laundry-cleaner'),
            'Grid Layout With Left Sidebar' => __('Grid Layout With Left Sidebar','laundry-cleaner')
		],
	] );

	new \Kirki\Field\Select(
	[
		'settings'    => 'laundry_cleaner_single_post_sidebar_layout',
		'label'       => esc_html__( 'Single Post Sidebar Layout Setting', 'laundry-cleaner' ),
		'section'     => 'laundry_cleaner_section_post',
		'default' => 'Right Sidebar',
		'placeholder' => esc_html__( 'Choose an option', 'laundry-cleaner' ),
		'choices'     => [
			'Left Sidebar' => __('Left Sidebar','laundry-cleaner'),
            'Right Sidebar' => __('Right Sidebar','laundry-cleaner'),
		],
	] );

	new \Kirki\Field\Select(
	[
		'settings'    => 'laundry_cleaner_search_sidebar_layout',
		'label'       => esc_html__( 'Search Page Sidebar Layout Setting', 'laundry-cleaner' ),
		'section'     => 'laundry_cleaner_section_post',
		'default' => 'Right Sidebar',
		'placeholder' => esc_html__( 'Choose an option', 'laundry-cleaner' ),
		'choices'     => [
			'Left Sidebar' => __('Left Sidebar','laundry-cleaner'),
            'Right Sidebar' => __('Right Sidebar','laundry-cleaner'),
            'Three Column' => __('Three Column','laundry-cleaner'),
            'Four Column' => __('Four Column','laundry-cleaner'),
            'Grid Layout Without Sidebar' => __('Grid Layout Without Sidebar','laundry-cleaner'),
            'Grid Layout With Right Sidebar' => __('Grid Layout With Right Sidebar','laundry-cleaner'),
            'Grid Layout With Left Sidebar' => __('Grid Layout With Left Sidebar','laundry-cleaner')
		],
	] );

	// Breadcrumb
	Kirki::add_section( 'laundry_cleaner_bradcrumb', array(
	    'title'          => esc_html__( 'Breadcrumb Settings', 'laundry-cleaner' ),
	    'panel'          => 'laundry_cleaner_panel_id',
	    'priority'       => 160,
	) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'laundry-cleaner' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( LAUNDRY_CLEANER_BUY_NOW ) . '">' . __( 'GO TO PREMIUM', 'laundry-cleaner' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'laundry_cleaner_bradcrumb',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. Color Pallete Setup </p><p>3. Section Reordering Facility</p><p>4. For More Options kindly Go For Premium Version.</p>', 'laundry-cleaner' ) . '</div>',
		'priority'    => 10,
	]);

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'laundry_cleaner_enable_breadcrumb_heading',
		'section'     => 'laundry_cleaner_bradcrumb',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Enable / Disable Single Page Breadcrumb', 'laundry-cleaner' ) . '</h3>',
		'priority'    => 10,
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'        => 'switch',
		'settings'    => 'laundry_cleaner_breadcrumb_enable',
		'label'       => esc_html__( 'Breadcrumb Enable / Disable', 'laundry-cleaner' ),
		'section'     => 'laundry_cleaner_bradcrumb',
		'default'     => true,
		'priority'    => 10,
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'laundry-cleaner' ),
			'off' => esc_html__( 'Disable', 'laundry-cleaner' ),
		],
	] );

	Kirki::add_field( 'theme_config_id', [
        'type'     => 'text',
        'default'     => '/',
        'settings' => 'laundry_cleaner_breadcrumb_separator' ,
        'label'    => esc_html__( 'Breadcrumb Separator',  'laundry-cleaner' ),
        'section'  => 'laundry_cleaner_bradcrumb',
    ] );

	// HEADER SECTION

	Kirki::add_section( 'laundry_cleaner_header_section', array(
        'title'          => esc_html__( 'Header Settings', 'laundry-cleaner' ),
        'panel'          => 'laundry_cleaner_panel_id',
        'priority'       => 160,
    ) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'laundry-cleaner' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( LAUNDRY_CLEANER_BUY_NOW ) . '">' . __( 'GO TO PREMIUM', 'laundry-cleaner' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'laundry_cleaner_header_section',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. Color Pallete Setup </p><p>3. Section Reordering Facility</p><p>4. For More Options kindly Go For Premium Version.</p>', 'laundry-cleaner' ) . '</div>',
		'priority'    => 10,
	]);

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'laundry_cleaner_phone_number_heading',
		'section'     => 'laundry_cleaner_header_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Phone Number',  'laundry-cleaner' ) . '</h3>',
	] );

	Kirki::add_field( 'theme_config_id', [
        'type'     => 'text',
        'settings' => 'laundry_cleaner_phone_number' ,
        'section'  => 'laundry_cleaner_header_section',
    ] );

    Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'laundry_cleaner_opening_time_heading',
		'section'     => 'laundry_cleaner_header_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Open Hours',  'laundry-cleaner' ) . '</h3>',
	] );

	Kirki::add_field( 'theme_config_id', [
        'type'     => 'text',
        'settings' => 'laundry_cleaner_opening_time' ,
        'section'  => 'laundry_cleaner_header_section',
    ] );

    Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'laundry_cleaner_header_button_heading',
		'section'     => 'laundry_cleaner_header_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Header Button',  'laundry-cleaner' ) . '</h3>',
	] );

	Kirki::add_field( 'theme_config_id', [
	  	'label'    => esc_html__( 'Text',  'laundry-cleaner' ),
        'type'     => 'text',
        'settings' => 'laundry_cleaner_header_btn' ,
        'section'  => 'laundry_cleaner_header_section',
    ] );

	Kirki::add_field( 'theme_config_id', [
	  	'label'    => esc_html__( 'URL',  'laundry-cleaner' ),
        'type'     => 'url',
        'settings' => 'laundry_cleaner_header_btn_link' ,
        'section'  => 'laundry_cleaner_header_section',
    ] );

	// SLIDER SECTION

	Kirki::add_section( 'laundry_cleaner_blog_slide_section', array(
        'title'          => esc_html__( ' Slider Settings', 'laundry-cleaner' ),
        'panel'          => 'laundry_cleaner_panel_id',
        'priority'       => 160,
    ) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'laundry-cleaner' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( LAUNDRY_CLEANER_BUY_NOW ) . '">' . __( 'GO TO PREMIUM', 'laundry-cleaner' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'laundry_cleaner_blog_slide_section',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. Color Pallete Setup </p><p>3. Section Reordering Facility</p><p>4. For More Options kindly Go For Premium Version.</p>', 'laundry-cleaner' ) . '</div>',
		'priority'    => 10,
	]);

    Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'laundry_cleaner_enable_heading',
		'section'     => 'laundry_cleaner_blog_slide_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Enable / Disable Slider', 'laundry-cleaner' ) . '</h3>',
		'priority'    => 10,
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'        => 'switch',
		'settings'    => 'laundry_cleaner_blog_box_enable',
		'label'       => esc_html__( 'Section Enable / Disable', 'laundry-cleaner' ),
		'section'     => 'laundry_cleaner_blog_slide_section',
		'default'     => false,
		'priority'    => 10,
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'laundry-cleaner' ),
			'off' => esc_html__( 'Disable', 'laundry-cleaner' ),
		],
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'laundry_cleaner_slider_heading',
		'section'     => 'laundry_cleaner_blog_slide_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Slider', 'laundry-cleaner' ) . '</h3>',
		'priority'    => 10,
	] );

	new \Kirki\Field\Image(
		[
			'settings'    => 'laundry_cleaner_slider_banner_image',
			'label'       => esc_html__( 'Upload Slider Image', 'laundry-cleaner' ),
			'section'     => 'laundry_cleaner_blog_slide_section',
			'default'     => '',
		]
	);

    Kirki::add_field( 'theme_config_id', [
		'type'        => 'number',
		'settings'    => 'laundry_cleaner_blog_slide_number',
		'label'       => esc_html__( 'Number of slides to show', 'laundry-cleaner' ),
		'section'     => 'laundry_cleaner_blog_slide_section',
		'default'     => 3,
		'choices'     => [
			'min'  => 0,
			'max'  => 3,
			'step' => 1,
		],
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'select',
		'settings'    => 'laundry_cleaner_blog_slide_category',
		'label'       => esc_html__( 'Select the category to show slider ( Image Dimension 1600 x 600 )', 'laundry-cleaner' ),
		'section'     => 'laundry_cleaner_blog_slide_section',
		'default'     => '',
		'placeholder' => esc_html__( 'Select an category...', 'laundry-cleaner' ),
		'priority'    => 10,
		'choices'     => laundry_cleaner_get_categories_select(),
	] );

	$count = get_theme_mod('laundry_cleaner_blog_slide_number');

	for ($i=1; $i <= (int)$count; $i++) {

		Kirki::add_field( 'theme_config_id', [
			'type'        => 'custom',
			'settings'    => 'laundry_cleaner_slider_enable_heading'.$i,
			'section'     => 'laundry_cleaner_blog_slide_section',
				'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Slide Content ', 'laundry-cleaner' ).$i . '</h3>',
		] );
		
		new \Kirki\Field\Image(
			[
				'settings'    => 'laundry_cleaner_slider_image'.$i,
				'label'       => esc_html__( 'Upload Image ', 'laundry-cleaner' ).$i,
				'section'     => 'laundry_cleaner_blog_slide_section',
				'default'     => '',
			]
		);

		Kirki::add_field( 'theme_config_id', [
			'type'        => 'custom',
			'settings'    => 'laundry_cleaner_slider_discount_heading'.$i,
			'section'     => 'laundry_cleaner_blog_slide_section',
			'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Discount Offer', 'laundry-cleaner' ).$i . '</h3>',
		] );

		Kirki::add_field( 'theme_config_id', [
			'type'     => 'text',
			'settings' => 'laundry_cleaner_slider_discount'.$i,
			'section'  => 'laundry_cleaner_blog_slide_section',
	    ] );

	}

	//LATEST UPDATE SECTION

	Kirki::add_section( 'laundry_cleaner_testimonial_section', array(
	    'title'          => esc_html__( 'Testimonial Settings', 'laundry-cleaner' ),
	    'panel'          => 'laundry_cleaner_panel_id',
	    'priority'       => 160,
	) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'laundry-cleaner' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( LAUNDRY_CLEANER_BUY_NOW ) . '">' . __( 'GO TO PREMIUM', 'laundry-cleaner' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'laundry_cleaner_testimonial_section',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. Color Pallete Setup </p><p>3. Section Reordering Facility</p><p>4. For More Options kindly Go For Premium Version.</p>', 'laundry-cleaner' ) . '</div>',
		'priority'    => 10,
	]);

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'laundry_cleaner_enable_heading',
		'section'     => 'laundry_cleaner_testimonial_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Enable / Disable Testimonials',  'laundry-cleaner' ) . '</h3>',
		'priority'    => 1,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'switch',
		'settings'    => 'laundry_cleaner_testimonial_section_enable',
		'section'     => 'laundry_cleaner_testimonial_section',
		'default'     => false,
		'priority'    => 2,
		'choices'     => [
			'on'  => esc_html__( 'Enable',  'laundry-cleaner' ),
			'off' => esc_html__( 'Disable',  'laundry-cleaner' ),
		],
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'laundry_cleaner_testimonial_main_short_heading',
		'section'     => 'laundry_cleaner_testimonial_section',
		'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Short Heading',  'laundry-cleaner' ) . '</h3>',
	] );

	Kirki::add_field( 'theme_config_id', [
        'type'     => 'text',
        'settings' => 'laundry_cleaner_testimonial_short_heading' ,
        'section'  => 'laundry_cleaner_testimonial_section',
    ] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'laundry_cleaner_testimonial_main_heading',
		'section'     => 'laundry_cleaner_testimonial_section',
		'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Heading',  'laundry-cleaner' ) . '</h3>',
	] );

	Kirki::add_field( 'theme_config_id', [
        'type'     => 'text',
        'settings' => 'laundry_cleaner_testimonial_heading' ,
        'section'  => 'laundry_cleaner_testimonial_section',
    ] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'laundry_cleaner_number_heading',
		'section'     => 'laundry_cleaner_testimonial_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Number of testimonial post to show','laundry-cleaner' ) . '</h3>',
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'        => 'number',
		'settings'    => 'laundry_cleaner_testimonial_number',
		'section'     => 'laundry_cleaner_testimonial_section',
		'default'     => 0,
		'choices'     => [
			'min'  => 1,
			'max'  => 7,
			'step' => 1,
		],
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'laundry_cleaner_category_heading',
		'section'     => 'laundry_cleaner_testimonial_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Select the category to show trending post',  'laundry-cleaner' ) . '</h3>',
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'select',
		'settings'    => 'laundry_cleaner_testimonial_category',
		'section'     => 'laundry_cleaner_testimonial_section',
		'default'     => '',
		'placeholder' => esc_html__( 'Select an category...', 'laundry-cleaner' ),
		'priority'    => 10,
		'choices'     => laundry_cleaner_get_categories_select(),
	] );

	$count = get_theme_mod('laundry_cleaner_testimonial_number');

	for ($i=1; $i <= (int)$count; $i++) {

		Kirki::add_field( 'theme_config_id', [
			'type'        => 'custom',
			'settings'    => 'laundry_cleaner_testimonial_enable_heading'.$i,
			'section'     => 'laundry_cleaner_testimonial_section',
			'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Designation #', 'laundry-cleaner' ).$i . '</h3>',
		] );

		Kirki::add_field( 'theme_config_id', [
			'type'     => 'text',
			'settings' => 'laundry_cleaner_testimonial_designation'.$i,
			'section'  => 'laundry_cleaner_testimonial_section',
	    ] );

	}

	// FOOTER SECTION

	Kirki::add_section( 'laundry_cleaner_footer_section', array(
        'title'          => esc_html__( 'Footer Settings', 'laundry-cleaner' ),
        'description'    => esc_html__( 'Here you can change copyright text', 'laundry-cleaner' ),
        'panel'          => 'laundry_cleaner_panel_id',
        'priority'       => 160,
    ) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'laundry-cleaner' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( LAUNDRY_CLEANER_BUY_NOW ) . '">' . __( 'GO TO PREMIUM', 'laundry-cleaner' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'laundry_cleaner_footer_section',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. Color Pallete Setup </p><p>3. Section Reordering Facility</p><p>4. For More Options kindly Go For Premium Version.</p>', 'laundry-cleaner' ) . '</div>',
		'priority'    => 10,
	]);

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'laundry_cleaner_footer_enable_heading',
		'section'     => 'laundry_cleaner_footer_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Enable / Disable Footer Link', 'laundry-cleaner' ) . '</h3>',
		'priority'    => 10,
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'        => 'switch',
		'settings'    => 'laundry_cleaner_copyright_enable',
		'label'       => esc_html__( 'Section Enable / Disable', 'laundry-cleaner' ),
		'section'     => 'laundry_cleaner_footer_section',
		'default'     => '1',
		'priority'    => 10,
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'laundry-cleaner' ),
			'off' => esc_html__( 'Disable', 'laundry-cleaner' ),
		],
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'laundry_cleaner_footer_text_heading',
		'section'     => 'laundry_cleaner_footer_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Footer Copyright Text', 'laundry-cleaner' ) . '</h3>',
		'priority'    => 10,
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'settings' => 'laundry_cleaner_footer_text',
		'section'  => 'laundry_cleaner_footer_section',
		'default'  => '',
		'priority' => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
	'type'        => 'custom',
	'settings'    => 'laundry_cleaner_footer_text_heading_2',
	'section'     => 'laundry_cleaner_footer_section',
		'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Footer Copyright Alignment', 'laundry-cleaner' ) . '</h3>',
	'priority'    => 10,
	] );

	new \Kirki\Field\Select(
	[
		'settings'    => 'laundry_cleaner_copyright_text_alignment',
		'label'       => esc_html__( 'Copyright text Alignment', 'laundry-cleaner' ),
		'section'     => 'laundry_cleaner_footer_section',
		'default'     => 'LEFT-ALIGN',
		'placeholder' => esc_html__( 'Choose an option', 'laundry-cleaner' ),
		'choices'     => [
			'LEFT-ALIGN' => esc_html__( 'LEFT-ALIGN', 'laundry-cleaner' ),
			'CENTER-ALIGN' => esc_html__( 'CENTER-ALIGN', 'laundry-cleaner' ),
			'RIGHT-ALIGN' => esc_html__( 'RIGHT-ALIGN', 'laundry-cleaner' ),

		],
	] );

	Kirki::add_field( 'theme_config_id', [
	'type'        => 'custom',
	'settings'    => 'laundry_cleaner_footer_text_heading_1',
	'section'     => 'laundry_cleaner_footer_section',
		'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Footer Copyright Background Color', 'laundry-cleaner' ) . '</h3>',
	'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'color',
		'settings'    => 'laundry_cleaner_copyright_bg',
		'label'       => __( 'Choose Your Copyright Background Color', 'laundry-cleaner' ),
		'section'     => 'laundry_cleaner_footer_section',
		'default'     => '#000000',
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'laundry_cleaner_enable_footer_socail_link',
		'section'     => 'laundry_cleaner_footer_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Social Media Link', 'laundry-cleaner' ) . '</h3>',
		'priority'    => 11,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'repeater',
		'section'     => 'laundry_cleaner_footer_section',
		'priority'    => 11,
		'row_label' => [
			'type'  => 'field',
			'value' => esc_html__( 'Footer Social Icon', 'laundry-cleaner' ),
			'field' => 'link_text',
		],
		'button_label' => esc_html__('Add New Social Icon', 'laundry-cleaner' ),
		'settings'     => 'laundry_cleaner_footer_social_links_settings',
		'default'      => '',
		'fields' 	   => [
			'link_text' => [
				'type'        => 'text',
				'label'       => esc_html__( 'Icon', 'laundry-cleaner' ),
				'description' => esc_html__( 'Add the fontawesome class ex: "fab fa-facebook-f".', 'laundry-cleaner' ),
				'default'     => '',
			],
			'link_url' => [
				'type'        => 'url',
				'label'       => esc_html__( 'Social Link', 'laundry-cleaner' ),
				'description' => esc_html__( 'Add the social icon url here.', 'laundry-cleaner' ),
				'default'     => '',
			],
		],
		'choices' => [
			'limit' => 5
		],
	] );
}