<?php
/**
 * Title: Feature Sections
 * Slug: sections
 * Categories: feature
 */
?>
<!-- wp:group {"align":"wide","style":{"spacing":{"padding":{"top":"var:preset|spacing|md","bottom":"var:preset|spacing|md","right":"0","left":"0"}},"position":{"all":"relative"}},"layout":{"type":"default"}} -->
<div class="wp-block-group alignwide" style="padding-top:var(--wp--preset--spacing--md);padding-right:0;padding-bottom:var(--wp--preset--spacing--md);padding-left:0"><!-- wp:spacer {"height":"600px","style":{"width":{"all":"600px"},"position":{"all":"absolute"},"right":{"all":""},"top":{"all":"0px"},"bottom":{"all":"0px"},"left":{"all":"-300px"},"zIndex":{"all":"-1"}},"gradient":"circle"} -->
<div style="height:600px" aria-hidden="true" class="wp-block-spacer has-circle-gradient-background has-background"></div>
<!-- /wp:spacer -->
<!-- wp:columns {"verticalAlignment":"center","align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|lg","left":"var:preset|spacing|xxl"}}}} -->
<div class="wp-block-columns alignwide are-vertically-aligned-center"><!-- wp:column {"verticalAlignment":"center","style":{"position":"","zIndex":"","top":"","right":"","bottom":"","left":"","order":{"mobile":"1"}},"animation":{"name":"fade-in-up","duration":1,"delay":"0"}} -->
<div class="wp-block-column is-vertically-aligned-center has-animation" style="animation-name:fade-in-up;animation-duration:1s;animation-delay:0s;animation-iteration-count:1"><!-- wp:group {"layout":{"type":"flex","flexWrap":"nowrap"}} -->
<div class="wp-block-group"><!-- wp:paragraph {"align":"left","style":{"spacing":{"margin":{"top":"0","right":"0","bottom":"0","left":"0"}}},"className":"is-style-sub-heading"} -->
<p class="alignleft has-text-align-left is-style-sub-heading alignleft" style="margin-top:0;margin-right:0;margin-bottom:0;margin-left:0">Conversion funnels</p>
<!-- /wp:paragraph --></div>
<!-- /wp:group -->
<!-- wp:heading {"level":3,"gradient":"heading","className":"wp-block-heading","fontSize":"36"} -->
<h3 class="wp-block-heading has-heading-gradient-background has-background has-36-font-size">Solutions to help your business grow</h3>
<!-- /wp:heading -->
<!-- wp:paragraph -->
<p>Our platform provides you with real-time data and insights to help you improve customer experience and maximize conversion.</p>
<!-- /wp:paragraph -->
<!-- wp:columns -->
<div class="wp-block-columns"><!-- wp:column -->
<div class="wp-block-column"><!-- wp:list {"className":"is-style-checklist-circle"} -->
<ul class="is-style-checklist-circle"><!-- wp:list-item -->
<li>Sales funnels</li>
<!-- /wp:list-item -->
<!-- wp:list-item -->
<li>A/B and split testing</li>
<!-- /wp:list-item -->
<!-- wp:list-item -->
<li>Conversion tracking</li>
<!-- /wp:list-item --></ul>
<!-- /wp:list --></div>
<!-- /wp:column -->
<!-- wp:column -->
<div class="wp-block-column"><!-- wp:list {"className":"is-style-checklist-circle"} -->
<ul class="is-style-checklist-circle"><!-- wp:list-item -->
<li>Real time insights</li>
<!-- /wp:list-item -->
<!-- wp:list-item -->
<li>Enhance user journey</li>
<!-- /wp:list-item -->
<!-- wp:list-item -->
<li>Upsells and more</li>
<!-- /wp:list-item --></ul>
<!-- /wp:list --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:column -->
<!-- wp:column {"verticalAlignment":"center","style":{"u002du002dposition":"relative","u002du002dz-index":"1","overflow":{"all":"hidden"},"spacing":{"padding":{"top":"var:preset|spacing|md","right":"var:preset|spacing|md","bottom":"0","left":"var:preset|spacing|md"}}},"gradient":"primary","className":"has-transform is-style-light","animation":{"name":"fade-in-up","duration":1,"delay":"1"}} -->
<div class="wp-block-column is-vertically-aligned-center has-transform is-style-light has-primary-gradient-background has-background has-animation" style="padding-top:var(--wp--preset--spacing--md);padding-right:var(--wp--preset--spacing--md);padding-bottom:0;padding-left:var(--wp--preset--spacing--md);animation-name:fade-in-up;animation-duration:1s;animation-delay:1s;animation-iteration-count:1"><!-- wp:group {"style":{"position":{"all":"relative"},"zIndex":{"all":"1"},"spacing":{"blockGap":"var:preset|spacing|sm"}},"layout":{"type":"flex","orientation":"vertical","justifyContent":"right"}} -->
<div class="wp-block-group"><!-- wp:group {"style":{"spacing":{"margin":{"top":"0","bottom":"0"},"padding":{"top":"var:preset|spacing|sm","right":"var:preset|spacing|sm","bottom":"var:preset|spacing|sm","left":"var:preset|spacing|sm"},"blockGap":"var:preset|spacing|xs"},"width":{"all":"90%"},"color":{"background":"#fffffffc"},"border":{"radius":"8px"}},"className":"is-style-surface","layout":{"type":"flex","flexWrap":"nowrap","justifyContent":"left"},"animation":{"name":"fade-in-up","duration":1,"delay":"1"}} -->
<div class="wp-block-group is-style-surface has-background has-animation" style="border-radius:8px;background-color:#fffffffc;margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--sm);padding-right:var(--wp--preset--spacing--sm);padding-bottom:var(--wp--preset--spacing--sm);padding-left:var(--wp--preset--spacing--sm);animation-name:fade-in-up;animation-duration:1s;animation-delay:1s;animation-iteration-count:1"><!-- wp:image {"style":{"spacing":{"padding":{"top":"var:preset|spacing|xxs","right":"var:preset|spacing|xxs","bottom":"var:preset|spacing|xxs","left":"var:preset|spacing|xxs"}},"border":{"radius":"99px"}},"className":"is-style-icon","textColor":"primary-600","gradient":"primary-lighter","iconSet":"heroicons","iconName":"chart-bar-square","iconSize":"","iconSvgString":"\u003csvg xmlns=\u0022http://www.w3.org/2000/svg\u0022 fill=\u0022none\u0022 stroke=\u0022currentColor\u0022 stroke-width=\u00221.5\u0022 aria-hidden=\u0022true\u0022 viewBox=\u00220 0 24 24\u0022\u003e\u003cpath stroke-linecap=\u0022round\u0022 stroke-linejoin=\u0022round\u0022 d=\u0022M7.5 14.25v2.25m3-4.5v4.5m3-6.75v6.75m3-9v9M6 20.25h12A2.25 2.25 0 0 0 20.25 18V6A2.25 2.25 0 0 0 18 3.75H6A2.25 2.25 0 0 0 3.75 6v12A2.25 2.25 0 0 0 6 20.25z\u0022/\u003e\u003c/svg\u003e"} -->
<figure class="wp-block-image has-custom-border is-style-icon has-primary-600-color has-primary-lighter-gradient-background has-text-color has-background" style="border-radius:99px;padding-top:var(--wp--preset--spacing--xxs);padding-right:var(--wp--preset--spacing--xxs);padding-bottom:var(--wp--preset--spacing--xxs);padding-left:var(--wp--preset--spacing--xxs);--wp--custom--icon--color:var(--wp--preset--color--primary-600,currentColor);--wp--custom--icon--background:var(--wp--preset--gradient--primary-lighter,currentColor);--wp--custom--icon--padding:var(--wp--preset--spacing--xxs) var(--wp--preset--spacing--xxs) var(--wp--preset--spacing--xxs) var(--wp--preset--spacing--xxs);--wp--custom--icon--url:url('data:image/svg+xml;utf8,<svg xmlns=&quot;http://www.w3.org/2000/svg&quot; fill=&quot;none&quot; stroke=&quot;currentColor&quot; stroke-width=&quot;1.5&quot; aria-hidden=&quot;true&quot; viewBox=&quot;0 0 24 24&quot;&gt;<path stroke-linecap=&quot;round&quot; stroke-linejoin=&quot;round&quot; d=&quot;M7.5 14.25v2.25m3-4.5v4.5m3-6.75v6.75m3-9v9M6 20.25h12A2.25 2.25 0 0 0 20.25 18V6A2.25 2.25 0 0 0 18 3.75H6A2.25 2.25 0 0 0 3.75 6v12A2.25 2.25 0 0 0 6 20.25z&quot;/&gt;</svg&gt;')"><img src="#" alt="" style="border-radius:99px"/></figure>
<!-- /wp:image -->
<!-- wp:group {"style":{"spacing":{"blockGap":"0"}},"layout":{"type":"flex","orientation":"vertical"}} -->
<div class="wp-block-group"><!-- wp:paragraph {"style":{"color":{"text":"#1a1533"}},"className":"is-style-heading"} -->
<p class="is-style-heading has-text-color" style="color:#1a1533">Real time analytics</p>
<!-- /wp:paragraph -->
<!-- wp:paragraph {"fontSize":"16"} -->
<p class="has-16-font-size">Track your sales in real time</p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:group -->
<!-- wp:group {"style":{"width":{"all":"100%"}},"layout":{"type":"flex","flexWrap":"nowrap"}} -->
<div class="wp-block-group"><!-- wp:group {"style":{"spacing":{"margin":{"top":"0","bottom":"0"},"blockGap":"var:preset|spacing|xs"},"width":{"all":"90%"},"color":{"background":"#ffffffed"},"border":{"radius":"8px"}},"className":"is-style-surface","layout":{"type":"flex","flexWrap":"nowrap"},"animation":{"name":"fade-in-up","duration":1,"delay":"1.5"}} -->
<div class="wp-block-group is-style-surface has-background has-animation" style="border-radius:8px;background-color:#ffffffed;margin-top:0;margin-bottom:0;animation-name:fade-in-up;animation-duration:1s;animation-delay:1.5s;animation-iteration-count:1"><!-- wp:image {"style":{"spacing":{"padding":{"top":"var:preset|spacing|xxs","right":"var:preset|spacing|xxs","bottom":"var:preset|spacing|xxs","left":"var:preset|spacing|xxs"}},"border":{"radius":"99px"}},"className":"is-style-icon","textColor":"primary-600","gradient":"primary-lighter","iconSet":"heroicons","iconName":"cube","iconSize":"","iconSvgString":"\u003csvg xmlns=\u0022http://www.w3.org/2000/svg\u0022 fill=\u0022none\u0022 stroke=\u0022currentColor\u0022 stroke-width=\u00221.5\u0022 aria-hidden=\u0022true\u0022 viewBox=\u00220 0 24 24\u0022\u003e\u003cpath stroke-linecap=\u0022round\u0022 stroke-linejoin=\u0022round\u0022 d=\u0022m21 7.5-9-5.25L3 7.5m18 0-9 5.25m9-5.25v9l-9 5.25M3 7.5l9 5.25M3 7.5v9l9 5.25m0-9v9\u0022/\u003e\u003c/svg\u003e"} -->
<figure class="wp-block-image has-custom-border is-style-icon has-primary-600-color has-primary-lighter-gradient-background has-text-color has-background" style="border-radius:99px;padding-top:var(--wp--preset--spacing--xxs);padding-right:var(--wp--preset--spacing--xxs);padding-bottom:var(--wp--preset--spacing--xxs);padding-left:var(--wp--preset--spacing--xxs);--wp--custom--icon--color:var(--wp--preset--color--primary-600,currentColor);--wp--custom--icon--background:var(--wp--preset--gradient--primary-lighter,currentColor);--wp--custom--icon--padding:var(--wp--preset--spacing--xxs) var(--wp--preset--spacing--xxs) var(--wp--preset--spacing--xxs) var(--wp--preset--spacing--xxs);--wp--custom--icon--url:url('data:image/svg+xml;utf8,<svg xmlns=&quot;http://www.w3.org/2000/svg&quot; fill=&quot;none&quot; stroke=&quot;currentColor&quot; stroke-width=&quot;1.5&quot; aria-hidden=&quot;true&quot; viewBox=&quot;0 0 24 24&quot;&gt;<path stroke-linecap=&quot;round&quot; stroke-linejoin=&quot;round&quot; d=&quot;m21 7.5-9-5.25L3 7.5m18 0-9 5.25m9-5.25v9l-9 5.25M3 7.5l9 5.25M3 7.5v9l9 5.25m0-9v9&quot;/&gt;</svg&gt;')"><img src="#" alt="" style="border-radius:99px"/></figure>
<!-- /wp:image -->
<!-- wp:group {"style":{"spacing":{"blockGap":"0"}},"layout":{"type":"flex","orientation":"vertical"}} -->
<div class="wp-block-group"><!-- wp:paragraph {"style":{"color":{"text":"#1a1533"}},"className":"is-style-heading"} -->
<p class="is-style-heading has-text-color" style="color:#1a1533">Rock solid foundation</p>
<!-- /wp:paragraph -->
<!-- wp:paragraph {"fontSize":"16"} -->
<p class="has-16-font-size">Build your business with the best</p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:group --></div>
<!-- /wp:group -->
<!-- wp:group {"style":{"spacing":{"margin":{"top":"0","bottom":"0"},"padding":{"bottom":"var:preset|spacing|xxs"},"blockGap":"var:preset|spacing|xs"},"width":{"all":"90%"},"border":{"radius":{"topLeft":"8px","topRight":"8px","bottomLeft":"0px","bottomRight":"0px"}},"color":{"background":"#ffffffde"}},"className":"is-style-surface","layout":{"type":"flex","flexWrap":"nowrap"},"animation":{"name":"fade-in-up","duration":1,"delay":"2"}} -->
<div class="wp-block-group is-style-surface has-background has-animation" style="border-top-left-radius:8px;border-top-right-radius:8px;border-bottom-left-radius:0px;border-bottom-right-radius:0px;background-color:#ffffffde;margin-top:0;margin-bottom:0;padding-bottom:var(--wp--preset--spacing--xxs);animation-name:fade-in-up;animation-duration:1s;animation-delay:2s;animation-iteration-count:1"><!-- wp:image {"style":{"spacing":{"padding":{"top":"var:preset|spacing|xxs","right":"var:preset|spacing|xxs","bottom":"var:preset|spacing|xxs","left":"var:preset|spacing|xxs"}},"border":{"radius":"99px"}},"className":"is-style-icon","textColor":"primary-600","gradient":"primary-lighter","iconSet":"heroicons","iconName":"banknotes","iconSize":"","iconSvgString":"\u003csvg xmlns=\u0022http://www.w3.org/2000/svg\u0022 fill=\u0022none\u0022 stroke=\u0022currentColor\u0022 stroke-width=\u00221.5\u0022 aria-hidden=\u0022true\u0022 viewBox=\u00220 0 24 24\u0022\u003e\u003cpath stroke-linecap=\u0022round\u0022 stroke-linejoin=\u0022round\u0022 d=\u0022M2.25 18.75a60.07 60.07 0 0 1 15.797 2.101c.727.198 1.453-.342 1.453-1.096V18.75M3.75 4.5v.75A.75.75 0 0 1 3 6h-.75m0 0v-.375c0-.621.504-1.125 1.125-1.125H20.25M2.25 6v9m18-10.5v.75c0 .414.336.75.75.75h.75m-1.5-1.5h.375c.621 0 1.125.504 1.125 1.125v9.75c0 .621-.504 1.125-1.125 1.125h-.375m1.5-1.5H21a.75.75 0 0 0-.75.75v.75m0 0H3.75m0 0h-.375a1.125 1.125 0 0 1-1.125-1.125V15m1.5 1.5v-.75A.75.75 0 0 0 3 15h-.75M15 10.5a3 3 0 1 1-6 0 3 3 0 0 1 6 0zm3 0h.008v.008H18V10.5zm-12 0h.008v.008H6V10.5z\u0022/\u003e\u003c/svg\u003e"} -->
<figure class="wp-block-image has-custom-border is-style-icon has-primary-600-color has-primary-lighter-gradient-background has-text-color has-background" style="border-radius:99px;padding-top:var(--wp--preset--spacing--xxs);padding-right:var(--wp--preset--spacing--xxs);padding-bottom:var(--wp--preset--spacing--xxs);padding-left:var(--wp--preset--spacing--xxs);--wp--custom--icon--color:var(--wp--preset--color--primary-600,currentColor);--wp--custom--icon--background:var(--wp--preset--gradient--primary-lighter,currentColor);--wp--custom--icon--padding:var(--wp--preset--spacing--xxs) var(--wp--preset--spacing--xxs) var(--wp--preset--spacing--xxs) var(--wp--preset--spacing--xxs);--wp--custom--icon--url:url('data:image/svg+xml;utf8,<svg xmlns=&quot;http://www.w3.org/2000/svg&quot; fill=&quot;none&quot; stroke=&quot;currentColor&quot; stroke-width=&quot;1.5&quot; aria-hidden=&quot;true&quot; viewBox=&quot;0 0 24 24&quot;&gt;<path stroke-linecap=&quot;round&quot; stroke-linejoin=&quot;round&quot; d=&quot;M2.25 18.75a60.07 60.07 0 0 1 15.797 2.101c.727.198 1.453-.342 1.453-1.096V18.75M3.75 4.5v.75A.75.75 0 0 1 3 6h-.75m0 0v-.375c0-.621.504-1.125 1.125-1.125H20.25M2.25 6v9m18-10.5v.75c0 .414.336.75.75.75h.75m-1.5-1.5h.375c.621 0 1.125.504 1.125 1.125v9.75c0 .621-.504 1.125-1.125 1.125h-.375m1.5-1.5H21a.75.75 0 0 0-.75.75v.75m0 0H3.75m0 0h-.375a1.125 1.125 0 0 1-1.125-1.125V15m1.5 1.5v-.75A.75.75 0 0 0 3 15h-.75M15 10.5a3 3 0 1 1-6 0 3 3 0 0 1 6 0zm3 0h.008v.008H18V10.5zm-12 0h.008v.008H6V10.5z&quot;/&gt;</svg&gt;')"><img src="#" alt="" style="border-radius:99px"/></figure>
<!-- /wp:image -->
<!-- wp:group {"style":{"spacing":{"blockGap":"0"}},"layout":{"type":"flex","orientation":"vertical"}} -->
<div class="wp-block-group"><!-- wp:paragraph {"style":{"color":{"text":"#272144"}},"className":"is-style-heading"} -->
<p class="is-style-heading has-text-color" style="color:#272144">Conversion focussed</p>
<!-- /wp:paragraph -->
<!-- wp:paragraph {"fontSize":"16"} -->
<p class="has-16-font-size">Convert more visitors into customers</p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:group --></div>
<!-- /wp:group --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:group -->
<!-- wp:group {"align":"wide","style":{"u002du002dposition":"relative","u002du002dz-index":"1","position":{"all":"relative"},"zIndex":{"all":"1"},"spacing":{"padding":{"top":"var:preset|spacing|xl","bottom":"var:preset|spacing|xl","right":"0","left":"0"},"margin":{"top":"0"}}},"layout":{"type":"default"}} -->
<div class="wp-block-group alignwide" style="margin-top:0;padding-top:var(--wp--preset--spacing--xl);padding-right:0;padding-bottom:var(--wp--preset--spacing--xl);padding-left:0"><!-- wp:columns {"verticalAlignment":"center","align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|xxl","left":"var:preset|spacing|xxl"}}}} -->
<div class="wp-block-columns alignwide are-vertically-aligned-center"><!-- wp:column {"verticalAlignment":"center","style":{"u002du002dposition":"relative","u002du002dz-index":"1","spacing":{"padding":{"right":"var:preset|spacing|lg","top":"var:preset|spacing|lg","bottom":"0","left":"var:preset|spacing|lg"}},"position":{"all":"relative"}},"gradient":"primary","className":"has-transform is-style-light","animation":{"name":"fade-in-up","duration":1}} -->
<div class="wp-block-column is-vertically-aligned-center has-transform is-style-light has-primary-gradient-background has-background has-animation" style="padding-top:var(--wp--preset--spacing--lg);padding-right:var(--wp--preset--spacing--lg);padding-bottom:0;padding-left:var(--wp--preset--spacing--lg);animation-name:fade-in-up;animation-duration:1s;animation-iteration-count:1"><!-- wp:image {"id":466,"sizeSlug":"full","linkDestination":"none","style":{"border":{"radius":{"topLeft":"15px","topRight":"15px","bottomLeft":"0px","bottomRight":"0px"}},"boxShadow":""}} -->
<figure class="wp-block-image size-full has-custom-border" style="border-top-left-radius:15px;border-top-right-radius:15px;border-bottom-left-radius:0px;border-bottom-right-radius:0px"><img src="<?php echo esc_url( content_url( "/themes/launchify/assets/" ) ) ?>img/screenshot-1024x768-1.png" alt="" class="wp-image-466" style="border-top-left-radius:15px;border-top-right-radius:15px;border-bottom-left-radius:0px;border-bottom-right-radius:0px"/></figure>
<!-- /wp:image -->
<!-- wp:group {"style":{"position":{"all":"absolute"},"top":{"all":"2em","mobile":"-0.7em"},"right":{"all":"2em","mobile":"-0.7em"},"spacing":{"margin":{"top":"0","bottom":"0"},"padding":{"top":"var:preset|spacing|xs","right":"var:preset|spacing|xs","bottom":"var:preset|spacing|xs","left":"var:preset|spacing|xs"},"blockGap":"var:preset|spacing|xxs"},"zIndex":{"all":"2"},"border":{"width":"0px","style":"none","radius":"8px"},"color":{"background":"#fffffe"}},"className":"is-style-surface","layout":{"type":"flex","flexWrap":"nowrap"},"animation":{"name":"fade-in-up","duration":1,"delay":".5"}} -->
<div class="wp-block-group is-style-surface has-background has-animation" style="border-style:none;border-width:0px;border-radius:8px;background-color:#fffffe;margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--xs);padding-right:var(--wp--preset--spacing--xs);padding-bottom:var(--wp--preset--spacing--xs);padding-left:var(--wp--preset--spacing--xs);animation-name:fade-in-up;animation-duration:1s;animation-delay:.5s;animation-iteration-count:1"><!-- wp:image {"style":{"spacing":{"padding":{"top":"var:preset|spacing|xxs","right":"var:preset|spacing|xxs","bottom":"var:preset|spacing|xxs","left":"var:preset|spacing|xxs"}},"border":{"radius":"99px"}},"className":"is-style-icon","textColor":"primary-600","gradient":"primary-lighter","iconSet":"heroicons","iconName":"chart-bar","iconSvgString":"\u003csvg xmlns=\u0022http://www.w3.org/2000/svg\u0022 fill=\u0022none\u0022 stroke=\u0022currentColor\u0022 stroke-width=\u00221.5\u0022 aria-hidden=\u0022true\u0022 viewBox=\u00220 0 24 24\u0022\u003e\u003cpath stroke-linecap=\u0022round\u0022 stroke-linejoin=\u0022round\u0022 d=\u0022M3 13.125C3 12.504 3.504 12 4.125 12h2.25c.621 0 1.125.504 1.125 1.125v6.75C7.5 20.496 6.996 21 6.375 21h-2.25A1.125 1.125 0 0 1 3 19.875v-6.75zm6.75-4.5c0-.621.504-1.125 1.125-1.125h2.25c.621 0 1.125.504 1.125 1.125v11.25c0 .621-.504 1.125-1.125 1.125h-2.25a1.125 1.125 0 0 1-1.125-1.125V8.625zm6.75-4.5c0-.621.504-1.125 1.125-1.125h2.25C20.496 3 21 3.504 21 4.125v15.75c0 .621-.504 1.125-1.125 1.125h-2.25a1.125 1.125 0 0 1-1.125-1.125V4.125z\u0022/\u003e\u003c/svg\u003e"} -->
<figure class="wp-block-image has-custom-border is-style-icon has-primary-600-color has-primary-lighter-gradient-background has-text-color has-background" style="border-radius:99px;padding-top:var(--wp--preset--spacing--xxs);padding-right:var(--wp--preset--spacing--xxs);padding-bottom:var(--wp--preset--spacing--xxs);padding-left:var(--wp--preset--spacing--xxs);--wp--custom--icon--color:var(--wp--preset--color--primary-600,currentColor);--wp--custom--icon--background:var(--wp--preset--gradient--primary-lighter,currentColor);--wp--custom--icon--padding:var(--wp--preset--spacing--xxs) var(--wp--preset--spacing--xxs) var(--wp--preset--spacing--xxs) var(--wp--preset--spacing--xxs);--wp--custom--icon--url:url('data:image/svg+xml;utf8,<svg xmlns=&quot;http://www.w3.org/2000/svg&quot; fill=&quot;none&quot; stroke=&quot;currentColor&quot; stroke-width=&quot;1.5&quot; aria-hidden=&quot;true&quot; viewBox=&quot;0 0 24 24&quot;&gt;<path stroke-linecap=&quot;round&quot; stroke-linejoin=&quot;round&quot; d=&quot;M3 13.125C3 12.504 3.504 12 4.125 12h2.25c.621 0 1.125.504 1.125 1.125v6.75C7.5 20.496 6.996 21 6.375 21h-2.25A1.125 1.125 0 0 1 3 19.875v-6.75zm6.75-4.5c0-.621.504-1.125 1.125-1.125h2.25c.621 0 1.125.504 1.125 1.125v11.25c0 .621-.504 1.125-1.125 1.125h-2.25a1.125 1.125 0 0 1-1.125-1.125V8.625zm6.75-4.5c0-.621.504-1.125 1.125-1.125h2.25C20.496 3 21 3.504 21 4.125v15.75c0 .621-.504 1.125-1.125 1.125h-2.25a1.125 1.125 0 0 1-1.125-1.125V4.125z&quot;/&gt;</svg&gt;')"><img src="#" alt="" style="border-radius:99px"/></figure>
<!-- /wp:image -->
<!-- wp:group {"style":{"spacing":{"blockGap":"0"}},"layout":{"type":"flex","orientation":"vertical"}} -->
<div class="wp-block-group"><!-- wp:paragraph {"textColor":"neutral-800","className":"is-style-heading"} -->
<p class="is-style-heading has-neutral-800-color has-text-color">Boost sales</p>
<!-- /wp:paragraph -->
<!-- wp:paragraph {"fontSize":"14"} -->
<p class="has-14-font-size">All the features</p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:group -->
<!-- wp:group {"style":{"position":{"all":"absolute"},"bottom":{"all":"1em","mobile":"-0.7em"},"left":{"all":"2em","mobile":"-0.7em"},"zIndex":{"all":"2"},"spacing":{"padding":{"top":"var:preset|spacing|xs","right":"var:preset|spacing|xs","bottom":"var:preset|spacing|xs","left":"var:preset|spacing|xs"},"blockGap":"var:preset|spacing|xs"},"border":{"radius":"8px","width":"0px","style":"none"},"color":{"background":"#fefefe82"}},"className":"is-style-surface","layout":{"type":"flex","flexWrap":"nowrap"},"animation":{"name":"fade-in-up","duration":1,"delay":"1"}} -->
<div class="wp-block-group is-style-surface has-background has-animation" style="border-style:none;border-width:0px;border-radius:8px;background-color:#fefefe82;padding-top:var(--wp--preset--spacing--xs);padding-right:var(--wp--preset--spacing--xs);padding-bottom:var(--wp--preset--spacing--xs);padding-left:var(--wp--preset--spacing--xs);animation-name:fade-in-up;animation-duration:1s;animation-delay:1s;animation-iteration-count:1"><!-- wp:group {"style":{"spacing":{"blockGap":"0"}},"layout":{"type":"flex","orientation":"vertical"}} -->
<div class="wp-block-group"><!-- wp:paragraph {"textColor":"neutral-800","className":"is-style-heading"} -->
<p class="is-style-heading has-neutral-800-color has-text-color">Easy to use</p>
<!-- /wp:paragraph -->
<!-- wp:paragraph {"fontSize":"14"} -->
<p class="has-14-font-size">User friendly</p>
<!-- /wp:paragraph --></div>
<!-- /wp:group -->
<!-- wp:image {"style":{"spacing":{"padding":{"top":"var:preset|spacing|xxs","right":"var:preset|spacing|xxs","bottom":"var:preset|spacing|xxs","left":"var:preset|spacing|xxs"}},"border":{"radius":"99px"}},"className":"is-style-icon","textColor":"primary-600","gradient":"primary-lighter","iconSet":"heroicons","iconName":"hand-thumb-up","iconSvgString":"\u003csvg xmlns=\u0022http://www.w3.org/2000/svg\u0022 fill=\u0022none\u0022 stroke=\u0022currentColor\u0022 stroke-width=\u00221.5\u0022 aria-hidden=\u0022true\u0022 viewBox=\u00220 0 24 24\u0022\u003e\u003cpath stroke-linecap=\u0022round\u0022 stroke-linejoin=\u0022round\u0022 d=\u0022M6.633 10.5c.806 0 1.533-.446 2.031-1.08a9.041 9.041 0 0 1 2.861-2.4c.723-.384 1.35-.956 1.653-1.715a4.498 4.498 0 0 0 .322-1.672V3a.75.75 0 0 1 .75-.75A2.25 2.25 0 0 1 16.5 4.5c0 1.152-.26 2.243-.723 3.218-.266.558.107 1.282.725 1.282h3.126c1.026 0 1.945.694 2.054 1.715.045.422.068.85.068 1.285a11.95 11.95 0 0 1-2.649 7.521c-.388.482-.987.729-1.605.729H13.48a4.53 4.53 0 0 1-1.423-.23l-3.114-1.04a4.501 4.501 0 0 0-1.423-.23H5.904M14.25 9h2.25M5.904 18.75c.083.205.173.405.27.602.197.4-.078.898-.523.898h-.908c-.889 0-1.713-.518-1.972-1.368a12 12 0 0 1-.521-3.507c0-1.553.295-3.036.831-4.398C3.387 10.203 4.167 9.75 5 9.75h1.053c.472 0 .745.556.5.96a8.958 8.958 0 0 0-1.302 4.665 8.97 8.97 0 0 0 .654 3.375z\u0022/\u003e\u003c/svg\u003e"} -->
<figure class="wp-block-image has-custom-border is-style-icon has-primary-600-color has-primary-lighter-gradient-background has-text-color has-background" style="border-radius:99px;padding-top:var(--wp--preset--spacing--xxs);padding-right:var(--wp--preset--spacing--xxs);padding-bottom:var(--wp--preset--spacing--xxs);padding-left:var(--wp--preset--spacing--xxs);--wp--custom--icon--color:var(--wp--preset--color--primary-600,currentColor);--wp--custom--icon--background:var(--wp--preset--gradient--primary-lighter,currentColor);--wp--custom--icon--padding:var(--wp--preset--spacing--xxs) var(--wp--preset--spacing--xxs) var(--wp--preset--spacing--xxs) var(--wp--preset--spacing--xxs);--wp--custom--icon--url:url('data:image/svg+xml;utf8,<svg xmlns=&quot;http://www.w3.org/2000/svg&quot; fill=&quot;none&quot; stroke=&quot;currentColor&quot; stroke-width=&quot;1.5&quot; aria-hidden=&quot;true&quot; viewBox=&quot;0 0 24 24&quot;&gt;<path stroke-linecap=&quot;round&quot; stroke-linejoin=&quot;round&quot; d=&quot;M6.633 10.5c.806 0 1.533-.446 2.031-1.08a9.041 9.041 0 0 1 2.861-2.4c.723-.384 1.35-.956 1.653-1.715a4.498 4.498 0 0 0 .322-1.672V3a.75.75 0 0 1 .75-.75A2.25 2.25 0 0 1 16.5 4.5c0 1.152-.26 2.243-.723 3.218-.266.558.107 1.282.725 1.282h3.126c1.026 0 1.945.694 2.054 1.715.045.422.068.85.068 1.285a11.95 11.95 0 0 1-2.649 7.521c-.388.482-.987.729-1.605.729H13.48a4.53 4.53 0 0 1-1.423-.23l-3.114-1.04a4.501 4.501 0 0 0-1.423-.23H5.904M14.25 9h2.25M5.904 18.75c.083.205.173.405.27.602.197.4-.078.898-.523.898h-.908c-.889 0-1.713-.518-1.972-1.368a12 12 0 0 1-.521-3.507c0-1.553.295-3.036.831-4.398C3.387 10.203 4.167 9.75 5 9.75h1.053c.472 0 .745.556.5.96a8.958 8.958 0 0 0-1.302 4.665 8.97 8.97 0 0 0 .654 3.375z&quot;/&gt;</svg&gt;')"><img src="#" alt="" style="border-radius:99px"/></figure>
<!-- /wp:image --></div>
<!-- /wp:group --></div>
<!-- /wp:column -->
<!-- wp:column {"verticalAlignment":"center","style":{"order":{"mobile":"2"},"spacing":{"padding":{"right":"var:preset|spacing|md"}}},"animation":{"name":"fade-in-up","duration":1,"delay":"1"}} -->
<div class="wp-block-column is-vertically-aligned-center has-animation" style="padding-right:var(--wp--preset--spacing--md);animation-name:fade-in-up;animation-duration:1s;animation-delay:1s;animation-iteration-count:1"><!-- wp:group {"layout":{"type":"flex","flexWrap":"nowrap"}} -->
<div class="wp-block-group"><!-- wp:paragraph {"align":"left","style":{"spacing":{"margin":{"top":"0","right":"0","bottom":"0","left":"0"}}},"className":"is-style-sub-heading"} -->
<p class="alignleft has-text-align-left is-style-sub-heading alignleft" style="margin-top:0;margin-right:0;margin-bottom:0;margin-left:0">Smart content</p>
<!-- /wp:paragraph --></div>
<!-- /wp:group -->
<!-- wp:heading {"level":3,"gradient":"heading","className":"wp-block-heading","fontSize":"36"} -->
<h3 class="wp-block-heading has-heading-gradient-background has-background has-36-font-size">Personalized content powered by AI</h3>
<!-- /wp:heading -->
<!-- wp:paragraph -->
<p>Advanced AI-powered algorithms that help you optimize your marketing campaigns and drive revenue growth</p>
<!-- /wp:paragraph -->
<!-- wp:columns -->
<div class="wp-block-columns"><!-- wp:column -->
<div class="wp-block-column"><!-- wp:list {"className":"is-style-checklist-circle"} -->
<ul class="is-style-checklist-circle"><!-- wp:list-item -->
<li>AI-powered support</li>
<!-- /wp:list-item -->
<!-- wp:list-item -->
<li>Cloud based solution</li>
<!-- /wp:list-item -->
<!-- wp:list-item -->
<li>User friendly UI</li>
<!-- /wp:list-item --></ul>
<!-- /wp:list --></div>
<!-- /wp:column -->
<!-- wp:column -->
<div class="wp-block-column"><!-- wp:list {"className":"is-style-checklist-circle"} -->
<ul class="is-style-checklist-circle"><!-- wp:list-item -->
<li>Real time analytics</li>
<!-- /wp:list-item -->
<!-- wp:list-item -->
<li>Boost conversions</li>
<!-- /wp:list-item -->
<!-- wp:list-item -->
<li>Content creation</li>
<!-- /wp:list-item --></ul>
<!-- /wp:list --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:group -->
<!-- wp:group {"align":"wide","style":{"spacing":{"padding":{"top":"var:preset|spacing|md","bottom":"var:preset|spacing|md","right":"0","left":"0"},"margin":{"top":"0"}},"position":{"all":"relative"}},"layout":{"type":"default"}} -->
<div class="wp-block-group alignwide" style="margin-top:0;padding-top:var(--wp--preset--spacing--md);padding-right:0;padding-bottom:var(--wp--preset--spacing--md);padding-left:0"><!-- wp:columns {"verticalAlignment":"center","align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|lg","left":"var:preset|spacing|xxl"}}}} -->
<div class="wp-block-columns alignwide are-vertically-aligned-center"><!-- wp:column {"verticalAlignment":"center","style":{"order":{"mobile":2},"display":"","width":"","maxWidth":""},"animation":{"name":"fade-in-up","duration":1}} -->
<div class="wp-block-column is-vertically-aligned-center has-animation" style="animation-name:fade-in-up;animation-duration:1s;animation-iteration-count:1"><!-- wp:group {"layout":{"type":"flex","flexWrap":"nowrap"}} -->
<div class="wp-block-group"><!-- wp:paragraph {"align":"left","style":{"spacing":{"margin":{"top":"0","right":"0","bottom":"0","left":"0"}}},"className":"is-style-sub-heading"} -->
<p class="alignleft has-text-align-left is-style-sub-heading alignleft" style="margin-top:0;margin-right:0;margin-bottom:0;margin-left:0">Powerful insights</p>
<!-- /wp:paragraph --></div>
<!-- /wp:group -->
<!-- wp:heading {"level":3,"gradient":"heading","className":"wp-block-heading","fontSize":"36"} -->
<h3 class="wp-block-heading has-heading-gradient-background has-background has-36-font-size">Real time insights and automated reporting</h3>
<!-- /wp:heading -->
<!-- wp:paragraph -->
<p>Our platform uses machine learning to provide you with real-time data and insights to help you optimize your strategies and increase your ROI.</p>
<!-- /wp:paragraph -->
<!-- wp:columns -->
<div class="wp-block-columns"><!-- wp:column -->
<div class="wp-block-column"><!-- wp:list {"className":"is-style-checklist-circle"} -->
<ul class="is-style-checklist-circle"><!-- wp:list-item -->
<li>Automated reporting</li>
<!-- /wp:list-item -->
<!-- wp:list-item -->
<li>Data-driven strategies</li>
<!-- /wp:list-item -->
<!-- wp:list-item -->
<li>Powerful insights</li>
<!-- /wp:list-item --></ul>
<!-- /wp:list --></div>
<!-- /wp:column -->
<!-- wp:column -->
<div class="wp-block-column"><!-- wp:list {"className":"is-style-checklist-circle"} -->
<ul class="is-style-checklist-circle"><!-- wp:list-item -->
<li>Social media integration</li>
<!-- /wp:list-item -->
<!-- wp:list-item -->
<li>Continuous deployment</li>
<!-- /wp:list-item -->
<!-- wp:list-item -->
<li>ROI tracking</li>
<!-- /wp:list-item --></ul>
<!-- /wp:list --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:column -->
<!-- wp:column {"verticalAlignment":"center","style":{"u002du002dposition":"relative","u002du002dz-index":"1","spacing":{"padding":{"right":"var:preset|spacing|md","top":"var:preset|spacing|md","bottom":"0","left":"var:preset|spacing|md"}},"overflow":{"all":"hidden"},"border":{"width":"0px","style":"none"}},"gradient":"primary","className":"has-transform is-style-light","animation":{"name":"fade-in-up","duration":1,"delay":"1"}} -->
<div class="wp-block-column is-vertically-aligned-center has-transform is-style-light has-primary-gradient-background has-background has-animation" style="border-style:none;border-width:0px;padding-top:var(--wp--preset--spacing--md);padding-right:var(--wp--preset--spacing--md);padding-bottom:0;padding-left:var(--wp--preset--spacing--md);animation-name:fade-in-up;animation-duration:1s;animation-delay:1s;animation-iteration-count:1"><!-- wp:columns {"isStackedOnMobile":false,"style":{"spacing":{"margin":{"top":"0","bottom":"0"},"blockGap":{"top":"var:preset|spacing|sm","left":"var:preset|spacing|sm"}},"position":{"all":"relative"},"zIndex":{"all":"1"}},"animation":{}} -->
<div class="wp-block-columns is-not-stacked-on-mobile" style="margin-top:0;margin-bottom:0"><!-- wp:column {"verticalAlignment":"top","style":{"spacing":{"padding":{"bottom":"var:preset|spacing|md"}}},"className":"is-style-default","layout":{"type":"default"}} -->
<div class="wp-block-column is-vertically-aligned-top is-style-default" style="padding-bottom:var(--wp--preset--spacing--md)"><!-- wp:group {"style":{"typography":{"lineHeight":1},"spacing":{"blockGap":"var:preset|spacing|xxs"},"color":{"background":"#fffffffc"}},"className":"is-style-surface","layout":{"type":"flex","orientation":"vertical","justifyContent":"left"},"animation":{"name":"fade-in-up","duration":1,"delay":"0"}} -->
<div class="wp-block-group is-style-surface has-background has-animation" style="background-color:#fffffffc;line-height:1;animation-name:fade-in-up;animation-duration:1s;animation-delay:0s;animation-iteration-count:1"><!-- wp:image {"style":{"spacing":{"padding":{"top":"var:preset|spacing|xxs","right":"var:preset|spacing|xxs","bottom":"var:preset|spacing|xxs","left":"var:preset|spacing|xxs"}},"border":{"radius":"99px"}},"className":"is-style-icon","textColor":"primary-600","gradient":"primary-lighter","iconSet":"heroicons","iconName":"chart-pie","iconSize":"","iconSvgString":"\u003csvg xmlns=\u0022http://www.w3.org/2000/svg\u0022 fill=\u0022none\u0022 stroke=\u0022currentColor\u0022 stroke-width=\u00221.5\u0022 aria-hidden=\u0022true\u0022 viewBox=\u00220 0 24 24\u0022\u003e\u003cpath stroke-linecap=\u0022round\u0022 stroke-linejoin=\u0022round\u0022 d=\u0022M10.5 6a7.5 7.5 0 1 0 7.5 7.5h-7.5V6z\u0022/\u003e\u003cpath stroke-linecap=\u0022round\u0022 stroke-linejoin=\u0022round\u0022 d=\u0022M13.5 10.5H21A7.5 7.5 0 0 0 13.5 3v7.5z\u0022/\u003e\u003c/svg\u003e"} -->
<figure class="wp-block-image has-custom-border is-style-icon has-primary-600-color has-primary-lighter-gradient-background has-text-color has-background" style="border-radius:99px;padding-top:var(--wp--preset--spacing--xxs);padding-right:var(--wp--preset--spacing--xxs);padding-bottom:var(--wp--preset--spacing--xxs);padding-left:var(--wp--preset--spacing--xxs);--wp--custom--icon--color:var(--wp--preset--color--primary-600,currentColor);--wp--custom--icon--background:var(--wp--preset--gradient--primary-lighter,currentColor);--wp--custom--icon--padding:var(--wp--preset--spacing--xxs) var(--wp--preset--spacing--xxs) var(--wp--preset--spacing--xxs) var(--wp--preset--spacing--xxs);--wp--custom--icon--url:url('data:image/svg+xml;utf8,<svg xmlns=&quot;http://www.w3.org/2000/svg&quot; fill=&quot;none&quot; stroke=&quot;currentColor&quot; stroke-width=&quot;1.5&quot; aria-hidden=&quot;true&quot; viewBox=&quot;0 0 24 24&quot;&gt;<path stroke-linecap=&quot;round&quot; stroke-linejoin=&quot;round&quot; d=&quot;M10.5 6a7.5 7.5 0 1 0 7.5 7.5h-7.5V6z&quot;/&gt;<path stroke-linecap=&quot;round&quot; stroke-linejoin=&quot;round&quot; d=&quot;M13.5 10.5H21A7.5 7.5 0 0 0 13.5 3v7.5z&quot;/&gt;</svg&gt;')"><img src="#" alt="" style="border-radius:99px"/></figure>
<!-- /wp:image -->
<!-- wp:paragraph {"style":{"counter":{"start":"0","end":"10","duration":"2","delay":"0","suffix":"%"},"color":{"text":"#1a1533"},"spacing":{"padding":{"top":"var:preset|spacing|xxs"}}},"className":"is-style-counter is-style-heading","fontSize":"24"} -->
<p class="is-style-counter is-style-heading has-text-color has-24-font-size" style="color:#1a1533;padding-top:var(--wp--preset--spacing--xxs)">10%</p>
<!-- /wp:paragraph -->
<!-- wp:paragraph {"className":"is-style-default"} -->
<p class="is-style-default">Conversion rate</p>
<!-- /wp:paragraph --></div>
<!-- /wp:group -->
<!-- wp:group {"style":{"typography":{"lineHeight":1},"spacing":{"blockGap":"var:preset|spacing|xxs","margin":{"top":"var:preset|spacing|sm"}},"color":{"background":"#ffffffde"}},"className":"is-style-surface","layout":{"type":"flex","orientation":"vertical","justifyContent":"left"},"animation":{"name":"fade-in-up","duration":1,"delay":"0.2"}} -->
<div class="wp-block-group is-style-surface has-background has-animation" style="background-color:#ffffffde;margin-top:var(--wp--preset--spacing--sm);line-height:1;animation-name:fade-in-up;animation-duration:1s;animation-delay:0.2s;animation-iteration-count:1"><!-- wp:image {"style":{"spacing":{"padding":{"top":"var:preset|spacing|xxs","right":"var:preset|spacing|xxs","bottom":"var:preset|spacing|xxs","left":"var:preset|spacing|xxs"}},"border":{"radius":"99px"}},"className":"is-style-icon","textColor":"primary-600","gradient":"primary-lighter","iconSet":"heroicons","iconName":"rocket-launch","iconSize":"","iconSvgString":"\u003csvg xmlns=\u0022http://www.w3.org/2000/svg\u0022 fill=\u0022none\u0022 stroke=\u0022currentColor\u0022 stroke-width=\u00221.5\u0022 aria-hidden=\u0022true\u0022 viewBox=\u00220 0 24 24\u0022\u003e\u003cpath stroke-linecap=\u0022round\u0022 stroke-linejoin=\u0022round\u0022 d=\u0022M15.59 14.37a6 6 0 0 1-5.84 7.38v-4.8m5.84-2.58a14.98 14.98 0 0 0 6.16-12.12A14.98 14.98 0 0 0 9.631 8.41m5.96 5.96a14.926 14.926 0 0 1-5.841 2.58m-.119-8.54a6 6 0 0 0-7.381 5.84h4.8m2.581-5.84a14.927 14.927 0 0 0-2.58 5.84m2.699 2.7a15.53 15.53 0 0 1-.311.06 15.09 15.09 0 0 1-2.448-2.448 14.9 14.9 0 0 1 .06-.312m-2.24 2.39a4.493 4.493 0 0 0-1.757 4.306 4.493 4.493 0 0 0 4.306-1.758M16.5 9a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0z\u0022/\u003e\u003c/svg\u003e"} -->
<figure class="wp-block-image has-custom-border is-style-icon has-primary-600-color has-primary-lighter-gradient-background has-text-color has-background" style="border-radius:99px;padding-top:var(--wp--preset--spacing--xxs);padding-right:var(--wp--preset--spacing--xxs);padding-bottom:var(--wp--preset--spacing--xxs);padding-left:var(--wp--preset--spacing--xxs);--wp--custom--icon--color:var(--wp--preset--color--primary-600,currentColor);--wp--custom--icon--background:var(--wp--preset--gradient--primary-lighter,currentColor);--wp--custom--icon--padding:var(--wp--preset--spacing--xxs) var(--wp--preset--spacing--xxs) var(--wp--preset--spacing--xxs) var(--wp--preset--spacing--xxs);--wp--custom--icon--url:url('data:image/svg+xml;utf8,<svg xmlns=&quot;http://www.w3.org/2000/svg&quot; fill=&quot;none&quot; stroke=&quot;currentColor&quot; stroke-width=&quot;1.5&quot; aria-hidden=&quot;true&quot; viewBox=&quot;0 0 24 24&quot;&gt;<path stroke-linecap=&quot;round&quot; stroke-linejoin=&quot;round&quot; d=&quot;M15.59 14.37a6 6 0 0 1-5.84 7.38v-4.8m5.84-2.58a14.98 14.98 0 0 0 6.16-12.12A14.98 14.98 0 0 0 9.631 8.41m5.96 5.96a14.926 14.926 0 0 1-5.841 2.58m-.119-8.54a6 6 0 0 0-7.381 5.84h4.8m2.581-5.84a14.927 14.927 0 0 0-2.58 5.84m2.699 2.7a15.53 15.53 0 0 1-.311.06 15.09 15.09 0 0 1-2.448-2.448 14.9 14.9 0 0 1 .06-.312m-2.24 2.39a4.493 4.493 0 0 0-1.757 4.306 4.493 4.493 0 0 0 4.306-1.758M16.5 9a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0z&quot;/&gt;</svg&gt;')"><img src="#" alt="" style="border-radius:99px"/></figure>
<!-- /wp:image -->
<!-- wp:paragraph {"style":{"counter":{"start":"0","end":"300","duration":"2","delay":"0","suffix":"+"},"color":{"text":"#1a1533"},"spacing":{"padding":{"top":"var:preset|spacing|xxs"}}},"className":"is-style-counter is-style-heading","fontSize":"24"} -->
<p class="is-style-counter is-style-heading has-text-color has-24-font-size" style="color:#1a1533;padding-top:var(--wp--preset--spacing--xxs)">300+</p>
<!-- /wp:paragraph -->
<!-- wp:paragraph -->
<p>Success stories</p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:column -->
<!-- wp:column {"verticalAlignment":"bottom","style":{"spacing":{"padding":{"top":"var:preset|spacing|md"}}},"className":"is-style-default","layout":{"type":"default"}} -->
<div class="wp-block-column is-vertically-aligned-bottom is-style-default" style="padding-top:var(--wp--preset--spacing--md)"><!-- wp:group {"style":{"typography":{"lineHeight":1},"spacing":{"blockGap":"var:preset|spacing|xxs"},"color":{"background":"#ffffffed"}},"className":"is-style-surface","layout":{"type":"flex","orientation":"vertical","justifyContent":"left"},"animation":{"name":"fade-in-up","duration":1,"delay":"0"}} -->
<div class="wp-block-group is-style-surface has-background has-animation" style="background-color:#ffffffed;line-height:1;animation-name:fade-in-up;animation-duration:1s;animation-delay:0s;animation-iteration-count:1"><!-- wp:image {"style":{"spacing":{"padding":{"top":"var:preset|spacing|xxs","right":"var:preset|spacing|xxs","bottom":"var:preset|spacing|xxs","left":"var:preset|spacing|xxs"}},"border":{"radius":"99px"}},"className":"is-style-icon","textColor":"primary-600","gradient":"primary-lighter","iconSet":"heroicons","iconName":"user-group","iconSize":"","iconSvgString":"\u003csvg xmlns=\u0022http://www.w3.org/2000/svg\u0022 fill=\u0022none\u0022 stroke=\u0022currentColor\u0022 stroke-width=\u00221.5\u0022 aria-hidden=\u0022true\u0022 viewBox=\u00220 0 24 24\u0022\u003e\u003cpath stroke-linecap=\u0022round\u0022 stroke-linejoin=\u0022round\u0022 d=\u0022M18 18.72a9.094 9.094 0 0 0 3.741-.479 3 3 0 0 0-4.682-2.72m.94 3.198.001.031c0 .225-.012.447-.037.666A11.944 11.944 0 0 1 12 21c-2.17 0-4.207-.576-5.963-1.584A6.062 6.062 0 0 1 6 18.719m12 0a5.971 5.971 0 0 0-.941-3.197m0 0A5.995 5.995 0 0 0 12 12.75a5.995 5.995 0 0 0-5.058 2.772m0 0a3 3 0 0 0-4.681 2.72 8.986 8.986 0 0 0 3.74.477m.94-3.197a5.971 5.971 0 0 0-.94 3.197M15 6.75a3 3 0 1 1-6 0 3 3 0 0 1 6 0zm6 3a2.25 2.25 0 1 1-4.5 0 2.25 2.25 0 0 1 4.5 0zm-13.5 0a2.25 2.25 0 1 1-4.5 0 2.25 2.25 0 0 1 4.5 0z\u0022/\u003e\u003c/svg\u003e"} -->
<figure class="wp-block-image has-custom-border is-style-icon has-primary-600-color has-primary-lighter-gradient-background has-text-color has-background" style="border-radius:99px;padding-top:var(--wp--preset--spacing--xxs);padding-right:var(--wp--preset--spacing--xxs);padding-bottom:var(--wp--preset--spacing--xxs);padding-left:var(--wp--preset--spacing--xxs);--wp--custom--icon--color:var(--wp--preset--color--primary-600,currentColor);--wp--custom--icon--background:var(--wp--preset--gradient--primary-lighter,currentColor);--wp--custom--icon--padding:var(--wp--preset--spacing--xxs) var(--wp--preset--spacing--xxs) var(--wp--preset--spacing--xxs) var(--wp--preset--spacing--xxs);--wp--custom--icon--url:url('data:image/svg+xml;utf8,<svg xmlns=&quot;http://www.w3.org/2000/svg&quot; fill=&quot;none&quot; stroke=&quot;currentColor&quot; stroke-width=&quot;1.5&quot; aria-hidden=&quot;true&quot; viewBox=&quot;0 0 24 24&quot;&gt;<path stroke-linecap=&quot;round&quot; stroke-linejoin=&quot;round&quot; d=&quot;M18 18.72a9.094 9.094 0 0 0 3.741-.479 3 3 0 0 0-4.682-2.72m.94 3.198.001.031c0 .225-.012.447-.037.666A11.944 11.944 0 0 1 12 21c-2.17 0-4.207-.576-5.963-1.584A6.062 6.062 0 0 1 6 18.719m12 0a5.971 5.971 0 0 0-.941-3.197m0 0A5.995 5.995 0 0 0 12 12.75a5.995 5.995 0 0 0-5.058 2.772m0 0a3 3 0 0 0-4.681 2.72 8.986 8.986 0 0 0 3.74.477m.94-3.197a5.971 5.971 0 0 0-.94 3.197M15 6.75a3 3 0 1 1-6 0 3 3 0 0 1 6 0zm6 3a2.25 2.25 0 1 1-4.5 0 2.25 2.25 0 0 1 4.5 0zm-13.5 0a2.25 2.25 0 1 1-4.5 0 2.25 2.25 0 0 1 4.5 0z&quot;/&gt;</svg&gt;')"><img src="#" alt="" style="border-radius:99px"/></figure>
<!-- /wp:image -->
<!-- wp:paragraph {"style":{"counter":{"start":"0","end":"33","duration":"2","delay":"0","suffix":"k"},"color":{"text":"#1a1533"},"spacing":{"padding":{"top":"var:preset|spacing|xxs"}}},"className":"is-style-counter is-style-heading","fontSize":"24"} -->
<p class="is-style-counter is-style-heading has-text-color has-24-font-size" style="color:#1a1533;padding-top:var(--wp--preset--spacing--xxs)">33k</p>
<!-- /wp:paragraph -->
<!-- wp:paragraph -->
<p>Pro members</p>
<!-- /wp:paragraph --></div>
<!-- /wp:group -->
<!-- wp:group {"style":{"typography":{"lineHeight":1},"spacing":{"blockGap":"var:preset|spacing|xxs","margin":{"top":"var:preset|spacing|sm"},"padding":{"bottom":"var:preset|spacing|xxs"}},"border":{"radius":{"bottomLeft":"0px","bottomRight":"0px"},"bottom":{"width":"0px","style":"none"}},"color":{"background":"#ffffffcc"}},"className":"is-style-surface","layout":{"type":"flex","orientation":"vertical","justifyContent":"left"},"animation":{"name":"fade-in-up","duration":1,"delay":"0.2"}} -->
<div class="wp-block-group is-style-surface has-background has-animation" style="border-bottom-left-radius:0px;border-bottom-right-radius:0px;border-bottom-style:none;border-bottom-width:0px;background-color:#ffffffcc;margin-top:var(--wp--preset--spacing--sm);padding-bottom:var(--wp--preset--spacing--xxs);line-height:1;animation-name:fade-in-up;animation-duration:1s;animation-delay:0.2s;animation-iteration-count:1"><!-- wp:image {"style":{"spacing":{"padding":{"top":"var:preset|spacing|xxs","right":"var:preset|spacing|xxs","bottom":"var:preset|spacing|xxs","left":"var:preset|spacing|xxs"}},"border":{"radius":"99px"}},"className":"is-style-icon","textColor":"primary-600","gradient":"primary-lighter","iconSet":"heroicons","iconName":"presentation-chart-bar","iconSize":"","iconSvgString":"\u003csvg xmlns=\u0022http://www.w3.org/2000/svg\u0022 fill=\u0022none\u0022 stroke=\u0022currentColor\u0022 stroke-width=\u00221.5\u0022 aria-hidden=\u0022true\u0022 viewBox=\u00220 0 24 24\u0022\u003e\u003cpath stroke-linecap=\u0022round\u0022 stroke-linejoin=\u0022round\u0022 d=\u0022M3.75 3v11.25A2.25 2.25 0 0 0 6 16.5h2.25M3.75 3h-1.5m1.5 0h16.5m0 0h1.5m-1.5 0v11.25A2.25 2.25 0 0 1 18 16.5h-2.25m-7.5 0h7.5m-7.5 0-1 3m8.5-3 1 3m0 0 .5 1.5m-.5-1.5h-9.5m0 0-.5 1.5M9 11.25v1.5M12 9v3.75m3-6v6\u0022/\u003e\u003c/svg\u003e"} -->
<figure class="wp-block-image has-custom-border is-style-icon has-primary-600-color has-primary-lighter-gradient-background has-text-color has-background" style="border-radius:99px;padding-top:var(--wp--preset--spacing--xxs);padding-right:var(--wp--preset--spacing--xxs);padding-bottom:var(--wp--preset--spacing--xxs);padding-left:var(--wp--preset--spacing--xxs);--wp--custom--icon--color:var(--wp--preset--color--primary-600,currentColor);--wp--custom--icon--background:var(--wp--preset--gradient--primary-lighter,currentColor);--wp--custom--icon--padding:var(--wp--preset--spacing--xxs) var(--wp--preset--spacing--xxs) var(--wp--preset--spacing--xxs) var(--wp--preset--spacing--xxs);--wp--custom--icon--url:url('data:image/svg+xml;utf8,<svg xmlns=&quot;http://www.w3.org/2000/svg&quot; fill=&quot;none&quot; stroke=&quot;currentColor&quot; stroke-width=&quot;1.5&quot; aria-hidden=&quot;true&quot; viewBox=&quot;0 0 24 24&quot;&gt;<path stroke-linecap=&quot;round&quot; stroke-linejoin=&quot;round&quot; d=&quot;M3.75 3v11.25A2.25 2.25 0 0 0 6 16.5h2.25M3.75 3h-1.5m1.5 0h16.5m0 0h1.5m-1.5 0v11.25A2.25 2.25 0 0 1 18 16.5h-2.25m-7.5 0h7.5m-7.5 0-1 3m8.5-3 1 3m0 0 .5 1.5m-.5-1.5h-9.5m0 0-.5 1.5M9 11.25v1.5M12 9v3.75m3-6v6&quot;/&gt;</svg&gt;')"><img src="#" alt="" style="border-radius:99px"/></figure>
<!-- /wp:image -->
<!-- wp:paragraph {"style":{"counter":{"start":"0","end":"100","duration":"2","delay":"0","suffix":"m"},"color":{"text":"#1a1533"},"spacing":{"padding":{"top":"var:preset|spacing|xxs"}}},"className":"is-style-counter is-style-heading","fontSize":"24"} -->
<p class="is-style-counter is-style-heading has-text-color has-24-font-size" style="color:#1a1533;padding-top:var(--wp--preset--spacing--xxs)">100m</p>
<!-- /wp:paragraph -->
<!-- wp:paragraph -->
<p>Profit generated</p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:column --></div>
<!-- /wp:columns -->
<!-- wp:spacer {"height":"600px","style":{"width":{"all":"600px"},"position":{"all":"absolute"},"bottom":{"all":"-150px"},"left":{"all":"-300px"},"zIndex":{"all":"-1"},"spacing":{"margin":{"top":"0","right":"0","bottom":"0","left":"0"}}},"gradient":"circle"} -->
<div style="margin-top:0;margin-right:0;margin-bottom:0;margin-left:0;height:600px" aria-hidden="true" class="wp-block-spacer has-circle-gradient-background has-background"></div>
<!-- /wp:spacer --></div>
<!-- /wp:group -->