<?php 
/**
 * Compares the version of WordPress running to the $version specified.
 *
 * @uses get_bloginfo() Retrieve info about WP.
 * @uses switch_theme() Revert back to last theme if false.
 * @return boolean
 * @since 1.7.1
 */
function larryslist_test_min_version() 
{
    if(version_compare(get_bloginfo('version'),'4.5', '<') ) {
	    
		add_action( 'admin_notices', 'wport_min_version_not_met_notice' );
        // Switches back to the previous theme if the minimum WP version is not met.
        switch_theme( get_option( 'theme_switched' ) );
        unset( $_GET['activated'] );
		return false;
	}
}
// An error notice to displayed if the Minimum WP version is not met.
function larryslist_min_version_not_met_notice() 
{
	
	$class = 'notice notice-error';
    $message = __( 'It is recommended that you update WordPress to 4.5 or higher in order to use this theme.', 
                    'larryslist' );
 
    printf( '<div class="%1$s"><p>%2$s</p></div>', 
                esc_attr( $class ), esc_html( $message ) ); 
}
