<?php
/**
 *
 * Theme Options for larryslist
 * @package larryslist
 * @subpackage larryslist-theme-customize.php
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) { exit; } 
/**
     * customizer assets - LarrysList
	 * 1) Color for Widget Links, Content Links and Alternate Title
	 * Uses a color wheel to configure the links Color setting.
	 * https://developer.wordpress.org/reference/classes/wp_customize_manager/add_setting/
     *
     * 2) Confirm to Remove Footer copytext [deprecated]
     * 3) Remove Credits and Add New text.
     * 4) Social Media Links
     * 7) New Title for listings page
     * 5) Set number of listings on View page
     * 6) Set length of excerpts for listings
*/
add_action( 'customize_register', 'larryslist_register_theme_customizer' );
function larryslist_register_theme_customizer($wp_customize)
{

    $wp_customize->add_section('larryslist_options_page_section', array(
        'title'             => __( 'LarrysList Theme Options', 'larryslist' ),
        'priority'          => 45
    ));
    
    // 7) larryslist_newtitle 
	$wp_customize->add_setting(	
        'larryslist_newtitle_setting', array(
            'type'              => 'theme_mod',
            'default'           => 'Listings',
            'sanitize_callback'	=> 'sanitize_text_field'
        )
    );
        
    $wp_customize->add_control(
        'larryslist_newtitle', array(
            'settings'    => 'larryslist_newtitle_setting',
            'type'        => 'text',
            'section'     => 'larryslist_options_page_section',
            'label'       => __( 'Title of listings on View page', 'larryslist' ),
            'description' => __( 'To make listings viewable create a page using the template
                                 &#39;View Listings&#39; then add that page to your menu or make it the Static home page.', 
                                 'larryslist' ),
        )
    );
    /* (1)
     * WP_Customize_ /add_setting for links color
    */
	$wp_customize->add_setting(	
        // $id
        'larryslist_links_setting', array(
        // $args
            'type'              => 'theme_mod',
            'default'           => '#0000ee',
            'sanitize_callback'	=> 'sanitize_hex_color',
            'transport'			=> 'refresh'
        )
    ); 
    // (1) Control for color
    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'larryslist_links', array(
                'settings'	  => 'larryslist_links_setting',
                'section'	  => 'colors',
                'priority'    => 1,
                'label'		  => __( 'Link Colors', 'larryslist' ),
                'description' => __( 'Color for Widget Links, Content Links and Alternate Title', 'larryslist' ),
            )
        )
    );
    // 3) Remove Credits and Add New text.
    $wp_customize->add_setting(	
    'larryslist_new_text_setting', array(
        'type'              => 'theme_mod',
        'default'           => '',
        'sanitize_callback'	=> 'sanitize_text_field'
        )
    );
    // (3) new text in footer
    $wp_customize->add_control(
        'larryslist_new_text', 
        array(
            'settings'    => 'larryslist_new_text_setting',
            'type'        => 'text',
            'section'     => 'larryslist_options_page_section',
            'label'       => __( 'Replace Footer Credit', 'larryslist' ),
            'description' => __( 'Adding new text overwrites credits.', 'larryslist' ),
        )
    );
    // 4) Social Media Links
    // facecrook
    $wp_customize->add_setting(	
        'larryslist_facebook_setting', array(
            'type'              => 'theme_mod',
            'default'           => '',
            'sanitize_callback'	=> 'sanitize_text_field'
        )
    ); 
    // twitter
    $wp_customize->add_setting(	
        'larryslist_twitter_setting', array(
            'type'              => 'theme_mod',
            'default'           => '',
            'sanitize_callback'	=> 'sanitize_text_field'
        )
    ); 
    // email
    $wp_customize->add_setting(	
        'larryslist_email_setting', array(
            'type'              => 'theme_mod',
            'default'           => '',
            'sanitize_callback'	=> 'sanitize_text_field'
        )
    );
    // google replaced by phone number 
	$wp_customize->add_setting(	
        'larryslist_googleurl_setting', array(
            'type'              => 'theme_mod',
            'default'           => '',
            'sanitize_callback'	=> 'sanitize_text_field'
        )
    );
    // Controls for social links
    // (4) facebook url
    $wp_customize->add_control(
        'larryslist_facebook', 
        array(
            'settings'    => 'larryslist_facebook_setting',
            'type'        => 'text',
            'section'     => 'larryslist_options_page_section',
            'label'       => __( 'Add your social media links here', 'larryslist' ),
            'description' => __( 'facebook', 'larryslist' ),
        )
    );
    // (4)
    $wp_customize->add_control(
        'larryslist_twitter', array(
            'settings'    => 'larryslist_twitter_setting',
            'type'        => 'text',
            'section'     => 'larryslist_options_page_section',
            'label'       => '',
            'description' => __( 'twitter', 'larryslist' ),
        )
    );
    // (4)
    $wp_customize->add_control(
        'larryslist_email', array(
            'settings'    => 'larryslist_email_setting',
            'type'        => 'email',
            'section'     => 'larryslist_options_page_section',
            'label'       => '',
            'description' => __( 'email', 'larryslist' ),
        )
    );
    // (4)
    $wp_customize->add_control(
        'larryslist_googleurl', array(
            'settings'    => 'larryslist_googleurl_setting',
            'type'        => 'text',
            'section'     => 'larryslist_options_page_section',
            'label'       => '',
            'description' => __( 'phone maybe (google deprecated)', 'larryslist' ),
        )
    );
    // 5) Set number of listings on View page
    $wp_customize->add_setting(	
        'larryslist_cppp_setting', array(
            'type'              => 'theme_mod',
            'default'           => '20',
            'sanitize_callback'	=> 'sanitize_text_field'
        )
    ); 
    
    $wp_customize->add_control(
        'larryslist_cppp', array(
            'settings'    => 'larryslist_cppp_setting',
            'type'        => 'number',
            'section'     => 'larryslist_options_page_section',
            'input_attrs' => array(
                'min'   => 0,
                'max'   => 1000,
                'step'  => 1,
            ),
            'label'       => __( 'Set number of listings on View page', 'larryslist' ),
            'description' => __( 'Number of listings to display on the View page.', 'larryslist' ),
        )
    );
    // 6) Set length of excerpts for listings - moved to functions file
    $wp_customize->add_setting(	
        'larryslist_excerpt_size_setting', array(
            'type'              => 'theme_mod',
            'default'           => '55',
            'sanitize_callback'	=> 'absint'
        )
    ); 
    
    $wp_customize->add_control(
        'larryslist_excerpt_size', array(
            'settings'    => 'larryslist_excerpt_size_setting',
            'type'        => 'number',
            'section'     => 'larryslist_options_page_section',
            'input_attrs' => array(
                'min'   => 0,
                'max'   => 9999,
                'step'  => 1,
            ),
            'label'       => __( 'Set length of excerpts for listings', 'larryslist' ),
            'description' => __( 'Number of words in  excerpt displayed on page.', 'larryslist' ),
        )
    ); 
}

/*
 now put the color option to work as inline styles
 'larryslist_links' => '#0000ee',
 */
add_action( 'wp_head', 'larryslist_customize_css');
function larryslist_customize_css() 
{

    if ( get_theme_mods() ) 
    { 
        echo '<style id="larryslist-customizer" type="text/css">';
        if ( get_theme_mod('larryslist_links_setting') ) :
        $larryslist_links = get_theme_mod( 'larryslist_links_setting', '#0000ee');
        echo '.entry a, .entry-title a, .widget-container a, .default-widget a, #listings-view .listing a, #listings-view .listing a:visited, .othersby a, .alt-title{color:'. esc_attr($larryslist_links) .'}';
        endif; 
        echo '</style>';
    }
}
/**
 * 'larryslist_email' 'larryslist_facebookurl' 'larryslist_twitterurl' 'larryslist_googleurl' 
 * 
 */
add_action( 'larryslist_social_blocks', 'larryslist_render_social_blocks' );
function larryslist_render_social_blocks()
{
    // Get each option if it is not empty
    $output ='';
    if ( get_theme_mods() ) 
    : 
        $output .= '<ul id="social-links">';
        
        if ( get_theme_mod( 'larryslist_facebook_setting' ) )
        {
            $output .='<li><i><img src="'. esc_url( get_template_directory_uri() 
            . '/include/images/facebook.png' ) .'" /> </i><span>'. esc_html__( 'Facebook', 'larryslist' ) .': </span><em>'
            . esc_url( get_theme_mod( 'larryslist_facebook_setting' ) ) .'</em></li>';
        }

        if ( get_theme_mod( 'larryslist_twitter_setting' ) )
        {
            $output .='<li><i><img src="'. esc_url( get_template_directory_uri() 
            . '/include/images/twitter.png' ) .'" /> </i><span>'. esc_html__( 'Twitter', 'larryslist' ) .': </span><em>'
            . esc_url( get_theme_mod( 'larryslist_twitter_setting' ) ) .'</em></li>';
        }
        
        if ( get_theme_mod( 'larryslist_email_setting' ) )
        {
            $output .='<li><i><img src="'. esc_url( get_template_directory_uri() 
            . '/include/images/mail.png' ) .'" /> </i><span>'. esc_html__( 'EMail', 'larryslist' ) .': </span><em>'
            . esc_attr( get_theme_mod( 'larryslist_email_setting' ) ) .'</em></li>';
        }
        
        if ( get_theme_mod( 'larryslist_googleurl_setting' ) )
        {
            $output .='<li><i><img src="'. esc_url( get_template_directory_uri() 
            . '/include/images/phone.png' ) .'" /> </i><span>'. esc_html__( 'Info', 'larryslist' ) .': </span><em>'
            . esc_attr( get_theme_mod( 'larryslist_googleurl_setting' ) ) .'</em></li>';
        }
        $output .= '</ul>';

    endif;
    echo $output;
} 
