<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

add_action( 'after_setup_theme', 'lalita_background_setup' );
function lalita_background_setup() {
	add_theme_support( "custom-background",
		array(
			'default-color' 		 => 'ffffff',
			'default-image'          => '',
			'default-repeat'         => 'repeat',
			'default-position-x'     => 'left',
			'default-position-y'     => 'top',
			'default-size'           => 'auto',
			'default-attachment'     => '',
			'wp-head-callback'       => '_custom_background_cb',
			'admin-head-callback'    => '',
			'admin-preview-callback' => ''
		)
	);
}

if ( ! function_exists( 'lalita_get_defaults' ) ) {
	function lalita_get_defaults() {
		$lalita_defaults = array(
			'hide_title' => '',
			'hide_tagline' => true,
			'top_bar_width' => 'full',
			'top_bar_inner_width' => 'full',
			'top_bar_alignment' => 'left',
			'container_width' => '2000',
			'header_layout_setting' => 'fluid-header',
			'header_inner_width' => 'full-width',
			'nav_alignment_setting' => 'right',
			'header_alignment_setting' => 'left',
			'nav_layout_setting' => 'fluid-nav',
			'nav_inner_width' => 'full-width',
			'nav_position_setting' => 'nav-float-right',
			'nav_dropdown_type' => 'hover',
			'nav_search' => 'enable',
			'nav_effect' => 'none',
			'content_layout_setting' => 'one-container',
			'layout_setting' => 'no-sidebar',
			'blog_layout_setting' => 'right-sidebar',
			'single_layout_setting' => 'right-sidebar',
			'fixed_side_content' => '',
			'blog_header_image' => '',
			'blog_header_title' => '',
			'blog_header_text' => '',
			'blog_header_button_text' => '',
			'blog_header_button_url' => '',
			'post_content' => 'excerpt',
			'footer_layout_setting' => 'fluid-footer',
			'footer_widgets_inner_width' => 'full-width',
			'footer_inner_width' => 'full-width',
			'footer_widget_setting' => '3',
			'footer_bar_alignment' => 'right',
			'back_to_top' => 'enable',
			'socials_display_side' => false,
			'socials_display_top' => false,
			'socials_facebook_url' => '',
			'socials_twitter_url' => '',
			'socials_google_url' => '',
			'socials_tumblr_url' => '',
			'socials_pinterest_url' => '',
			'socials_youtube_url' => '',
			'socials_linkedin_url' => '',
			'socials_custom_icon_1' => '',
			'socials_custom_icon_2' => '',
			'socials_custom_icon_3' => '',
			'socials_custom_icon_url_1' => '',
			'socials_custom_icon_url_2' => '',
			'socials_custom_icon_url_3' => '',
			'socials_mail_url' => '',
			'button_rotate' => '0',
			'button_border' => '0',
			'button_frame' => 'none',
			'button_radius' => 'none',
			'side_inside_color' => '',
			'text_color' => '#000000',
			'link_color' => '#ff0005',
			'link_color_hover' => '#000000',
			'link_color_visited' => '',
			'font_awesome_essentials' => true,
		);
	
		return apply_filters( 'lalita_option_defaults', $lalita_defaults );
	}
}

if ( ! function_exists( 'lalita_child_functions_defaults' ) ) {
	add_filter( 'lalita_option_defaults', 'lalita_child_functions_defaults', 10, 3 );
	function lalita_child_functions_defaults( $lalita_defaults ) {
		
		$lalita_defaults['nav_btn_url']	 	= '';
		$lalita_defaults['nav_btn_text']	= '';
		$lalita_defaults['cursor_style']	= 'default';
		$lalita_defaults['def_ci']			= '';
		$lalita_defaults['pointer_ci']		= '';
		$lalita_defaults['mm_color_1']		= '';
		$lalita_defaults['mm_color_2']		= '';
		$lalita_defaults['splitnav_effect']	= 'disable';
		$lalita_defaults['nicescroll']		= 'disable';
		$lalita_defaults['nicescroll_c1']	= '';
		$lalita_defaults['nicescroll_c2']	= '';
		$lalita_defaults['nicescroll_c3']	= '';
		$lalita_defaults['extracolor_1']	= '#ff0005';
		$lalita_defaults['extracolor_2']	= '#ffffff';
		$lalita_defaults['extracolor_3']	= '';
		$lalita_defaults['extracolor_4']	= '';
		$lalita_defaults['extracolor_5']	= '';
		$lalita_defaults['top_bar_scroll']	= 'disable';
		
		return $lalita_defaults;
	}
}

if ( ! function_exists( 'lalita_get_color_defaults' ) ) {
	function lalita_get_color_defaults() {
		$lalita_color_defaults = array(
			'top_bar_background_color' => '#ffffff',
			'top_bar_text_color' => '#000000',
			'top_bar_link_color' => '#ff0005',
			'top_bar_link_color_hover' => '#000000',
			'header_background_color' => '#ffffff',
			'header_text_color' => '#000000',
			'header_link_color' => '#000000',
			'header_link_hover_color' => '#000000',
			'site_title_color' => '#ff0005',
			'site_tagline_color' => '#000000',
			'navigation_background_color' => '#ffffff',
			'navigation_text_color' => '#000000',
			'navigation_background_hover_color' => '',
			'navigation_text_hover_color' => '#ff0005',
			'navigation_background_current_color' => '',
			'navigation_text_current_color' => '',
			'subnavigation_background_color' => '#ffffff',
			'subnavigation_text_color' => '#000000',
			'subnavigation_background_hover_color' => '',
			'subnavigation_text_hover_color' => '#ff0005',
			'subnavigation_background_current_color' => '',
			'subnavigation_text_current_color' => '',
			'fixed_side_content_background_color' => '#ff0005',
			'fixed_side_content_text_color' => '#ffffff',
			'fixed_side_content_link_color' => '#ffffff',
			'fixed_side_content_link_hover_color' => '#000000',
			'content_background_color' => '',
			'content_text_color' => '',
			'content_link_color' => '',
			'content_link_hover_color' => '',
			'content_title_color' => '',
			'blog_header_bg_color' => '#000000',
			'blog_header_bg_s_color' => '#000000',
			'blog_header_title_color' => '#ffffff',
			'blog_header_text_color' => '#ffffff',
			'blog_header_button' => '#ffffff',
			'blog_header_button_bg' => '#ff0005',
			'blog_header_button_hover' => '#ffffff',
			'blog_header_button_hover_bg' => '#000000',
			'blog_post_title_color' => '',
			'blog_post_title_hover_color' => '',
			'entry_meta_text_color' => '',
			'entry_meta_link_color' => '',
			'entry_meta_link_color_hover' => '',
			'h1_color' => '',
			'h2_color' => '',
			'h3_color' => '',
			'h4_color' => '',
			'h5_color' => '',
			'h6_color' => '',
			'sidebar_widget_background_color' => '#ff0005',
			'sidebar_widget_text_color' => '#000000',
			'sidebar_widget_link_color' => '#ffffff',
			'sidebar_widget_link_hover_color' => '#000000',
			'sidebar_widget_title_color' => '#ffffff',
			'footer_widget_background_color' => '#ffffff',
			'footer_widget_text_color' => '#000000',
			'footer_widget_link_color' => '#ff0005',
			'footer_widget_link_hover_color' => '#000000',
			'footer_widget_title_color' => '#000000',
			'footer_background_color' => '#ff0005',
			'footer_text_color' => '#ffffff',
			'footer_link_color' => '#ffffff',
			'footer_link_hover_color' => '#000000',
			'form_background_color' => '#ffffff',
			'form_text_color' => '#000000',
			'form_background_color_focus' => '#ff0005',
			'form_text_color_focus' => '#ffffff',
			'form_border_color' => '#000000',
			'form_border_color_focus' => '#000000',
			'form_button_background_color' => '#ff0005',
			'form_button_background_color_hover' => '#000000',
			'form_button_text_color' => '#ffffff',
			'form_button_text_color_hover' => '#ffffff',
			'back_to_top_background_color' => '#ff0005',
			'back_to_top_background_color_hover' => '#000000',
			'back_to_top_text_color' => '#ffffff',
			'back_to_top_text_color_hover' => '#ffffff',
		);
	
		return apply_filters( 'lalita_color_option_defaults', $lalita_color_defaults );
	}
}

if ( ! function_exists( 'lalita_get_default_fonts' ) ) {
	function lalita_get_default_fonts( $filter = true ) {
		$lalita_font_defaults = array(
			'font_body' => 'Dosis',
			'font_body_category' => '',
			'font_body_variants' => '200,500,600,700,800',
			'body_font_weight' => '600',
			'body_font_transform' => 'none',
			'body_font_size' => '22',
			'body_line_height' => '1.3', // no unit
			'paragraph_margin' => '1.3', // em
			'font_top_bar' => 'Dosis',
			'font_top_bar_category' => '',
			'font_top_bar_variants' => '200,500,600,700,800',
			'top_bar_font_weight' => '600',
			'top_bar_font_transform' => 'none',
			'top_bar_font_size' => '17',
			'font_site_title' => 'Dosis',
			'font_site_title_category' => '',
			'font_site_title_variants' => '200,500,600,700,800',
			'site_title_font_weight' => '800',
			'site_title_font_transform' => 'uppercase',
			'site_title_font_size' => '40',
			'mobile_site_title_font_size' => '25',
			'font_site_tagline' => 'inherit',
			'font_site_tagline_category' => '',
			'font_site_tagline_variants' => '',
			'site_tagline_font_weight' => 'normal',
			'site_tagline_font_transform' => 'none',
			'site_tagline_font_size' => '19',
			'font_blog_header_title' => 'Dosis',
			'font_blog_header_title_category' => '',
			'font_blog_header_title_variants' => '200,500,600,700,800',
			'blog_header_title_font_weight' => '800',
			'blog_header_title_font_transform' => 'none',
			'font_blog_header_text' => 'Dosis',
			'font_blog_header_text_category' => '',
			'font_blog_header_text_variants' => '200,500,600,700,800',
			'blog_header_text_font_weight' => '600',
			'blog_header_text_font_transform' => 'none',
			'font_navigation' => 'Dosis',
			'font_navigation_category' => '',
			'font_navigation_variants' => '200,500,600,700,800',
			'navigation_font_weight' => '800',
			'navigation_font_transform' => 'uppercase',
			'navigation_font_size' => '24',
			'font_widget_title' => 'Dosis',
			'font_widget_title_category' => '',
			'font_widget_title_variants' => '200,500,600,700,800',
			'widget_title_font_weight' => '800',
			'widget_title_font_transform' => 'none',
			'widget_title_font_size' => '30',
			'widget_title_separator' => '18',
			'widget_content_font_size' => '18',
			'font_buttons' => 'Dosis',
			'font_buttons_category' => '',
			'font_buttons_variants' => '200,500,600,700,800',
			'buttons_font_weight' => '800',
			'buttons_font_transform' => 'uppercase',
			'buttons_font_size' => '22',
			'font_heading_1' => 'inherit',
			'font_heading_1_category' => '',
			'font_heading_1_variants' => '',
			'heading_1_weight' => '600',
			'heading_1_transform' => 'none',
			'heading_1_font_size' => '60',
			'heading_1_line_height' => '1.2', // em
			'mobile_heading_1_font_size' => '30',
			'font_heading_2' => 'inherit',
			'font_heading_2_category' => '',
			'font_heading_2_variants' => '',
			'heading_2_weight' => '600',
			'heading_2_transform' => 'none',
			'heading_2_font_size' => '32',
			'heading_2_line_height' => '1.2', // em
			'mobile_heading_2_font_size' => '25',
			'font_heading_3' => 'inherit',
			'font_heading_3_category' => '',
			'font_heading_3_variants' => '',
			'heading_3_weight' => '600',
			'heading_3_transform' => 'none',
			'heading_3_font_size' => '25',
			'heading_3_line_height' => '1.2', // em
			'font_heading_4' => 'inherit',
			'font_heading_4_category' => '',
			'font_heading_4_variants' => '',
			'heading_4_weight' => 'normal',
			'heading_4_transform' => 'none',
			'heading_4_font_size' => '',
			'heading_4_line_height' => '', // em
			'font_heading_5' => 'inherit',
			'font_heading_5_category' => '',
			'font_heading_5_variants' => '',
			'heading_5_weight' => 'normal',
			'heading_5_transform' => 'none',
			'heading_5_font_size' => '',
			'heading_5_line_height' => '', // em
			'font_heading_6' => 'inherit',
			'font_heading_6_category' => '',
			'font_heading_6_variants' => '',
			'heading_6_weight' => 'normal',
			'heading_6_transform' => 'none',
			'heading_6_font_size' => '',
			'heading_6_line_height' => '', // em
			'font_footer' => 'Dosis',
			'font_footer_category' => '',
			'font_footer_variants' => '200,500,600,700,800',
			'footer_weight' => '600',
			'footer_transform' => 'none',
			'footer_font_size' => '20',
			'font_fixed_side' => 'Dosis',
			'font_fixed_side_category' => '',
			'font_fixed_side_variants' => '200,500,600,700,800',
			'fixed_side_font_weight' => '700',
			'fixed_side_font_transform' => 'uppercase',
			'fixed_side_font_size' => '25',
		);
	
		if ( $filter ) {
			return apply_filters( 'lalita_font_option_defaults', $lalita_font_defaults );
		}
	
		return $lalita_font_defaults;
	}
}

if ( ! function_exists( 'lalita_spacing_get_defaults' ) ) {
	function lalita_spacing_get_defaults( $filter = true ) {
		$lalita_spacing_defaults = array(
			'top_bar_top' => '5',
			'top_bar_right' => '40',
			'top_bar_bottom' => '5',
			'top_bar_left' => '40',
			'header_top' => '8',
			'header_right' => '40',
			'header_bottom' => '8',
			'header_left' => '40',
			'fixed_side_margin_top' => '200',
			'fixed_side_margin_right'=> '0',
			'fixed_side_margin_bottom' => '0',
			'fixed_side_margin_left' => '0',
			'fixed_side_top' => '15',
			'fixed_side_right' => '8',
			'fixed_side_bottom' => '15',
			'fixed_side_left' => '8',
			'button_top' => '12',
			'button_right' => '25',
			'button_bottom' => '12',
			'button_left' => '25',
			'menu_item' => '10',
			'menu_item_height' => '50',
			'sub_menu_item_height' => '10',
			'content_top' => '40',
			'content_right' => '40',
			'content_bottom' => '30',
			'content_left' => '40',
			'mobile_content_top' => '15',
			'mobile_content_right' => '15',
			'mobile_content_bottom' => '15',
			'mobile_content_left' => '15',
			'side_top' => '0',
			'side_right' => '0',
			'side_bottom' => '0',
			'side_left' => '0',
			'mobile_side_top' => '0',
			'mobile_side_right' => '0',
			'mobile_side_bottom' => '0',
			'mobile_side_left' => '0',
			'separator' => '15',
			'left_sidebar_width' => '25',
			'right_sidebar_width' => '25',
			'widget_top' => '20',
			'widget_right' => '20',
			'widget_bottom' => '20',
			'widget_left' => '20',
			'footer_widget_container_top' => '0',
			'footer_widget_container_right' => '40',
			'footer_widget_container_bottom' => '0',
			'footer_widget_container_left' => '40',
			'footer_widget_separator' => '30',
			'footer_top' => '10',
			'footer_right' => '55',
			'footer_bottom' => '35',
			'footer_left' => '40',
		);
	
		if ( $filter ) {
			return apply_filters( 'lalita_spacing_option_defaults', $lalita_spacing_defaults );
		}
	
		return $lalita_spacing_defaults;
	}
}

if ( ! function_exists( 'lalita_get_default_color_palettes' ) ) {
	function lalita_get_default_color_palettes() {
		$palettes = array(
			'#000000',
			'#ff0005',
			'#cccccc',
			'#dddddd',
			'#eeeeee',
			'#ffffff'
		);
	
		return apply_filters( 'lalita_default_color_palettes', $palettes );
	}
}

if ( ! function_exists( 'lalita_typography_default_fonts' ) ) {
	function lalita_typography_default_fonts() {
		$fonts = array(
			'inherit',
			'System Stack',
			'Arial, Helvetica, sans-serif',
			'Courier New',
			'Georgia, Times New Roman, Times, serif',
			'Trebuchet MS, Helvetica, sans-serif',
			'Verdana, Geneva, sans-serif',
			'Dosis'
		);
	
		return apply_filters( 'lalita_typography_default_fonts', $fonts );
	}
}

define( 'LALITA_DEFAULT_FONTS' , '//fonts.googleapis.com/css?family=Dosis:200,500,600,700,800' );

add_action( 'lalita_after_header', 'lalita_blog_header_image', 11 );
function lalita_blog_header_image() {

	if ( ( is_front_page() && is_home() ) || ( is_home() ) ) { 
		$blog_header_image 			=  lalita_get_setting( 'blog_header_image' ); 
		$blog_header_title 			=  lalita_get_setting( 'blog_header_title' ); 
		$blog_header_text 			=  lalita_get_setting( 'blog_header_text' ); 
		$blog_header_button_text 	=  lalita_get_setting( 'blog_header_button_text' ); 
		$blog_header_button_url 	=  lalita_get_setting( 'blog_header_button_url' ); 
		if ( $blog_header_image != '' ) { ?>
		<div class="page-header-image grid-parent page-header-blog" style="background-image: url('<?php echo esc_url($blog_header_image); ?>') !important;">
        	<div class="page-header-noiseoverlay"></div>
        	<div class="page-header-blog-inner">
                <div class="page-header-blog-content-h grid-container">
                    <div class="page-header-blog-content">
                    <?php if ( $blog_header_title != '' ) { ?>
                        <div class="page-header-blog-text">
                            <?php if ( $blog_header_title != '' ) { ?>
                            <h2><?php echo wp_kses_post( $blog_header_title ); ?></h2>
                            <div class="clearfix"></div>
                            <?php } ?>
                        </div>
                    <?php } ?>
                    </div>
                </div>
                <div class="page-header-blog-content page-header-blog-content-b">
                	<?php if ( $blog_header_text != '' ) { ?>
                	<div class="page-header-blog-text">
						<?php if ( $blog_header_title != '' ) { ?>
                        <p><?php echo wp_kses_post( $blog_header_text ); ?></p>
                        <div class="clearfix"></div>
                        <?php } ?>
                    </div>
                    <?php } ?>
                    <div class="page-header-blog-button">
                        <?php if ( $blog_header_button_text != '' ) { ?>
                        <a class="read-more button" href="<?php echo esc_url( $blog_header_button_url ); ?>"><?php echo esc_html( $blog_header_button_text ); ?></a>
                        <?php } ?>
                    </div>
                </div>
            </div>
		</div>
		<?php
		}
	}
}

if ( ! function_exists( 'lalita_marga_frame_html' ) ) {
	add_action( 'lalita_before_header', 'lalita_marga_frame_html' );
	/**
	 * HTML for the color frame
	 */
	function lalita_marga_frame_html() {
		$lalita_settings = get_option( 'lalita_settings' );
		
		if ( isset( $lalita_settings['marga_textframe_content'] ) && ( $lalita_settings['marga_textframe_content'] != '' ) ) {
	?>
    <div class="marga-frame marga-frame-top"><?php echo wp_kses_post( $lalita_settings['marga_textframe_content'] ); ?></div>
    <div class="marga-frame marga-frame-right"></div>
    <div class="marga-frame marga-frame-left"></div>
    <div class="marga-frame marga-frame-bottom"><?php echo wp_kses_post( $lalita_settings['marga_textframe_content'] ); ?></div>
    <?php
		}
	}
}