<?php
/**
 * Builds additional Customizer controls.
 *
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( ! function_exists( 'lalita_is_extra_colors_active' ) ) {
	function lalita_is_extra_colors_active() {
		
		$extracolors = false;
		$lalita_theme_defaults = get_option( 'lalita_theme_defaults', 'lalita' );
		
		
		if ( ( 'daiva' == $lalita_theme_defaults ) || ( 'ekata' == $lalita_theme_defaults ) || ( 'ganapati' == $lalita_theme_defaults ) || ( 'gotra' == $lalita_theme_defaults ) || ( 'ishta' == $lalita_theme_defaults ) || ( 'itara' == $lalita_theme_defaults ) || ( 'jagat' == $lalita_theme_defaults ) || ( 'mahatma' == $lalita_theme_defaults ) || ( 'makara' == $lalita_theme_defaults ) || ( 'marga' == $lalita_theme_defaults ) || ( 'parama' == $lalita_theme_defaults ) || ( 'prakasa' == $lalita_theme_defaults ) || ( 'sakti' == $lalita_theme_defaults ) || ( 'samana' == $lalita_theme_defaults ) || ( 'sundara' == $lalita_theme_defaults ) ) {
			$extracolors = true;
		}
		return $extracolors;
	}
}

if ( ! function_exists( 'lalita_marga_textframe_active' ) ) {
	function lalita_marga_textframe_active() {
		
		$textframe = false;
		$lalita_theme_defaults = get_option( 'lalita_theme_defaults', 'lalita' );
		
		
		if ( 'marga' == $lalita_theme_defaults ) {
			$textframe = true;
		}
		return $textframe;
	}
}

if ( ! function_exists( 'lalita_is_magic_cursor_active' ) ) {
	function lalita_is_magic_cursor_active() {
		
		$magiccursor = false;
		$lalita_settings = wp_parse_args(
			get_option( 'lalita_settings', array() ),
			lalita_get_defaults()
		);
		
		if ( 'magic' == $lalita_settings['cursor_style'] ) {
			$magiccursor = true;
		}
		return $magiccursor;
	}
}

if ( ! function_exists( 'lalita_is_cursor_image_active' ) ) {
	function lalita_is_cursor_image_active() {
		
		$cursor_style = false;
		$lalita_settings = wp_parse_args(
			get_option( 'lalita_settings', array() ),
			lalita_get_defaults()
		);
		
		if ( 'image' == $lalita_settings['cursor_style'] ) {
			$cursor_style = true;
		}
		return $cursor_style;
	}
}

if ( ! function_exists( 'lalita_is_nicescroll_active' ) ) {
	function lalita_is_nicescroll_active() {
		
		$nicescroll = false;
		$lalita_settings = wp_parse_args(
			get_option( 'lalita_settings', array() ),
			lalita_get_defaults()
		);
		
		if ( 'enable' == $lalita_settings['nicescroll'] ) {
			$nicescroll = true;
		}
		return $nicescroll;
	}
}

if ( ! function_exists( 'lalita_additional_customize_register' ) ) {
	add_action( 'customize_register', 'lalita_additional_customize_register' );
	/**
	 * Add our base options to the Customizer.
	 *
	 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
	 */
	function lalita_additional_customize_register( $wp_customize ) {
		// Get our default values
		$defaults = lalita_get_defaults();
		
		if ( method_exists( $wp_customize, 'register_control_type' ) ) {
			$wp_customize->register_control_type( 'Lalita_Theme_Style_control' );
		}
		
		$wp_customize->add_section(
			'lalita_theme_style_section',
			array(
				'title' => __( 'Theme Style', 'lalita' ),
				'priority' => 1
			)
		);
		
		$wp_customize->add_control(
			new Lalita_Theme_Style_control(
				$wp_customize,
				'nav_menus_how_to_use_desc',
				array(
					'section' => 'lalita_theme_style_section',
					'type' => 'themestylehelp',
					'label' => __( 'Change Theme Style', 'lalita' ),
					'description' => __( 'Lalita includes 51 built-in design styles. Change Your theme style at Appearance-> Lalita admin menu easily.', 'lalita' ),
					'url' => esc_url( admin_url( 'themes.php?page=lalita-options' ) ),
					'priority' => 10,
					'settings' => ( isset( $wp_customize->selective_refresh ) ) ? array() : 'blogname'
				)
			)
		);
		
		// Add navigation extra button text
		$wp_customize->add_setting(
			'lalita_settings[nav_btn_text]',
			array(
				'default' => $defaults['nav_btn_text'],
				'type' => 'option',
				'sanitize_callback' => 'esc_html'
			)
		);

		$wp_customize->add_control(
			'lalita_settings[nav_btn_text]',
			array(
				'type' => 'text',
				'label' => __( 'Extra button text', 'lalita' ),
				'section' => 'lalita_layout_navigation',
				'settings' => 'lalita_settings[nav_btn_text]',
				'priority' => 25
			)
		);
		
		// Add navigation extra button url
		$wp_customize->add_setting(
			'lalita_settings[nav_btn_url]',
			array(
				'default' => $defaults['nav_btn_url'],
				'type' => 'option',
				'sanitize_callback' => 'esc_url'
			)
		);

		$wp_customize->add_control(
			'lalita_settings[nav_btn_url]',
			array(
				'type' => 'text',
				'label' => __( 'Extra button URL', 'lalita' ),
				'section' => 'lalita_layout_navigation',
				'settings' => 'lalita_settings[nav_btn_url]',
				'priority' => 25
			)
		);
		
		// Cursor style
		$wp_customize->add_setting(
			'lalita_settings[cursor_style]',
			array(
				'default' => $defaults['cursor_style'],
				'type' => 'option',
				'sanitize_callback' => 'lalita_sanitize_choices'
			)
		);

		$wp_customize->add_control(
			'lalita_settings[cursor_style]',
			array(
				'type' => 'select',
				'label' => __( 'Cursor style', 'lalita' ),
				'choices' => array(
					'default' 	=> __( 'Default', 'lalita' ),
					'magic' 	=> __( 'Magic Cursor', 'lalita' ),
					'image' 	=> __( 'Image Cursor', 'lalita' )
				),
				'settings' => 'lalita_settings[cursor_style]',
				'section' => 'lalita_general_section'
			)
		);
		
		$wp_customize->add_setting(
			'lalita_settings[def_ci]',
			array(
				'default' => $defaults['def_ci'],
				'type' => 'option',
				'sanitize_callback' => 'esc_url_raw'
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Image_Control(
				$wp_customize,
				'lalita_settings[def_ci]',
				array(
					'label' => __( 'Default cursor image', 'lalita' ),
					'section' => 'lalita_general_section',
					'settings' => 'lalita_settings[def_ci]',
					'description' => __( 'Recommended size: 32*32px. Big image won`t work.', 'lalita' ),
					'active_callback' => 'lalita_is_cursor_image_active'
				)
			)
		);
		
		$wp_customize->add_setting(
			'lalita_settings[pointer_ci]',
			array(
				'default' => $defaults['pointer_ci'],
				'type' => 'option',
				'sanitize_callback' => 'esc_url_raw'
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Image_Control(
				$wp_customize,
				'lalita_settings[pointer_ci]',
				array(
					'label' => __( 'Pointer cursor image', 'lalita' ),
					'section' => 'lalita_general_section',
					'settings' => 'lalita_settings[pointer_ci]',
					'description' => __( 'Recommended size: 32*32px. Big image won`t work.', 'lalita' ),
					'active_callback' => 'lalita_is_cursor_image_active'
				)
			)
		);

		$wp_customize->add_setting(
			'lalita_settings[mm_color_1]', array(
				'default' => $defaults['mm_color_1'],
				'type' => 'option',
				'sanitize_callback' => 'lalita_sanitize_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				'lalita_settings[mm_color_1]',
				array(
					'label' => __( 'Magic Mouse Color 1', 'lalita' ),
					'section' => 'lalita_general_section',
					'settings' => 'lalita_settings[mm_color_1]',
					'active_callback' => 'lalita_is_magic_cursor_active'
				)
			)
		);

		$wp_customize->add_setting(
			'lalita_settings[mm_color_2]', array(
				'default' => $defaults['mm_color_2'],
				'type' => 'option',
				'sanitize_callback' => 'lalita_sanitize_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				'lalita_settings[mm_color_2]',
				array(
					'label' => __( 'Magic Mouse Color 2', 'lalita' ),
					'section' => 'lalita_general_section',
					'settings' => 'lalita_settings[mm_color_2]',
					'active_callback' => 'lalita_is_magic_cursor_active'
				)
			)
		);
		
		// Navigation effect. Splitting characters and adds effect
		$wp_customize->add_setting(
			'lalita_settings[splitnav_effect]',
			array(
				'default' => $defaults['splitnav_effect'],
				'type' => 'option',
				'sanitize_callback' => 'lalita_sanitize_choices'
			)
		);

		$wp_customize->add_control(
			'lalita_settings[splitnav_effect]',
			array(
				'type' => 'select',
				'label' => __( 'Splitting navigation effect', 'lalita' ),
				'choices' => array(
					'enable' => __( 'Enable', 'lalita' ),
					'disable' => __( 'Disable', 'lalita' )
				),
				'settings' => 'lalita_settings[splitnav_effect]',
				'section' => 'lalita_layout_navigation',
				'priority' => 25
			)
		);
		
		// Top bar scroll
		$wp_customize->add_setting(
			'lalita_settings[top_bar_scroll]',
			array(
				'default' => $defaults['top_bar_scroll'],
				'type' => 'option',
				'sanitize_callback' => 'lalita_sanitize_choices'
			)
		);

		$wp_customize->add_control(
			'lalita_settings[top_bar_scroll]',
			array(
				'type' => 'select',
				'label' => __( 'Top bar scroll', 'lalita' ),
				'choices' => array(
					'enable' => __( 'Enable', 'lalita' ),
					'disable' => __( 'Disable', 'lalita' )
				),
				'settings' => 'lalita_settings[top_bar_scroll]',
				'section' => 'lalita_top_bar'
			)
		);
		
		// Nicescroll
		$wp_customize->add_setting(
			'lalita_settings[nicescroll]',
			array(
				'default' => $defaults['nicescroll'],
				'type' => 'option',
				'sanitize_callback' => 'lalita_sanitize_choices'
			)
		);

		$wp_customize->add_control(
			'lalita_settings[nicescroll]',
			array(
				'type' => 'select',
				'label' => __( 'Scrollbar style', 'lalita' ),
				'choices' => array(
					'enable' => __( 'Enable', 'lalita' ),
					'disable' => __( 'Disable', 'lalita' )
				),
				'settings' => 'lalita_settings[nicescroll]',
				'section' => 'lalita_general_section',
			)
		);

		$wp_customize->add_setting(
			'lalita_settings[nicescroll_c1]', array(
				'default' => $defaults['nicescroll_c1'],
				'type' => 'option',
				'sanitize_callback' => 'lalita_sanitize_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				'lalita_settings[nicescroll_c1]',
				array(
					'label' => __( 'Nicescroll Track Color', 'lalita' ),
					'section' => 'lalita_general_section',
					'settings' => 'lalita_settings[nicescroll_c1]',
					'active_callback' => 'lalita_is_nicescroll_active'
				)
			)
		);

		$wp_customize->add_setting(
			'lalita_settings[nicescroll_c2]', array(
				'default' => $defaults['nicescroll_c2'],
				'type' => 'option',
				'sanitize_callback' => 'lalita_sanitize_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				'lalita_settings[nicescroll_c2]',
				array(
					'label' => __( 'Nicescroll Thumb Color', 'lalita' ),
					'section' => 'lalita_general_section',
					'settings' => 'lalita_settings[nicescroll_c2]',
					'active_callback' => 'lalita_is_nicescroll_active'
				)
			)
		);

		$wp_customize->add_setting(
			'lalita_settings[nicescroll_c3]', array(
				'default' => $defaults['nicescroll_c3'],
				'type' => 'option',
				'sanitize_callback' => 'lalita_sanitize_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				'lalita_settings[nicescroll_c3]',
				array(
					'label' => __( 'Nicescroll Thumb Hover Color', 'lalita' ),
					'section' => 'lalita_general_section',
					'settings' => 'lalita_settings[nicescroll_c3]',
					'active_callback' => 'lalita_is_nicescroll_active'
				)
			)
		);

		// Extra colors
		$wp_customize->add_setting(
			'lalita_settings[extracolor_1]', array(
				'default' => $defaults['extracolor_1'],
				'type' => 'option',
				'sanitize_callback' => 'lalita_sanitize_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				'lalita_settings[extracolor_1]',
				array(
					'label' => __( 'Extra Color 1', 'lalita' ),
					'section' => 'colors',
					'settings' => 'lalita_settings[extracolor_1]',
					'active_callback' => 'lalita_is_extra_colors_active'
				)
			)
		);
		
		$wp_customize->add_setting(
			'lalita_settings[extracolor_2]', array(
				'default' => $defaults['extracolor_2'],
				'type' => 'option',
				'sanitize_callback' => 'lalita_sanitize_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				'lalita_settings[extracolor_2]',
				array(
					'label' => __( 'Extra Color 2', 'lalita' ),
					'section' => 'colors',
					'settings' => 'lalita_settings[extracolor_2]',
					'active_callback' => 'lalita_is_extra_colors_active'
				)
			)
		);
		
		$wp_customize->add_setting(
			'lalita_settings[extracolor_3]', array(
				'default' => $defaults['extracolor_3'],
				'type' => 'option',
				'sanitize_callback' => 'lalita_sanitize_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				'lalita_settings[extracolor_3]',
				array(
					'label' => __( 'Extra Color 3', 'lalita' ),
					'section' => 'colors',
					'settings' => 'lalita_settings[extracolor_3]',
					'active_callback' => 'lalita_is_extra_colors_active'
				)
			)
		);
		
		$wp_customize->add_setting(
			'lalita_settings[extracolor_4]', array(
				'default' => $defaults['extracolor_4'],
				'type' => 'option',
				'sanitize_callback' => 'lalita_sanitize_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				'lalita_settings[extracolor_4]',
				array(
					'label' => __( 'Extra Color 4', 'lalita' ),
					'section' => 'colors',
					'settings' => 'lalita_settings[extracolor_4]',
					'active_callback' => 'lalita_is_extra_colors_active'
				)
			)
		);
		
		$wp_customize->add_setting(
			'lalita_settings[extracolor_5]', array(
				'default' => $defaults['extracolor_5'],
				'type' => 'option',
				'sanitize_callback' => 'lalita_sanitize_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				'lalita_settings[extracolor_5]',
				array(
					'label' => __( 'Extra Color 5', 'lalita' ),
					'section' => 'colors',
					'settings' => 'lalita_settings[extracolor_5]',
					'active_callback' => 'lalita_is_extra_colors_active'
				)
			)
		);
		
		
		// Add Extra customizer section
		$wp_customize->add_section(
			'lalita_extra_marga_effects',
			array(
				'title' => __( 'Marga Text Frame', 'lalita' ),
				'priority' => 22,
			)
		);
		
		$wp_customize->add_setting(
			'lalita_settings[marga_textframe_content]',
			array(
				'default' => '',
				'type' => 'option',
				'sanitize_callback' => 'wp_kses_post',
			)
		);

		$wp_customize->add_control(
			'lalita_settings[marga_textframe_content]',
			array(
				'type' 		 => 'textarea',
				'label'      => __( 'Text Frame for Marga', 'lalita' ),
				'description'=> __( 'Content that You want to display on top and bottom.', 'lalita' ),
				'section'    => 'lalita_extra_marga_effects',
				'settings'   => 'lalita_settings[marga_textframe_content]',
				'active_callback' => 'lalita_marga_textframe_active'
			)
		);
	}
}
