<?php
/**
 * Child theme functions.
 *
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

// Enqueue scripts and styles
if ( ! function_exists( 'lalita_child_css' ) ) {
	add_action( 'wp_enqueue_scripts', 'lalita_child_css' );
	function lalita_child_css() {
		$theme_style_active 	= get_option( 'lalita_theme_style_active', 'enable' );
		$lalita_theme_defaults  = get_option( 'lalita_theme_defaults', 'lalita' );
		$lalita_theme_defaults  = sanitize_key( $lalita_theme_defaults );
		
		if ( ( 'enable' == $theme_style_active ) && ( $lalita_theme_defaults != 'lalita' ) ) {
			wp_enqueue_style( 'lalita-child-style', get_template_directory_uri() . "/css/child/" . esc_attr( $lalita_theme_defaults ) . ".css", false, LALITA_VERSION, 'all' );
		}
		
		$lalita_settings = wp_parse_args(
			get_option( 'lalita_settings', array() ),
			lalita_get_defaults()
		);
		
		if ( 'magic' == $lalita_settings['cursor_style'] ) {
			wp_enqueue_style( 'lalita-magic-mouse', get_template_directory_uri() . "/css/magic-mouse.min.css", false, LALITA_VERSION, 'all' );
			wp_enqueue_script( 'lalita-magic-mouse', get_template_directory_uri() . "/js/magic-mouse.min.js", array( 'jquery'), LALITA_VERSION, true );
		}
		
		if ( ( 'enable' == $lalita_settings['splitnav_effect'] ) || ( $lalita_theme_defaults == 'daiva' ) || ( $lalita_theme_defaults == 'shudra' ) ) {
			wp_enqueue_style( 'lalita-splitting-css', esc_url( get_template_directory_uri() ) . "/css/splitting.min.css", false, LALITA_VERSION, 'all' );
			wp_enqueue_script( 'lalita-splitting-js', esc_url( get_template_directory_uri() ) . "/js/splitting.min.js", array( 'jquery'), LALITA_VERSION, true );
		}
		
		if ( ( $lalita_theme_defaults == 'marga' ) || ( 'enable' == $lalita_settings['top_bar_scroll'] ) ) {
			wp_enqueue_script( 'lalita-topbar-scroll', get_template_directory_uri() . "/js/jquery.marquee.min.js", array( 'jquery'), LALITA_VERSION, true );
		}
		
		if ( ( $lalita_theme_defaults == 'jihva' ) || ( $lalita_theme_defaults == 'nidra' ) ) {
			wp_enqueue_script( 'lalita-t', get_template_directory_uri() . "/js/t.min.js", array( 'jquery'), LALITA_VERSION, true );
		}
		
		wp_enqueue_style( 'lalita-childextra-css', esc_url( get_template_directory_uri() ) . "/css/child-style.min.css", false, LALITA_VERSION, 'all' );
	}
}

// Extra colors CSS
if ( ! function_exists( 'lalita_child_extra_colors_css' ) ) {
	function lalita_child_extra_colors_css() {
		// Get our settings
		$lalita_settings = wp_parse_args(
			get_option( 'lalita_settings', array() ),
			lalita_get_defaults()
		);
		
		$lalita_color_settings = wp_parse_args(
			get_option( 'lalita_settings', array() ),
			lalita_get_color_defaults()
		);
		
		$lalita_font_settings = wp_parse_args(
			get_option( 'lalita_settings', array() ),
			lalita_get_default_fonts()
		);
		
		$lalita_theme_defaults = get_option( 'lalita_theme_defaults', 'lalita' );
		$lalita_theme_defaults = sanitize_key( $lalita_theme_defaults );
		
		$def_ci  	= '';
		$pointer_ci = '';
		if ( isset( $lalita_settings['def_ci'] ) ) {
			$def_ci = $lalita_settings['def_ci'];
		}
		if ( isset( $lalita_settings['pointer_ci'] ) ) {
			$pointer_ci = $lalita_settings['pointer_ci'];
		}
		
		$lalita_extracolors = 'body #magicMouseCursor {border: 1px solid ' . esc_attr( $lalita_settings[ 'mm_color_1' ] ) . ';}body #magicPointer{background: ' . esc_attr( $lalita_settings[ 'mm_color_2' ] ) . ';}.lalita-scrollbar-style::-webkit-scrollbar-track {background: ' . esc_attr( $lalita_settings[ 'nicescroll_c1' ] ) . ';}.lalita-scrollbar-style::-webkit-scrollbar-thumb {background: ' . esc_attr( $lalita_settings[ 'nicescroll_c2' ] ) . ';border: 1px solid ' . esc_attr( $lalita_settings[ 'nicescroll_c1' ] ) . ';}.lalita-scrollbar-style::-webkit-scrollbar-thumb:hover {background: ' . esc_attr( $lalita_settings[ 'nicescroll_c3' ] ) . ';}.lalita-maitri-child .main-title a:hover {color: ' . esc_attr( $lalita_color_settings[ 'navigation_text_hover_color' ] ) . ';}.lalita-manas-child #site-navigation .main-nav ul li.menu-item a::after,.lalita-manas-child #site-navigation .main-nav ul li.menu-item a::before {background-color: ' . esc_attr( $lalita_color_settings[ 'navigation_text_hover_color' ] ) . '}.marga-frame {font-family: ' . wp_kses_post( lalita_get_font_family_css( 'font_fixed_side', 'lalita_settings', lalita_get_default_fonts() ) ) . ';font-weight: ' . esc_attr( $lalita_font_settings[ 'fixed_side_font_weight' ] ) . ';text-transform: ' . esc_attr( $lalita_font_settings[ 'fixed_side_font_transform' ] ) . ';font-size: ' . esc_attr( $lalita_font_settings[ 'fixed_side_font_size' ] ) . 'px;}';
		
		if ( ( $lalita_settings['cursor_style'] == 'image' ) && ( $def_ci != '' ) ) {
			$lalita_extracolors .= 'body.lalita-cursor-image{cursor: url(' . esc_url( $def_ci ) . '), auto; }';
		}
		if ( ( $lalita_settings['cursor_style'] == 'image' ) && ( $pointer_ci != '' ) ) {
			$lalita_extracolors .= '.lalita-cursor-image a, .lalita-cursor-image input[type="submit"]:hover {cursor: url(' . esc_url( $pointer_ci ) . '), auto; }';
		}
		
		if ( ( lalita_is_extra_colors_active() == true ) && ( $lalita_theme_defaults == 'daiva' ) ) {
			$lalita_extracolors .= '.daiva-frame-top {border-color: ' . esc_attr( $lalita_settings[ 'extracolor_2'] ) . ' transparent transparent transparent;}.daiva-frame-right {border-color: transparent ' . esc_attr( $lalita_settings[ 'extracolor_3'] ) . ' transparent transparent;}.daiva-frame-bottom {border-color: transparent transparent ' . esc_attr( $lalita_settings[ 'extracolor_4'] ) . ' transparent;}.daiva-frame-left {border-color: transparent transparent transparent ' . esc_attr( $lalita_settings[ 'extracolor_1'] ) . ';}.lalita-daiva-child .main-title a .word span, .lalita-daiva-child .main-title a .word span:nth-child(5), .lalita-daiva-child .main-title a .word span:nth-child(9) {color: ' . esc_attr( $lalita_settings[ 'extracolor_1'] ) . '}.lalita-daiva-child .main-title a .word span:nth-child(2), .lalita-daiva-child .main-title a .word span:nth-child(6), .lalita-daiva-child .main-title a .word span:nth-child(10), .lalita-daiva-child .top-bar .lalita-socials-list li:nth-child(2) a, .lalita-daiva-child .top-bar .lalita-socials-list li:nth-child(6) a {color: ' . esc_attr( $lalita_settings[ 'extracolor_2'] ) . '}.lalita-daiva-child .main-title a .word span:nth-child(3), .lalita-daiva-child .main-title a .word span:nth-child(7), .lalita-daiva-child .main-title a .word span:nth-child(11), .lalita-daiva-child .top-bar .lalita-socials-list li:nth-child(3) a, .lalita-daiva-child .top-bar .lalita-socials-list li:nth-child(7) a {color: ' . esc_attr( $lalita_settings[ 'extracolor_3'] ) . '}.lalita-daiva-child .main-title a .word span:nth-child(4), .lalita-daiva-child .main-title a .word span:nth-child(8), .lalita-daiva-child .main-title a .word span:nth-child(12), .lalita-daiva-child .top-bar .lalita-socials-list li:nth-child(4) a, .lalita-daiva-child .top-bar .lalita-socials-list li:nth-child(8) a {color: ' . esc_attr( $lalita_settings[ 'extracolor_4'] ) . '}.lalita-daiva-child .main-navigation .main-nav ul li a, .lalita-daiva-child .main-navigation .main-nav ul li:nth-child(5) a, .lalita-daiva-child .main-navigation .main-nav ul li:nth-child(9) a {color: ' . esc_attr( $lalita_settings[ 'extracolor_2'] ) . '}.lalita-daiva-child .main-navigation .main-nav ul li:nth-child(2) a, .lalita-daiva-child .main-navigation .main-nav ul li:nth-child(6) a, .lalita-daiva-child .main-navigation .main-nav ul li:nth-child(10) a {color: ' . esc_attr( $lalita_settings[ 'extracolor_3'] ) . '}.lalita-daiva-child .main-navigation .main-nav ul li:nth-child(3) a, .lalita-daiva-child .main-navigation .main-nav ul li:nth-child(7) a, .lalita-daiva-child .main-navigation .main-nav ul li:nth-child(11) a {color: ' . esc_attr( $lalita_settings[ 'extracolor_4'] ) . '}.lalita-daiva-child .main-navigation .main-nav ul li:nth-child(4) a, .lalita-daiva-child .main-navigation .main-nav ul li:nth-child(8) a, .lalita-daiva-child .main-navigation .main-nav ul li:nth-child(12) a {color: ' . esc_attr( $lalita_settings[ 'extracolor_1'] ) . '}.lalita-daiva-child article .entry-header .entry-title a {background-image: linear-gradient(transparent calc(65% - 5px), ' . esc_attr( $lalita_settings[ 'extracolor_1'] ) . ' 5px);color: ' . esc_attr( $lalita_settings[ 'extracolor_1'] ) . ';}.lalita-daiva-child .main-navigation .main-nav ul li:hover > a {color: ' . esc_attr( $lalita_color_settings[ 'navigation_text_hover_color' ] ) . '}.lalita-daiva-child .main-navigation .main-nav ul ul li a {color: ' . esc_attr( $lalita_color_settings[ 'subnavigation_text_color' ] ) . ' !important}.lalita-daiva-child .main-navigation .main-nav ul ul li:hover > a {color: ' . esc_attr( $lalita_color_settings[ 'subnavigation_text_hover_color' ] ) . ' !important}';
		}
		
		if ( ( lalita_is_extra_colors_active() == true ) && ( $lalita_theme_defaults == 'ekata' ) ) {
			$lalita_extracolors .= '.lalita-ekata-child .main-navigation .main-nav ul li:before {background: ' . esc_attr( $lalita_settings[ 'extracolor_2'] ) . ';border-color: ' . esc_attr( $lalita_settings[ 'extracolor_1'] ) . ';box-shadow: 3px 3px ' . esc_attr( $lalita_settings[ 'extracolor_3'] ) . ', 3px 3px 0px 1px ' . esc_attr( $lalita_settings[ 'extracolor_1'] ) . ';}.lalita-ekata-child .main-navigation .main-nav ul li:hover:before {background: ' . esc_attr( $lalita_settings[ 'extracolor_3'] ) . ';}.lalita-ekata-child article .entry-header .entry-title a {background-image: linear-gradient(transparent calc(65% - 5px), ' . esc_attr( $lalita_settings[ 'extracolor_4'] ) . ' 5px);color: ' . esc_attr( $lalita_settings[ 'extracolor_1'] ) . ';}.lalita-ekata-child article:nth-child(2) .entry-header .entry-title a, .lalita-ekata-child article:nth-child(5) .entry-header .entry-title a, .lalita-ekata-child article:nth-child(8) .entry-header .entry-title a, .lalita-ekata-child article:nth-child(11) .entry-header .entry-title a {background-image: linear-gradient(transparent calc(65% - 5px), ' . esc_attr( $lalita_settings[ 'extracolor_4'] ) . ' 5px);}.lalita-ekata-child article:nth-child(3) .entry-header .entry-title a, .lalita-ekata-child article:nth-child(6) .entry-header .entry-title a, .lalita-ekata-child article:nth-child(9) .entry-header .entry-title a, .lalita-ekata-child article:nth-child(12) .entry-header .entry-title a {background-image: linear-gradient(transparent calc(65% - 5px), ' . esc_attr( $lalita_settings[ 'extracolor_4'] ) . ' 5px);}.lalita-ekata-child article .entry-header .entry-title:hover a {color: ' . esc_attr( $lalita_settings[ 'extracolor_1'] ) . ';}';
		}
		
		if ( ( lalita_is_extra_colors_active() == true ) && ( $lalita_theme_defaults == 'ganapati' ) ) {
			$lalita_extracolors .= '.ganapati-frame {color: ' . esc_attr( $lalita_settings[ 'extracolor_1'] ) . ';}.lalita-ganapati-child .main-title a, .lalita-ganapati-child .main-title a:hover, .lalita-ganapati-child .main-title a:visited {background-color: ' . esc_attr( $lalita_settings[ 'extracolor_1'] ) . '; color: ' . esc_attr( $lalita_settings[ 'extracolor_2'] ) . ';}.lalita-ganapati-child article .entry-header .entry-title a {background-color: ' . esc_attr( $lalita_settings[ 'extracolor_1'] ) . '; color: ' . esc_attr( $lalita_settings[ 'extracolor_2'] ) . ';}';
		}
		
		if ( ( lalita_is_extra_colors_active() == true ) && ( $lalita_theme_defaults == 'gotra' ) ) {
			$lalita_extracolors .= 'body #magicMouseCursor{background-color: ' . esc_attr( $lalita_settings[ 'mm_color_1'] ) . ';}body #magicPointer{background: ' . esc_attr( $lalita_settings[ 'mm_color_2'] ) . ';}body #magicPointer.pointer-blur{background-color: ' . esc_attr( $lalita_settings[ 'mm_color_2'] ) . ' !important;} .lalita-gotra-child .button,.lalita-gotra-child .button:visited,.lalita-gotra-child button:not(.menu-toggle), html .lalita-gotra-child input[type="button"],.lalita-gotra-child input[type="reset"],.lalita-gotra-child input[type="submit"],.woocommerce.lalita-gotra-child a.button, .woocommerce.lalita-gotra-child button.button.alt {color: ' . esc_attr( $lalita_settings[ 'extracolor_3'] ) . ';}.lalita-gotra-child .button:hover,.lalita-gotra-child .button:visited:hover,.lalita-gotra-child button:not(.menu-toggle):hover, html .lalita-gotra-child input[type="button"]:hover,.lalita-gotra-child input[type="reset"]:hover,.lalita-gotra-child input[type="submit"]:hover,.woocommerce.lalita-gotra-child a.button:hover, .woocommerce.lalita-gotra-child button.button.alt:hover {color: ' . esc_attr( $lalita_settings[ 'extracolor_4'] ) . ';border-color: ' . esc_attr( $lalita_settings[ 'extracolor_3'] ) . ';background-color: ' . esc_attr( $lalita_settings[ 'extracolor_3'] ) . '}';
		}
		
		if ( ( lalita_is_extra_colors_active() == true ) && ( $lalita_theme_defaults == 'ishta' ) ) {
			$lalita_extracolors .= '.lalita-ishta-child .inside-header{background: linear-gradient(90deg, ' . esc_attr( $lalita_settings[ 'extracolor_1'] ) . ' 50.01%, ' . esc_attr( $lalita_settings[ 'extracolor_2'] ) . ' 50%);}.lalita-ishta-child .main-title a, .lalita-ishta-child .main-title a:hover, .lalita-ishta-child .main-title a:visited {color: ' . esc_attr( $lalita_settings[ 'extracolor_2'] ) . ';}.lalita-ishta-child .lalita-side-left-content .lalita-socials-list li:nth-child(2), .lalita-ishta-child .lalita-side-left-content .lalita-socials-list li:nth-child(4), .lalita-ishta-child .lalita-side-left-content .lalita-socials-list li:nth-child(6), .lalita-ishta-child .lalita-side-left-content .lalita-socials-list li:nth-child(8) {background-color: ' . esc_attr( $lalita_settings[ 'extracolor_1'] ) . ';}.lalita-ishta-child .lalita-side-left-content .lalita-side-left-socials ul {border-color: ' . esc_attr( $lalita_settings[ 'extracolor_3'] ) . ';}.main-title a .char:before{color:' . esc_attr( $lalita_settings[ 'extracolor_2'] ) . ';}.main-title a .char:after{color:' . esc_attr( $lalita_settings[ 'extracolor_1'] ) . ';}.main-title a:hover .char{color:' . esc_attr( $lalita_settings[ 'extracolor_3'] ) . ';}.main-title a .char:nth-child(2), .main-title a .char:nth-child(4), .main-title a .char:nth-child(6), .main-title a .char:nth-child(8), .main-title a .char:nth-child(10), .main-title a .char:nth-child(12), .main-title a .char:nth-child(14), .main-title a .char:nth-child(16), .main-title a .char:nth-child(18), .main-title a .char:nth-child(20) {color: ' . esc_attr( $lalita_settings[ 'extracolor_3'] ) . ';}@media (max-width: 768px) {.lalita-ishta-child .inside-header{background: ' . esc_attr( $lalita_settings[ 'extracolor_1'] ) . ';}}';
		}
		
		if ( ( lalita_is_extra_colors_active() == true ) && ( $lalita_theme_defaults == 'itara' ) ) {
			$lalita_extracolors .= '.lalita-itara-child .lalita-side-padding-inside {border: 10px solid ' . esc_attr( $lalita_settings[ 'extracolor_1'] ) . ';}.lalita-itara-child .site-footer{border-top: 10px solid ' . esc_attr( $lalita_settings[ 'extracolor_1'] ) . ';}.lalita-itara-child .site-header {border-bottom: 10px solid ' . esc_attr( $lalita_settings[ 'extracolor_1'] ) . ';}.lalita-itara-child .nav-float-right .is_stuck.main-navigation .nav-float-right .is_stuck.main-navigation{border-color: ' . esc_attr( $lalita_settings[ 'extracolor_1'] ) . '}.lalita-itara-child .post-image img {border: 5px solid ' . esc_attr( $lalita_settings[ 'extracolor_1'] ) . ';}';
		}
		
		if ( ( lalita_is_extra_colors_active() == true ) && ( $lalita_theme_defaults == 'jagat' ) ) {
			$lalita_extracolors .= 'body #magicPointer{background: ' . esc_attr( $lalita_settings[ 'mm_color_1'] ) . ';border-color: ' . esc_attr( $lalita_settings[ 'mm_color_2'] ) . ';}body #magicPointer.pointer-blur{border-color: ' . esc_attr( $lalita_settings[ 'extracolor_1'] ) . ';}.lalita-jagat-child h2.entry-title {background-color: ' . esc_attr( $lalita_settings[ 'extracolor_1'] ) . ';background-image: linear-gradient(' . esc_attr( $lalita_settings[ 'extracolor_3'] ) . ' 30%, ' . esc_attr( $lalita_settings[ 'extracolor_1'] ) . ' 30%, ' . esc_attr( $lalita_settings[ 'extracolor_1'] ) . ' 70%, ' . esc_attr( $lalita_settings[ 'extracolor_3'] ) . ' 70%);}.lalita-jagat-child h2.entry-title a{background-color: ' . esc_attr( $lalita_settings[ 'extracolor_3'] ) . '}';
		}
		
		if ( ( lalita_is_extra_colors_active() == true ) && ( $lalita_theme_defaults == 'mahatma' ) ) {
			$lalita_extracolors .= '.lalita-mahatma-child .main-navigation .main-nav ul li a .char:before {color: ' . esc_attr( $lalita_settings[ 'extracolor_2'] ) . ';}.lalita-mahatma-child .main-navigation .main-nav ul li a .char:after { color: ' . esc_attr( $lalita_settings[ 'extracolor_3'] ) . ';}.lalita-mahatma-child .main-navigation .main-nav ul li a:hover .char {color: ' . esc_attr( $lalita_settings[ 'extracolor_1'] ) . ';}.lalita-mahatma-child .top-bar .widget_nav_menu li a, .lalita-mahatma-child .site-info .widget_nav_menu li a {background: ' . esc_attr( $lalita_settings[ 'extracolor_2'] ) . ';color: ' . esc_attr( $lalita_settings[ 'extracolor_1'] ) . ';}.lalita-mahatma-child .top-bar .widget_nav_menu li a:hover, .lalita-mahatma-child .site-info .widget_nav_menu li a:hover {background: ' . esc_attr( $lalita_settings[ 'extracolor_3'] ) . ';}.lalita-mahatma-child article .entry-header .entry-title a {background-image: linear-gradient(transparent calc(65% - 5px), ' . esc_attr( $lalita_settings[ 'extracolor_2'] ) . ' 5px);color: ' . esc_attr( $lalita_settings[ 'extracolor_2'] ) . ';}.lalita-mahatma-child article .entry-header .entry-title:hover a {color: ' . esc_attr( $lalita_settings[ 'extracolor_1'] ) . ';} .lalita-mahatma-child .main-title a::after {background-image: repeating-linear-gradient( 135deg, transparent 0, transparent 2px, ' . esc_attr( $lalita_settings[ 'extracolor_1'] ) . ' 2px, ' . esc_attr( $lalita_settings[ 'extracolor_1'] ) . ' 3px );} .lalita-mahatma-child .main-title a::before {background-image: repeating-linear-gradient( 45deg, transparent 0, transparent 2px, ' . esc_attr( $lalita_settings[ 'extracolor_1'] ) . ' 2px, ' . esc_attr( $lalita_settings[ 'extracolor_1'] ) . ' 3px );} .lalita-mahatma-child .main-title a::before, .lalita-mahatma-child .main-title a::after {content: "' . esc_attr( get_bloginfo( 'name' ) ) . '";}';
		}
		
		if ( ( lalita_is_extra_colors_active() == true ) && ( $lalita_theme_defaults == 'makara' ) ) {
			$lalita_extracolors .= '.lalita-makara-child .button,.lalita-makara-child .button:visited,.lalita-makara-child button:not(.menu-toggle),html .lalita-makara-child input[type="button"],.lalita-makara-child input[type="reset"],.lalita-makara-child input[type="submit"],.woocommerce.lalita-makara-child a.button, .woocommerce.lalita-makara-child button.button.alt {color: ' . esc_attr( $lalita_settings[ 'extracolor_2'] ) . '; border-color: ' . esc_attr( $lalita_settings[ 'extracolor_3'] ) . '}.lalita-makara-child .button:hover,.lalita-makara-child .button:visited:hover,.lalita-makara-child button:not(.menu-toggle):hover,html .lalita-makara-child input[type="button"]:hover,.lalita-makara-child input[type="reset"]:hover,.lalita-makara-child input[type="submit"]:hover,.woocommerce.lalita-makara-child a.button:hover, .woocommerce.lalita-makara-child button.button.alt:hover {color: ' . esc_attr( $lalita_settings[ 'extracolor_3'] ) . ';border-color: ' . esc_attr( $lalita_settings[ 'extracolor_2'] ) . ';background-color: ' . esc_attr( $lalita_settings[ 'extracolor_2'] ) . '}.lalita-makara-child #right-sidebar, .lalita-makara-child #left-sidebar{border-color: ' . esc_attr( $lalita_settings[ 'extracolor_3'] ) . ';}';
		}
		
		if ( ( lalita_is_extra_colors_active() == true ) && ( $lalita_theme_defaults == 'marga' ) ) {
			$lalita_extracolors .= '.marga-frame {background-color: ' . esc_attr( $lalita_settings[ 'extracolor_1'] ) . ';border-color: ' . esc_attr( $lalita_settings[ 'extracolor_1'] ) . ';color: ' . esc_attr( $lalita_settings[ 'extracolor_2'] ) . ';}.lalita-marga-child .site-branding .main-title a, .lalita-marga-child .site-branding .main-title a:hover, .lalita-marga-child .site-branding .main-title a:visited {background: ' . esc_attr( $lalita_settings[ 'extracolor_1'] ) . ';color: ' . esc_attr( $lalita_settings[ 'extracolor_2'] ) . ';}.inside-navigation .search-form input[type="search"]:focus {color: ' . esc_attr( $lalita_settings[ 'extracolor_2'] ) . ' !important}';
		}
		
		if ( $lalita_theme_defaults == 'neela' ) {
			$lalita_extracolors .= '.page-header-blog-content h2{color: ' . esc_attr( $lalita_color_settings[ 'blog_header_text_color' ] ) . ';background-color: ' . esc_attr( $lalita_color_settings[ 'blog_header_title_color' ] ) . ';text-shadow: ' . esc_attr( $lalita_color_settings[ 'blog_header_bg_s_color' ] ) . '}.page-header-blog-content p{color: ' . esc_attr( $lalita_color_settings[ 'blog_header_title_color' ] ) . ';background-color: ' . esc_attr( $lalita_color_settings[ 'blog_header_text_color' ] ) . ';}.lalita-neela-child .main-title a::after {background-image: repeating-linear-gradient( 135deg, transparent 0, transparent 2px, ' . esc_attr( $lalita_color_settings[ 'navigation_text_color' ] ) . ' 2px, ' . esc_attr( $lalita_color_settings[ 'navigation_text_color' ] ) . ' 3px );} .lalita-neela-child .main-title a::before {background-image: repeating-linear-gradient( 45deg, transparent 0, transparent 2px, ' . esc_attr( $lalita_color_settings[ 'navigation_text_color' ] ) . ' 2px, ' . esc_attr( $lalita_color_settings[ 'navigation_text_color' ] ) . ' 3px );} .lalita-neela-child .main-title a::before, .lalita-neela-child .main-title a::after {content: "' . esc_attr( get_bloginfo( 'name' ) ) . '";}.lalita-neela-child article .entry-header .entry-title a {background-image: linear-gradient(transparent calc(65% - 5px), ' . esc_attr( $lalita_color_settings[ 'blog_header_title_color' ] ) . ' 5px);}';
		}
		
		if ( ( lalita_is_extra_colors_active() == true ) && ( $lalita_theme_defaults == 'parama' ) ) {
			$lalita_extracolors .= '.lalita-parama-child .main-title a::after {background-image: repeating-linear-gradient( 135deg, transparent 0, transparent 2px, ' . esc_attr( $lalita_settings[ 'extracolor_2'] ) . ' 2px, ' . esc_attr( $lalita_settings[ 'extracolor_2'] ) . ' 3px );} .lalita-parama-child .main-title a::before {background-image: repeating-linear-gradient( 45deg, transparent 0, transparent 2px, ' . esc_attr( $lalita_settings[ 'extracolor_2'] ) . ' 2px, ' . esc_attr( $lalita_settings[ 'extracolor_2'] ) . ' 3px );} .lalita-parama-child .main-title a::before, .lalita-parama-child .main-title a::after {content: "' . esc_attr( get_bloginfo( 'name' ) ) . '";}.lalita-parama-child h2.entry-title a {color: ' . esc_attr( $lalita_settings[ 'extracolor_2'] ) . '}.lalita-parama-child h2.entry-title a:hover {color: ' . esc_attr( $lalita_settings[ 'extracolor_1'] ) . '}.lalita-parama-child h2.entry-title {background-color: ' . esc_attr( $lalita_settings[ 'extracolor_1'] ) . ';}.lalita-parama-child h2.entry-title a{background-color: #' . esc_attr( get_background_color() ) . '}.inside-navigation .search-form input[type="search"]:focus {color: ' . esc_attr( $lalita_settings[ 'extracolor_1'] ) . ' !important}';
		}
		
		if ( ( lalita_is_extra_colors_active() == true ) && ( $lalita_theme_defaults == 'prakasa' ) ) {
			$lalita_extracolors .= 'body #magicMouseCursor{border-color: ' . esc_attr( $lalita_settings[ 'extracolor_2'] ) . ';}body #magicPointer{background: ' . esc_attr( $lalita_settings[ 'extracolor_1'] ) . ';} .lalita-prakasa-child .main-title a, .lalita-prakasa-child .main-title a:hover, .lalita-prakasa-child .main-title a:visited {-webkit-text-stroke-color: ' . esc_attr( $lalita_settings[ 'extracolor_1'] ) . ';stroke: ' . esc_attr( $lalita_settings[ 'extracolor_1'] ) . ';}.transparent-header.home .main-navigation.is_stuck {background-color: ' . esc_attr( $lalita_color_settings['navigation_background_color'] ) . ';}.lalita-prakasa-child h2.entry-title a {-webkit-text-stroke-color: ' . esc_attr( $lalita_settings[ 'extracolor_3'] ) . '; stroke: ' . esc_attr( $lalita_settings[ 'extracolor_3'] ) . ';}';
		}
		
		if ( ( lalita_is_extra_colors_active() == true ) && ( $lalita_theme_defaults == 'sakti' ) ) {
			$lalita_extracolors .= '.lalita-sakti-child .main-navigation .main-nav ul li:before {background: ' . esc_attr( $lalita_settings[ 'extracolor_1'] ) . '}.lalita-sakti-child .main-navigation .main-nav ul li:nth-child(2):before, .lalita-sakti-child .main-navigation .main-nav ul li:nth-child(5):before, .lalita-sakti-child .main-navigation .main-nav ul li:nth-child(8):before, .lalita-sakti-child .main-navigation .main-nav ul li:nth-child(11):before, .lalita-sakti-child .main-navigation .main-nav ul li:nth-child(14):before, .lalita-sakti-child .main-navigation .main-nav ul li:nth-child(17):before {background: ' . esc_attr( $lalita_settings[ 'extracolor_2'] ) . ';}.lalita-sakti-child .main-navigation .main-nav ul li:nth-child(3):before, .lalita-sakti-child .main-navigation .main-nav ul li:nth-child(6):before, .lalita-sakti-child .main-navigation .main-nav ul li:nth-child(9):before, .lalita-sakti-child .main-navigation .main-nav ul li:nth-child(12):before, .lalita-sakti-child .main-navigation .main-nav ul li:nth-child(15):before, .lalita-sakti-child .main-navigation .main-nav ul li:nth-child(18):before {background: ' . esc_attr( $lalita_settings[ 'extracolor_3'] ) . ';}.lalita-sakti-child .main-navigation .main-nav ul li a, .lalita-sakti-child .menu-toggle {color: ' . esc_attr( $lalita_color_settings[ 'header_background_color'] ) . ';}.lalita-sakti-child .main-navigation .main-nav ul li[class*="current-menu-"] > a:hover, .lalita-sakti-child .main-navigation .main-nav ul li[class*="current-menu-"].sfHover > a, .lalita-sakti-child .main-navigation .main-nav ul li[class*="current-menu-"] > a, .lalita-sakti-child .main-navigation .main-nav ul li:hover > a, .lalita-sakti-child .main-navigation .main-nav ul li:focus > a, .lalita-sakti-child .main-navigation .main-nav ul li.sfHover > a, .lalita-sakti-child .menu-toggle {color: ' . esc_attr( $lalita_settings[ 'extracolor_4'] ) . ';}.lalita-sakti-child .post-image img {border-color: ' . esc_attr( $lalita_settings[ 'extracolor_1'] ) . '}.lalita-sakti-child article:nth-child(2) .post-image img, .lalita-sakti-child article:nth-child(5) .post-image img, .lalita-sakti-child article:nth-child(8) .post-image img, .lalita-sakti-child article:nth-child(11) .post-image img, .lalita-sakti-child article:nth-child(14) .post-image img, .lalita-sakti-child article:nth-child(17) .post-image img, .lalita-sakti-child article:nth-child(20) .post-image img{border-color: ' . esc_attr( $lalita_settings[ 'extracolor_2'] ) . '}.lalita-sakti-child article:nth-child(3) .post-image img, .lalita-sakti-child article:nth-child(6) .post-image img, .lalita-sakti-child article:nth-child(9) .post-image img, .lalita-sakti-child article:nth-child(12) .post-image img, .lalita-sakti-child article:nth-child(15) .post-image img, .lalita-sakti-child article:nth-child(18) .post-image img, .lalita-sakti-child article:nth-child(21) .post-image img{border-color: ' . esc_attr( $lalita_settings[ 'extracolor_3'] ) . '}';
		}
		
		if ( ( lalita_is_extra_colors_active() == true ) && ( $lalita_theme_defaults == 'samana' ) ) {
			$lalita_extracolors .= '.lalita-samana-child .site-branding { box-shadow: 7px 7px 0px 0px ' . esc_attr( $lalita_settings[ 'extracolor_1'] ) . ';}.lalita-samana-child .main-title {background: ' . esc_attr( $lalita_settings[ 'extracolor_1'] ) . ';}.lalita-samana-child .top-bar .lalita-socials-list li, .lalita-samana-child .top-bar .lalita-socials-list li:nth-child(6) {box-shadow: 2px 2px 0px 0px ' . esc_attr( $lalita_settings[ 'extracolor_1'] ) . ';}.lalita-samana-child .top-bar .lalita-socials-list li a, .lalita-samana-child .top-bar .lalita-socials-list li:nth-child(6) a {background: ' . esc_attr( $lalita_settings[ 'extracolor_1'] ) . ';}.lalita-samana-child .top-bar .lalita-socials-list li:nth-child(2), .lalita-samana-child .top-bar .lalita-socials-list li:nth-child(7) {box-shadow: 2px 2px 0px 0px ' . esc_attr( $lalita_settings[ 'extracolor_2'] ) . ';}.lalita-samana-child .top-bar .lalita-socials-list li:nth-child(2) a, .lalita-samana-child .top-bar .lalita-socials-list li:nth-child(7) a {background: ' . esc_attr( $lalita_settings[ 'extracolor_2'] ) . ';}.lalita-samana-child .top-bar .lalita-socials-list li:nth-child(3), .lalita-samana-child .top-bar .lalita-socials-list li:nth-child(8) {box-shadow: 2px 2px 0px 0px ' . esc_attr( $lalita_settings[ 'extracolor_3'] ) . ';}.lalita-samana-child .top-bar .lalita-socials-list li:nth-child(3) a, .lalita-samana-child .top-bar .lalita-socials-list li:nth-child(8) a {background: ' . esc_attr( $lalita_settings[ 'extracolor_3'] ) . ';}.lalita-samana-child .top-bar .lalita-socials-list li:nth-child(4), .lalita-samana-child .top-bar .lalita-socials-list li:nth-child(9) {box-shadow: 2px 2px 0px 0px ' . esc_attr( $lalita_settings[ 'extracolor_4'] ) . ';}.lalita-samana-child .top-bar .lalita-socials-list li:nth-child(4) a, .lalita-samana-child .top-bar .lalita-socials-list li:nth-child(9) a {background: ' . esc_attr( $lalita_settings[ 'extracolor_4'] ) . ';}.lalita-samana-child .top-bar .lalita-socials-list li:nth-child(5), .lalita-samana-child .top-bar .lalita-socials-list li:nth-child(10) {box-shadow: 2px 2px 0px 0px ' . esc_attr( $lalita_settings[ 'extracolor_5'] ) . ';}.lalita-samana-child .top-bar .lalita-socials-list li:nth-child(5) a, .lalita-samana-child .top-bar .lalita-socials-list li:nth-child(10) a {background: ' . esc_attr( $lalita_settings[ 'extracolor_5'] ) . ';}header .main-navigation .wpkoi-nav-btn:before { box-shadow: 5px 5px 0px 0px ' . esc_attr( $lalita_settings[ 'extracolor_3'] ) . ';}header .main-navigation .main-nav ul li a.wpkoi-nav-btn, .main-navigation.toggled .main-nav li.wpkoi-nav-btn-h .wpkoi-nav-btn {background-color: ' . esc_attr( $lalita_settings[ 'extracolor_3'] ) . ' !important;}.lalita-samana-child.blog article .post-image img, .lalita-samana-child.blog article:nth-child(6) .post-image img, .lalita-samana-child.blog article:nth-child(11) .post-image img {box-shadow: 8px 8px 0px 0px ' . esc_attr( $lalita_settings[ 'extracolor_1'] ) . ';}.lalita-samana-child.blog article:nth-child(2) .post-image img, .lalita-samana-child.blog article:nth-child(7) .post-image img, .lalita-samana-child.blog article:nth-child(12) .post-image img {box-shadow: 8px 8px 0px 0px ' . esc_attr( $lalita_settings[ 'extracolor_2'] ) . ';}.lalita-samana-child.blog article:nth-child(3) .post-image img, .lalita-samana-child.blog article:nth-child(8) .post-image img, .lalita-samana-child.blog article:nth-child(13) .post-image img {box-shadow: 8px 8px 0px 0px ' . esc_attr( $lalita_settings[ 'extracolor_3'] ) . ';}.lalita-samana-child.blog article:nth-child(4) .post-image img, .lalita-samana-child.blog article:nth-child(9) .post-image img, .lalita-samana-child.blog article:nth-child(14) .post-image img {box-shadow: 8px 8px 0px 0px ' . esc_attr( $lalita_settings[ 'extracolor_4'] ) . ';}.lalita-samana-child.blog article:nth-child(5) .post-image img, .lalita-samana-child.blog article:nth-child(10) .post-image img, .lalita-samana-child.blog article:nth-child(15) .post-image img {box-shadow: 8px 8px 0px 0px ' . esc_attr( $lalita_settings[ 'extracolor_5'] ) . ';}';
		}
		
		if ( $lalita_theme_defaults == 'skanda' ) {
			$lalita_extracolors .= '.page-header-blog img {box-shadow: 15px 15px 0px 0px ' . esc_attr( $lalita_color_settings[ 'blog_header_bg_s_color' ] ) . ';}.lalita-skanda-child .post-image img{box-shadow: 10px 10px 0px 0px ' . esc_attr( $lalita_color_settings[ 'sidebar_widget_background_color' ] ) . ';}';
		}
		
		if ( ( lalita_is_extra_colors_active() == true ) && ( $lalita_theme_defaults == 'sundara' ) ) {
			$lalita_extracolors .= '.lalita-sundara-child #page {background-image: linear-gradient(' . esc_attr( $lalita_settings[ 'extracolor_1'] ) . ', ' . esc_attr( $lalita_settings[ 'extracolor_2'] ) . ', ' . esc_attr( $lalita_settings[ 'extracolor_3'] ) . ');}.lalita-sundara-child #right-sidebar, .lalita-sundara-child #left-sidebar {background-image: linear-gradient(' . esc_attr( $lalita_settings[ 'extracolor_4'] ) . ', ' . esc_attr( $lalita_settings[ 'extracolor_5'] ) . ');}.lalita-sundara-child::-webkit-scrollbar-thumb {background-image: linear-gradient(' . esc_attr( $lalita_settings[ 'extracolor_4'] ) . ', ' . esc_attr( $lalita_settings[ 'extracolor_5'] ) . ');border-color: ' . esc_attr( $lalita_settings[ 'text_color' ] ) . ';}';
		}
		
		if ( $lalita_theme_defaults == 'varuna' ) {
			$lalita_extracolors .= '.main-title a {text-shadow: -5px -5px 0px ' . esc_attr( $lalita_color_settings[ 'header_text_color' ] ) . ';}';
		}

		return $lalita_extracolors;
	}
}

// The dynamic styles of the parent theme added inline to the parent stylesheet.
// For the customizer functions it is better to enqueue after the child theme stylesheet.
if ( ! function_exists( 'prakasa_remove_parent_dynamic_css' ) ) {
	add_action( 'init', 'prakasa_remove_parent_dynamic_css' );
	function prakasa_remove_parent_dynamic_css() {
		remove_action( 'wp_enqueue_scripts', 'lalita_enqueue_dynamic_css', 50 );
	}
}

// Enqueue this CSS.
if ( ! function_exists( 'lalita_child_enqueue_parent_dynamic_css' ) ) {
	add_action( 'wp_enqueue_scripts', 'lalita_child_enqueue_parent_dynamic_css', 50 );
	function lalita_child_enqueue_parent_dynamic_css() {
		$css = lalita_base_css() . lalita_font_css() . lalita_advanced_css() . lalita_spacing_css() . lalita_no_cache_dynamic_css() . lalita_child_extra_colors_css();

		// escaped secure before in parent theme
		wp_add_inline_style( 'lalita-childextra-css', $css );
	}
}

// Add the extra button to the navigation.
if ( ! function_exists( 'lalita_navigation_button' ) ) {
	add_filter( 'wp_nav_menu_items', 'lalita_navigation_button', 11, 2 );
	function lalita_navigation_button( $nav, $args ) {
		// Get Customizer settings
		$lalita_settings = get_option( 'lalita_settings' );
		
		// If our primary menu is set, add the extra button.
		if ( ( isset( $lalita_settings['nav_btn_url'] ) ) && ( isset( $lalita_settings['nav_btn_text'] ) ) && ( isset( $args->theme_location ) ) ) {
			if ( ( $args->theme_location == 'primary' ) && ( $lalita_settings['nav_btn_url'] != '' ) ) {
				return $nav . '<li class="wpkoi-nav-btn-h"><a class="wpkoi-nav-btn button" href="' . esc_url( $lalita_settings['nav_btn_url'] ) . '">' . esc_html( $lalita_settings['nav_btn_text'] ) . '</a></li>';
			}
		}
		
	    return $nav;
	}
}

// Adds custom classes to the array of body classes.
if ( ! function_exists( 'lalita_additional_body_classes' ) ) {
	add_filter( 'body_class', 'lalita_additional_body_classes' );
	function lalita_additional_body_classes( $classes ) {
		// Get Customizer settings
		$lalita_settings = wp_parse_args(
			get_option( 'lalita_settings', array() ),
			lalita_get_defaults()
		);
		
		$lalita_theme_defaults = get_option( 'lalita_theme_defaults', 'lalita' );
		
		// Scrollbar style function
		if ( $lalita_settings['nicescroll'] == 'enable' ) {
			$classes[] = 'lalita-scrollbar-style';
		}
		
		// Cursor image class
		if ( $lalita_settings['cursor_style'] == 'image' ) {
			$classes[] = 'lalita-cursor-image';
		}
		
		$classes[] = 'lalita-' . esc_attr( $lalita_theme_defaults ) . '-child';
		
		return $classes;
	}
}
add_action( 'lalita_before_copyright', 'lalita_footer_bar', 15 );