<?php
/**
 * Lalita WordPress theme.
 *
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

// Set our theme version.
define( 'LALITA_VERSION', '2.0.0' );

define( 'LALITA_CHILD_THEMES', array( 'samudra', 'varuna', 'manasa', 'narmada', 'pushan', 'aditi', 'skanda', 'moksa', 'dhyana', 'kalaratri', 'durvasa', 'kalidasa', 'vajra', 'purusha', 'ashram', 'ishvara', 'shudra', 'agni', 'sukha', 'havan', 'ishta', 'madhura', 'omkara', 'sakti', 'mahatma', 'daksha', 'neela', 'daiva', 'pandita', 'samana', 'adarsa', 'itara', 'nidra', 'sundara', 'manas', 'prakasa', 'gotra', 'makara', 'jihva', 'bhakti', 'phala', 'mardava', 'ekata', 'ganapati', 'maitri', 'jagat', 'sabda', 'parama', 'marga', 'bhavana' ) );

// If older child theme used, set the style and defaults for Lalita 2.0.0
if ( ! function_exists( 'lalita_check_child_theme' ) ) {
	function lalita_check_child_theme() {
		
		$child_themes = LALITA_CHILD_THEMES;
		$current_theme = get_template();
		$current_stylesheet = get_stylesheet();

		if ( in_array( $current_stylesheet, $child_themes, true ) ) {
			$current_theme_style = get_option( 'lalita_theme_defaults', 'lalita' );
			if ( $current_theme_style != $current_stylesheet ) {
				update_option( 'lalita_theme_defaults', sanitize_text_field( $current_stylesheet ) );
			}
			return true;
		}

		return false;
	}
}

// Sets up theme defaults and registers support for various WordPress features.
if ( ! function_exists( 'lalita_setup' ) ) {
	add_action( 'after_setup_theme', 'lalita_setup' );
	function lalita_setup() {
		// Make theme available for translation.
		load_theme_textdomain( 'lalita' );

		// Add theme support for various features.
		add_theme_support( 'automatic-feed-links' );
		add_theme_support( 'post-thumbnails' );
		add_theme_support( 'post-formats', array( 'aside', 'image', 'quote', 'link', 'status' ) );
		add_theme_support( 'woocommerce' );
		add_theme_support( 'title-tag' );
		add_theme_support( 'html5', array( 'comment-form', 'comment-list', 'gallery', 'caption' ) );
		
		// Add theme support for selective refresh for widgets.
		add_theme_support( 'customize-selective-refresh-widgets' );
		
		// Add support for Block Styles.
		add_theme_support( 'wp-block-styles' );

		// Add support for full and wide align images.
		add_theme_support( 'align-wide' );
		
		// Add support for responsive embedded content.
		add_theme_support( 'responsive-embeds' );

		// Add support for custom line height controls.
		add_theme_support( 'custom-line-height' );

		// Add support for experimental cover block spacing.
		add_theme_support( 'custom-spacing' );

		add_theme_support( 'custom-logo', array(
			'height' => 72,
			'width' => 240,
			'flex-height' => true,
			'flex-width' => true
		) );
		
		add_theme_support( "custom-header",
			array(
				'default-image'          => '',
				'flex-height'            => false,
				'flex-width'             => false,
				'uploads'                => true,
				'random-default'         => false,
				'header-text'            => false,
				'wp-head-callback'       => '',
				'admin-head-callback'    => '',
				'admin-preview-callback' => '',
			)
		);

		// Register primary menu.
		register_nav_menus( array(
			'primary' => __( 'Primary Menu', 'lalita' ),
		) );

		// Set the content width to something large
		// We set a more accurate width in lalita_smart_content_width()
		global $content_width;
		if ( ! isset( $content_width ) ) {
			$content_width = 1200;
		}

		// This theme styles the visual editor to resemble the theme style.
		add_editor_style( 'css/admin/editor-style.css' );
	}
}

// Get all necessary theme files
get_template_part( 'inc/theme', 'functions' );

$lalita_theme_defaults = get_option( 'lalita_theme_defaults', 'lalita' );
$lalita_theme_defaults = sanitize_key( $lalita_theme_defaults );
$custom_file  = get_template_directory() . '/inc/defaults/' . esc_attr( $lalita_theme_defaults ) . '-defaults.php';

if ( ( file_exists( $custom_file ) ) && ( lalita_check_child_theme() == false ) ) {
	require_once $custom_file;
} else {
	get_template_part( 'inc/defaults' );
}

get_template_part( 'inc/class', 'css' );
get_template_part( 'inc/css', 'output' );
get_template_part( 'inc/general' );
get_template_part( 'inc/customizer' );
if ( lalita_check_child_theme() == false ) {
	get_template_part( 'inc/customizer', 'childs' );
	get_template_part( 'inc/child', 'functions' );
}
get_template_part( 'inc/markup' );
get_template_part( 'inc/element', 'classes' );
get_template_part( 'inc/typography' );
get_template_part( 'inc/plugin', 'compat' );
get_template_part( 'inc/class-tgm-plugin', 'activation' );

if ( is_admin() ) {
	require get_template_directory() . '/inc/meta-box.php';
	require get_template_directory() . '/inc/dashboard.php';
}

// Load our theme structure
get_template_part( 'inc/structure/archives' );
get_template_part( 'inc/structure/comments' );
get_template_part( 'inc/structure/featured', 'images' );
get_template_part( 'inc/structure/footer' );
get_template_part( 'inc/structure/header' );
get_template_part( 'inc/structure/navigation' );
get_template_part( 'inc/structure/post', 'meta' );
get_template_part( 'inc/structure/sidebars' );
get_template_part( 'inc/structure/social', 'bar' );

// Links for theme page
if ( ! function_exists( 'lalita_theme_uri_link' ) ) {
	function lalita_theme_uri_link() {
		return 'https://wpkoi.com/lalita-wpkoi-wordpress-theme/';
	}
}

if ( ! function_exists( 'lalita_new_theme_uri_link' ) ) {
	function lalita_new_theme_uri_link() {
		return 'https://wpkoi.com/lalita-wpkoi-wordpress-theme/';
	}
}

// Lalita related links
define('LALITA_THEME_URL','https://wpkoi.com/lalita-wpkoi-wordpress-theme/');
define('LALITA_WPKOI_AUTHOR_URL','https://wpkoi.com/');
define('LALITA_WPKOI_SOCIAL_URL','https://www.facebook.com/wpkoithemes/');
define('LALITA_WPKOI_WPORG_URL','https://wordpress.org/themes/author/wpkoithemes/');
define('LALITA_WPKOI_DRIBBLE_URL','https://dribbble.com/wpkoi');
define('LALITA_WPKOI_BEHANCE_URL','https://www.behance.net/wpkoi');
define('LALITA_WORDPRESS_REVIEW','https://wordpress.org/support/theme/lalita/reviews/?filter=5');
define('LALITA_DOCUMENTATION','https://wpkoi.com/docs/documentation-for-lalita/');
define('LALITA_IMPORT','https://wpkoi.com/docs/import-free-content/');
define('LALITA_ELEMENTOR_DOCS','https://elementor.com/help/');
define('LALITA_SHOWCASE','https://wpkoi.com/docs/premium-showcase/');
define('LALITA_FONT_AWESOME_LINK','https://wpkoi.com/docs/custom-icons/');
