<?php 
/**
 * Template part for displaying Services Section
 *
 *@package Kuza  Pro
 */

    $timetable_title       = kuza_medical_get_option( 'timetable_title' );
    $timetable_sub_title       = kuza_medical_get_option( 'timetable_sub_title' );
    $timetable_count = kuza_medical_get_option( 'timetable_count' );
    $timetable_content_type     = kuza_medical_get_option( 'timetable_content_type' );
    for( $i=1; $i<=$timetable_count; $i++ ) :
        $timetable_page_posts[] = absint(kuza_medical_get_option( 'timetable_page_'.$i ) );
        $timetable_post_posts[] = absint(kuza_medical_get_option( 'timetable_post_'.$i ) );
        $timetable_btn = kuza_medical_get_option( 'timetable_btn_'.$i ) ;
        $timetable_list = kuza_medical_get_option( 'timetable_list_'.$i ) ;
        $timetable_icon = kuza_medical_get_option( 'timetable_icon_'.$i );
        $timetable_background = kuza_medical_get_option( 'timetable_background_'.$i );  
    endfor;
  
    ?>
<!-- supports col-1, col-2 ,col-3 and col-4 -->
<div class="section-content col-3">
    <?php  
            $args = array (
                'post_type'     => 'post',
                'post_per_page' => count( $timetable_post_posts ),
                'post__in'      => $timetable_post_posts,
                'orderby'       =>'post__in', 
                'ignore_sticky_posts' => true, 
            ); 

        $loop = new WP_Query($args);                        
        if ( $loop->have_posts() ) :
            $i=0;  
            while ($loop->have_posts()) : $loop->the_post(); $i++;?>  
                <?php $timetable_background = kuza_medical_get_option( 'timetable_background_'.$i );   ?>
                <article class="timetable-items" style="background-color:<?php echo esc_attr($timetable_background) ?>">
                    <div class="timetable-table-wrapper">
                        <header class="entry-header">
                            <?php $timetable_icon = kuza_medical_get_option( 'timetable_icon_'.$i ); ?>
                            <?php if ( !empty($timetable_icon) ) { ?>
                                <div class="timetable-icon-container">
                                    <i class="fa <?php echo esc_attr( $timetable_icon); ?>"></i>
                                </div>
                            <?php  } ?>
                            <h2 class="entry-title"><?php the_title();?></h2>
                                <div class="entry-content">
                                    <?php 
                                        $excerpt = kuza_medical_the_excerpt( 35 );
                                        echo wp_kses_post( wpautop( $excerpt ) );
                                    ?>
                                </div>
                            
                        </header>
                            <ul>
                                <?php 
                                $timetable_lists = ! empty( kuza_medical_get_option('timetable_list_' . $i ) ) ? explode( '|', kuza_medical_get_option('timetable_list_' . $i ) ) : array();
                                foreach ($timetable_lists as $timetable_list ) { 
                                    if ( isset( $timetable_list ) ) { 
                                    ?>
                                        <li><?php echo esc_html( $timetable_list ); ?></li>
                                    <?php }  
                                } ?>
                            </ul>

                        <?php if ( ! empty( $timetable_btn ) ) : 
                            $timetable_btn = kuza_medical_get_option( 'timetable_btn_'.$i ) ;
                            ?>
                            <div class="read-more">
                                <a href="<?php the_permalink();?>" class="btn btn-primary" style="background-color:<?php echo esc_attr($timetable_background) ?>"><?php echo esc_html( $timetable_btn );  ?></a>
                            </div>
                        <?php endif; ?>

                    </div><!-- .timetable-table-wrapper -->
                </article>
            <?php endwhile;?>
        <?php endif; ?>
        <?php wp_reset_postdata(); ?>
</div><!-- .section-content -->
