<?php
/**
 * Time Table Section options
 *
 * @package Kuza Pro
 * @subpackage Kuza 
 * @since Kuza  1.0.0
 */
$default = kuza_medical_get_default_theme_options();
// Add Time Table section
$wp_customize->add_section( 'timetable_section', array(
	'title'             => esc_html__( 'Time Table Section','kuza-medical' ),
	'description'       => esc_html__( 'Time Table Section options.', 'kuza-medical' ),
	'panel'             => 'home_page_panel',
	'active_callback' => 'kuza_medical_timetable_design_enable',
) );

// Time Table content enable control and setting
$wp_customize->add_setting( 'theme_options[disable_timetable_section]', array(
	'default'			=> 	$default['disable_timetable_section'],
	'sanitize_callback' => 'kuza_medical_sanitize_switch_control',
) );

$wp_customize->add_control( new Kuza_Medical_Switch_Control( $wp_customize, 'theme_options[disable_timetable_section]', array(
	'label'             => __( 'Time Table Section Enable', 'kuza-medical' ),
	'section'           => 'timetable_section',
	'on_off_label' 		=> kuza_medical_switch_options(),
) ) );


$timetable_count = kuza_medical_get_option( 'timetable_count' );

for ( $i = 1; $i <= $timetable_count; $i++ ) :

	//Time Table Section icon
	$wp_customize->add_setting('theme_options[timetable_icon_'.$i.']', 
		array(
		'default' 			=> $default['timetable_icon_'.$i],
		'type'              => 'theme_mod',
		'capability'        => 'edit_theme_options',	
		'sanitize_callback' => 'sanitize_text_field'
		)
	);

	$wp_customize->add_control('theme_options[timetable_icon_'.$i.']', 
		array(
		'label'       => sprintf( __('Icon #%1$s', 'kuza-medical'), $i),
		'description' => sprintf( __('Please input icon as eg: fa-archive. Find Font-awesome icons %1$shere%2$s', 'kuza-medical'), '<a href="' . esc_url( 'https://fontawesome.com/v4.7.0/cheatsheet/' ) . '" target="_blank">', '</a>' ),
		'section'     => 'timetable_section',   
		'settings'    => 'theme_options[timetable_icon_'.$i.']',
		'active_callback' => 'kuza_medical_timetable_active',		
		'type'        => 'text'
		)
	);


	// Additional Information First Post
	$wp_customize->add_setting('theme_options[timetable_post_'.$i.']', 
		array(
		'type'              => 'theme_mod',
		'capability'        => 'edit_theme_options',	
		'sanitize_callback' => 'kuza_medical_dropdown_posts'
		)
	);
	$wp_customize->add_control( new Kuza_Medical_Dropdown_Chooser( $wp_customize,'theme_options[timetable_post_'.$i.']', 
		array(
		'label'       => sprintf( __('Select Post #%1$s', 'kuza-medical'), $i),
		'section'     => 'timetable_section',  
		'settings'    => 'theme_options[timetable_post_'.$i.']',	
		'choices'			=> kuza_medical_post_choices(),	
		'type'        => 'dropdown-posts',
		'active_callback' => 'kuza_medical_timetable_active',
		)
	));

	

	// timetable btn
	$wp_customize->add_setting( 'theme_options[timetable_btn_' . $i . ']', array(
		'default' 			=> $default['timetable_btn_'.$i],
		'sanitize_callback' => 'sanitize_text_field',
	) );

	$wp_customize->add_control( 'theme_options[timetable_btn_' . $i . ']', array(
		'label'             => sprintf( esc_html__( 'Button %d', 'kuza-medical' ), $i ),
		'section'           => 'timetable_section',
		'active_callback'	=> 'kuza_medical_timetable_active',
	) );

endfor;

