<?php
/**
 * Testimonial options.
 *
 * @package Kuza Medical
 */

$default = kuza_medical_get_default_theme_options();

// Testimonial Section
$wp_customize->add_section( 'section_home_testimonial',
	array(
		'title'      => __( 'Testimonial Section', 'kuza-medical' ),
		'capability' => 'edit_theme_options',
		'panel'      => 'home_page_panel',
		'active_callback' => 'kuza_medical_testimonial_design_enable',
		)
);

$wp_customize->add_setting( 'theme_options[disable_testimonial_section]',
	array(
		'default'           => $default['disable_testimonial_section'],
		'type'              => 'theme_mod',
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'kuza_medical_sanitize_switch_control',
	)
);
$wp_customize->add_control( new Kuza_Medical_Switch_Control( $wp_customize, 'theme_options[disable_testimonial_section]',
    array(
		'label' 			=> __('Enable/Disable Testimonial Section', 'kuza-medical'),
		'section'    		=> 'section_home_testimonial',
		 'settings'  		=> 'theme_options[disable_testimonial_section]',
		'on_off_label' 		=> kuza_medical_switch_options(),
    )
) );


// Testimonial Image
$wp_customize->add_setting('theme_options[testimonial_side_image]', 
	array(
	'type'              => 'theme_mod',
	'capability'        => 'edit_theme_options',	
	'sanitize_callback' => 'kuza_medical_sanitize_image'
	)
);

$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize,
	'theme_options[testimonial_side_image]', 
	array(
	'label'       => __('Section Side Image', 'kuza-medical'),
	'section'     => 'section_home_testimonial',   
	'settings'    => 'theme_options[testimonial_side_image]',		
	'active_callback' => 'kuza_medical_testimonial_active',
	'type'        => 'image',
	)
	)
);
//About Section title
$wp_customize->add_setting('theme_options[testimonial_title]', 
	array(
	'default'           => $default['testimonial_title'],
	'type'              => 'theme_mod',
	'capability'        => 'edit_theme_options',	
	'sanitize_callback' => 'sanitize_text_field'
	)
);

$wp_customize->add_control('theme_options[testimonial_title]', 
	array(
	'label'       => __('Section Title', 'kuza-medical'),
	'section'     => 'section_home_testimonial',   
	'settings'    => 'theme_options[testimonial_title]',
	'active_callback' => 'kuza_medical_testimonial_active',		
	'type'        => 'text'
	)
);


$number_of_testimonial_items = kuza_medical_get_option( 'number_of_testimonial_items' );

for( $i=1; $i<=$number_of_testimonial_items; $i++ ){


	// Posts
	$wp_customize->add_setting('theme_options[testimonial_post_'.$i.']', 
		array(
		'type'              => 'theme_mod',
		'capability'        => 'edit_theme_options',	
		'sanitize_callback' => 'kuza_medical_dropdown_pages'
		)
	);

	$wp_customize->add_control('theme_options[testimonial_post_'.$i.']', 
		array(
		'label'       => sprintf( __('Select Post #%1$s', 'kuza-medical'), $i),
		'section'     => 'section_home_testimonial',   
		'settings'    => 'theme_options[testimonial_post_'.$i.']',		
		'type'        => 'select',
		'choices'	  => kuza_medical_post_choices(),
		'active_callback' => 'kuza_medical_testimonial_active',
		)
	);

	
}