<?php
/**
 * Author options.
 *
 * @package Kuza Medical
 */

$default = kuza_medical_get_default_theme_options();
$home_layout = kuza_medical_get_option( 'homepage_design_layout_options' );

// Author section
$wp_customize->add_section( 'section_home_message',
	array(
		'title'      => __( 'Author Section', 'kuza-medical' ),
		'capability' => 'edit_theme_options',
		'panel'      => 'home_page_panel',
		'active_callback' => 'kuza_medical_message_design_enable',
		)
);


$wp_customize->add_setting( 'theme_options[disable_message_section]',
	array(
		'default'           => $default['disable_message_section'],
		'type'              => 'theme_mod',
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'kuza_medical_sanitize_switch_control',
	)
);
$wp_customize->add_control( new Kuza_Medical_Switch_Control( $wp_customize, 'theme_options[disable_message_section]',
    array(
		'label' 			=> __('Disable Author section', 'kuza-medical'),
		'section'    		=> 'section_home_message',
		'on_off_label' 		=> kuza_medical_switch_options(),
    )
) );

// Additional Information First Page
$wp_customize->add_setting('theme_options[message_page]', 
	array(
	'type'              => 'theme_mod',
	'capability'        => 'edit_theme_options',	
	'sanitize_callback' => 'kuza_medical_dropdown_pages'
	)
);

$wp_customize->add_control('theme_options[message_page]', 
	array(
	'label'       => __('Select Page', 'kuza-medical'),
	'section'     => 'section_home_message',   
	'settings'    => 'theme_options[message_page]',		
	'type'        => 'dropdown-pages',
	'active_callback' => 'kuza_medical_message_active',
	)
);

//Message Section Btn Text
$wp_customize->add_setting('theme_options[message_btn_text]', 
	array(
	'default'           => $default['message_btn_text'],
	'type'              => 'theme_mod',
	'capability'        => 'edit_theme_options',	
	'sanitize_callback' => 'sanitize_text_field'
	)
);

$wp_customize->add_control('theme_options[message_btn_text]', 
	array(
	'label'       => __('Section Title', 'kuza-medical'),
	'section'     => 'section_home_message',   
	'settings'    => 'theme_options[message_btn_text]',
	'active_callback' => 'kuza_medical_message_active',		
	'type'        => 'text'
	)
);