<?php
/**
 * Category options.
 *
 * @package Kuza
 */

$default = kuza_medical_get_default_theme_options();

// Category Author Section
$wp_customize->add_section( 'section_home_layout',
	array(
		'title'      => __( 'Homepage Layout', 'kuza-medical' ),
		'capability' => 'edit_theme_options',
		'panel'      => 'home_page_panel',
		)
);

// Add arrow enable setting and control.
$wp_customize->add_setting( 'theme_options[homepage_layout_options]', array(
	'default'           => $default['homepage_layout_options'],
	'sanitize_callback' => 'kuza_medical_sanitize_select',
	'type'				=> 'theme_mod',
) );

$wp_customize->add_control( 'theme_options[homepage_layout_options]', array(
	'label'             => esc_html__( 'Choose HomePage Color Layout', 'kuza-medical' ),
	'section'           => 'section_home_layout',
	'type'              => 'radio',
	'choices'				=> array( 
		'lite-layout'     => esc_html__( 'Lite HomePage', 'kuza-medical' ), 
		'dark-layout'     => esc_html__( 'Dark HomePage', 'kuza-medical' ),
		)
) );



$wp_customize->add_setting('theme_options[homepage_design_layout_options]', 
	array(
	'default' 			=> $default['homepage_design_layout_options'],
	'type'              => 'theme_mod',
	'capability'        => 'edit_theme_options',	
	'sanitize_callback' => 'kuza_medical_sanitize_select'
	)
);

$wp_customize->add_control('theme_options[homepage_design_layout_options]', 
	array(
	'label'             => esc_html__( 'Choose HomePage Layout', 'kuza-medical' ),
	'description' => __('Save & Refresh the customizer to see its effect.', 'kuza-medical'),
	'section'     => 'section_home_layout',   
	'settings'    => 'theme_options[homepage_design_layout_options]',		
	'type'        => 'select',
	'choices'	  => array(  
		'home-fitness'     => esc_html__( 'Fitness HomePage', 'kuza-medical' ),
		'home-medical'     => esc_html__( 'Medical HomePage', 'kuza-medical' ), 
		'home-education'     => esc_html__( 'Education HomePage', 'kuza-medical' ), 
		'home-nature'     => esc_html__( 'Slider HomePage', 'kuza-medical' ), 
		'home-magazine'     => esc_html__( 'Magazine HomePage', 'kuza-medical' ),
		'home-blog'     => esc_html__( 'Blog HomePage', 'kuza-medical' ),
		'home-business'     => esc_html__( 'Business HomePage', 'kuza-medical' ),
		'home-normal-magazine'     => esc_html__( 'Normal Magazine HomePage', 'kuza-medical' ), 
		'home-medical'     => esc_html__( 'Medical HomePage', 'kuza-medical' ),  
		'home-normal-blog'     => esc_html__( 'Normal Blog HomePage', 'kuza-medical' ),  
		'home-minimal-blog'     => esc_html__( 'Minimal Blog HomePage', 'kuza-medical' ), 
		'home-classic-blog'     => esc_html__( 'Classic Blog HomePage', 'kuza-medical' ),
		),
	)
);

// Add arrow enable setting and control.
$wp_customize->add_setting( 'theme_options[homepage_sidebar_position]', array(
	'default'           => $default['homepage_sidebar_position'],
	'sanitize_callback' => 'kuza_medical_sanitize_select',
) );

$wp_customize->add_control( 'theme_options[homepage_sidebar_position]', array(
	'label'             => esc_html__( 'Choose HomePage sidebar Layout', 'kuza-medical' ),
	'section'           => 'section_home_layout',
	'type'              => 'radio',
	'active_callback'	=> 'kuza_medical_home_magazine_enable',
	'choices'				=> array( 
		'home-no-sidebar'     => esc_html__( 'No Sidebar', 'kuza-medical' ), 
		'home-right-sidebar'     => esc_html__( 'Right Sidebar', 'kuza-medical' ),
		)
) );

