<?php
/**
 * Appointment options.
 *
 * @package Kuza Medical
 */

$default = kuza_medical_get_default_theme_options();
$home_layout = kuza_medical_get_option( 'homepage_design_layout_options');

// Featured Appointment Section
$wp_customize->add_section( 'section_appointment',
	array(
		'title'      => __( 'Appointment Section', 'kuza-medical' ),
		'capability' => 'edit_theme_options',
		'panel'      => 'home_page_panel',
		)
);

// Appointment content enable control and setting
$wp_customize->add_setting( 'theme_options[disable_appointment_section]', array(
	'default' 			=> $default['disable_appointment_section'],
	'sanitize_callback' => 'kuza_medical_sanitize_switch_control',
) );

$wp_customize->add_control( new Kuza_Medical_Switch_Control( $wp_customize, 'theme_options[disable_appointment_section]', array(
	'label'             => __( 'Appointment Section Enable', 'kuza-medical' ),
	'section'           => 'section_appointment',
	'on_off_label' 		=> kuza_medical_switch_options(),
) ) );


// Appointment form setting and control
$wp_customize->add_setting( 'theme_options[appointment_form]', array(
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( 'theme_options[appointment_form]', array(
	'label'           	=> esc_html__( 'Appointment Form Shortcode', 'kuza-medical' ),
	'description'       => sprintf( '%1$s <a href="' . esc_url( admin_url( 'themes.php?page=tgmpa-install-plugins' ) ) .'" target="_blank"> %2$s </a> %3$s', esc_html__( 'Input shortcode from Appointment Form 7 Plugin', 'kuza-medical' ), esc_html__( 'Click Here', 'kuza-medical' ), esc_html__( 'to download plugin.', 'kuza-medical' ) ),
	'section'        	=> 'section_appointment',
	'settings'    		=> 'theme_options[appointment_form]',
	'active_callback' 	=> 'kuza_medical_appointment_active',
	'type'				=> 'text',
) );
