<?php
/**
 * Register block styles.
 *
 * @since 1.0.0
 */
function ktblock_register_block_styles() {

	$block_styles = array(
		'core/button'          => array(
			'fill-base'    => __( 'Fill Base', 'ktblock' ),
			'outline-base' => __( 'Outline Base', 'ktblock' ),
		),
		'core/group'           => array(
			'boxshadow'       => __( 'Box Shadow', 'ktblock' ),
			'boxshadow-solid' => __( 'Box Shadow Solid', 'ktblock' ),
			'full-height'     => __( 'Full-height', 'ktblock' ),
		),
		'core/image'           => array(
			'boxshadow' => __( 'Box Shadow', 'ktblock' ),
		),
		'core/column'          => array(
			'boxshadow'      => __( 'Box Shadow', 'ktblock' ),
			'rounded-corner' => __( 'Rounded Corner with Box Shadow', 'ktblock' ),
		),
		'core/list'            => array(
			'no-disc' => __( 'No Disc', 'ktblock' ),
		),
		'core/media-text'      => array(
			'boxshadow-media' => __( 'Box Shadow', 'ktblock' ),
		),
		'core/navigation-link' => array(
			'fill'         => __( 'Fill', 'ktblock' ),
			'fill-base'    => __( 'Fill Base', 'ktblock' ),
			'outline'      => __( 'Outline', 'ktblock' ),
			'outline-base' => __( 'Outline Base', 'ktblock' ),
		),
	);

	foreach ( $block_styles as $block => $styles ) {
		foreach ( $styles as $style_name => $style_label ) {
			register_block_style(
				$block,
				array(
					'name'  => $style_name,
					'label' => $style_label,
				)
			);
		}
	}
}
add_action( 'init', 'ktblock_register_block_styles' );

/**
 * Registers block categories, and type.
 *
 * @since 1.0.0
 */
function ktblock_register_block_pattern_categories() {

	/* Functionality specific to the Block Pattern Explorer plugin. */
	if ( function_exists( 'register_block_pattern_category_type' ) ) {
		register_block_pattern_category_type( 'ktblock', array( 'label' => __( 'KTBlock', 'ktblock' ) ) );
	}

	$block_pattern_categories = array(
		'ktblock-footer'       => array(
			'label'         => __( 'KTBlock Footer', 'ktblock' ),
			'categoryTypes' => array( 'ktblock' ),
		),
		'ktblock-general'      => array(
			'label'         => __( 'KTBlock General', 'ktblock' ),
			'categoryTypes' => array( 'ktblock' ),
		),
		'ktblock-hero'         => array(
			'label'         => __( 'KTBlock Hero', 'ktblock' ),
			'categoryTypes' => array( 'ktblock' ),
		),
		'ktblock-cta'          => array(
			'label'         => __( 'KTBlock Call To Action', 'ktblock' ),
			'categoryTypes' => array( 'ktblock' ),
		),
		'ktblock-testimonials' => array(
			'label'         => __( 'KTBlock Testimonials', 'ktblock' ),
			'categoryTypes' => array( 'ktblock' ),
		),
		'ktblock-clients'      => array(
			'label'         => __( 'KTBlock Clients', 'ktblock' ),
			'categoryTypes' => array( 'ktblock' ),
		),
		'ktblock-price'        => array(
			'label'         => __( 'KTBlock Price', 'ktblock' ),
			'categoryTypes' => array( 'ktblock' ),
		),
		'ktblock-team-member'  => array(
			'label'         => __( 'KTBlock Team Member', 'ktblock' ),
			'categoryTypes' => array( 'ktblock' ),
		),
		'ktblock-header'       => array(
			'label'         => __( 'KTBlock Header', 'ktblock' ),
			'categoryTypes' => array( 'ktblock' ),
		),
		'ktblock-page'         => array(
			'label'         => __( 'KTBlock Page', 'ktblock' ),
			'categoryTypes' => array( 'ktblock' ),
		),
		'ktblock-query'        => array(
			'label'         => __( 'KTBlock Query', 'ktblock' ),
			'categoryTypes' => array( 'ktblock' ),
		),
	);

	foreach ( $block_pattern_categories as $name => $properties ) {
		register_block_pattern_category( $name, $properties );
	}
}
add_action( 'init', 'ktblock_register_block_pattern_categories', 9 );
