<?php
/**
 * This file adds functions to the KTBlock WordPress theme.
 *
 * @package KTBlock
 * @author  kridhatech
 * @license GNU General Public License v2 or later
 */

if ( ! function_exists( 'ktblock_setup' ) ) {

	/**
	 * Sets up theme defaults and registers support for various WordPress features.
	 *
	 * @since 1.0.0
	 *
	 * @return void
	 */
	function ktblock_setup() {

		// Add support for Block Styles.
		add_theme_support( 'wp-block-styles' );

		// Add support for editor styles.
		add_theme_support( 'editor-styles' );

		// Add support for menu.
		register_nav_menus( array( 'primary' => esc_html__( 'Main Menu', 'ktblock' ) ) );

		// Enqueue editor styles and fonts.
		add_editor_style( array( './style.css', ktblock_fonts_url() ) );

		// Remove core block patterns.
		remove_theme_support( 'core-block-patterns' );

	}
}
add_action( 'after_setup_theme', 'ktblock_setup' );

// Add block styles.
require get_template_directory() . '/inc/block-styles.php';

// Enqueue style sheet.
add_action( 'wp_enqueue_scripts', 'ktblock_enqueue_style_sheet' );
function ktblock_enqueue_style_sheet() {
	wp_enqueue_style( 'ktblock', get_template_directory_uri() . '/assets/css/style.css', array(), wp_get_theme()->get( 'Version' ) );
}

// Enqueue fonts.
add_action( 'wp_enqueue_scripts', 'ktblock_enqueue_fonts' );
function ktblock_enqueue_fonts() {
	wp_enqueue_style( 'ktblock-fonts', ktblock_fonts_url(), array(), null );
}

// Define fonts.
function ktblock_fonts_url() {
	// Allow child themes to disable to the default KTBlock fonts.
	$dequeue_fonts = apply_filters( 'ktblock_dequeue_fonts', false );
	if ( $dequeue_fonts ) {
		return '';
	}
	$fonts = array(
		'family=Cinzel:wght@400..900',
	);
	// Make a single request for all Google Fonts.
	return esc_url_raw( 'https://fonts.googleapis.com/css2?' . implode( '&', array_unique( $fonts ) ) . '&display=swap' );
}