<?php
/**
 * Template part for displaying WooCommerce content in a page.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package krystal
 */
?>

<div class="container">
    <div class="row">
        <?php
        $shop_style = esc_html(get_theme_mod('kr_shop_styles', 'right'));
        $is_sidebar_active = is_active_sidebar('woosidebar');
        $is_woocommerce_activated = function_exists('krystal_is_woocommerce_activated') && krystal_is_woocommerce_activated();

        if ('right' === $shop_style && $is_sidebar_active) :
        ?>
            <div class="col-md-8">
                <?php get_template_part('template-parts/woo', 'content'); ?>
            </div>
            <div class="col-md-3 col-md-offset-1 woo-sidebar">
                <?php get_sidebar('woosidebar'); ?>
            </div>
        <?php
        elseif ('left' === $shop_style && $is_sidebar_active) :
        ?>
            <div class="col-md-3 woo-sidebar">
                <?php get_sidebar('woosidebar'); ?>
            </div>
            <div class="col-md-8 col-md-offset-1">
                <?php get_template_part('template-parts/woo', 'content'); ?>
            </div>
        <?php
        else :
        ?>
            <div class="col-md-12">
                <?php get_template_part('template-parts/woo', 'content'); ?>
            </div>
        <?php
        endif;
        ?>
    </div>
</div>
