<?php
/**
 * Template part for displaying page content in page.php.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package krystal
 */
?>

<div class="content-page">
    <div class="content-inner">
        <div class="page-content-area">
            <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
                <div class="entry-content">
                    <?php
                    // Display the content
                    the_content();

                    // Pagination for multi-page posts
                    wp_link_pages([
                        'before' => '<div class="page-links">' . esc_html__('Pages:', 'krystal'),
                        'after'  => '</div>',
                    ]);
                    ?>
                </div><!-- .entry-content -->

                <?php if (current_user_can('edit_post', get_the_ID())) : ?>
                    <footer class="entry-footer">
                        <?php
                        edit_post_link(
                            sprintf(
                                /* translators: %s: Name of current post */
                                esc_html__('Edit %s', 'krystal'),
                                the_title('<span class="screen-reader-text">"', '"</span>', false)
                            ),
                            '<span class="edit-link">',
                            '</span>'
                        );
                        ?>
                    </footer><!-- .entry-footer -->
                <?php endif; ?>
            </article><!-- #post-<?php the_ID(); ?> -->
        </div>
    </div>
</div>
