<?php
/**
 * Template part for displaying cart page content in page.php.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package krystal
 */
?>

<div class="container">
    <div id="myaccount-wrapper" class="col-md-12">
        <div class="content-page">
            <div class="page-content-area">
                <div class="entry-content">
                    <?php
                    the_content();

                    wp_link_pages(array(
                        'before' => '<div class="page-links">' . esc_html__('Pages:', 'krystal'),
                        'after'  => '</div>',
                    ));
                    ?>
                </div><!-- .entry-content -->

                <?php if (current_user_can('edit_post', get_the_ID())): ?>
                    <footer class="entry-footer">
                        <span class="edit-link">
                            <?php
                            edit_post_link(
                                sprintf(
                                    /* translators: %s: Name of current post */
                                    esc_html__('Edit %s', 'krystal'),
                                    the_title('<span class="screen-reader-text">"', '"</span>', false)
                                )
                            );
                            ?>
                        </span>
                    </footer><!-- .entry-footer -->
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
