<?php
/**
 * Template part for displaying posts.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package krystal
 */
?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
    <div class="blog-wrapper blog-list wow fadeInUp animated" data-wow-delay="0.2s">
        <?php if (has_post_thumbnail()): ?>
            <div class="image">
                <?php the_post_thumbnail('full'); ?>
            </div>
        <?php endif; ?>

        <div class="meta-wrapper">
            <div class="meta">
                <?php if (is_sticky()): ?>
                    <span class="meta-item">
                        <i class="fas fa-thumbtack"></i><?php esc_html_e('Sticky Post', 'krystal'); ?>
                    </span>
                <?php endif; ?>
                <span class="meta-item">
                    <i class="fas fa-clock"></i><?php the_time(get_option('date_format')); ?>
                </span>
                <span class="meta-item">
                    <i class="far fa-user"></i>
                    <a class="author-post-url" href="<?php echo esc_url(get_author_posts_url(get_the_author_meta('ID'))); ?>">
                        <?php the_author(); ?>
                    </a>
                </span>
                <span class="meta-item">
                    <i class="fas fa-comments"></i>
                    <a class="post-comments-url" href="<?php the_permalink(); ?>#comments">
                        <?php comments_number('0', '1', '%'); ?> <?php esc_html_e('Comments', 'krystal'); ?>
                    </a>
                </span>
            </div>
        </div>

        <div class="blog-content">
            <div class="heading">
                <h2>
                    <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                </h2>
            </div>

            <?php if (!is_single() && get_post_gallery()): ?>
                <div class="gallery-section">
                    <div id="gallery-2" class="galleryid-201 gallery-columns-3 gallery-size-medium">
                        <?php foreach (get_post_gallery(get_the_ID(), false)['src'] as $src): ?>
                            <a class="gallery-item" href="<?php echo esc_url($src); ?>">
                                <img src="<?php echo esc_url($src); ?>" class="img-responsive" alt="<?php esc_attr_e('Gallery Images', 'krystal'); ?>" />
                            </a>
                        <?php endforeach; ?>
                    </div>
                </div>
            <?php endif; ?>

            <?php if (is_single()): ?>
                <div class="blog-content">
                    <?php the_content(); ?>
                </div>
                <div class="post-info single">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="post-category">
                                <?php esc_html_e('Categories:', 'krystal'); ?> <?php the_category(', '); ?>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="post-tags single">
                                <?php the_tags(); ?>
                            </div>
                        </div>
                    </div>
                </div>
            <?php else: ?>
                <div class="blog-excerpt">
                    <?php the_excerpt(); ?>
                </div>
            <?php endif; ?>
        </div>

        <?php if (!is_single()): ?>
            <div class="read-more">
                <a href="<?php the_permalink(); ?>"><?php esc_html_e('READ MORE', 'krystal'); ?></a>
            </div>
        <?php endif; ?>

        <?php
        wp_link_pages(array(
            'before' => '<div class="page-links">' . esc_html__('Pages:', 'krystal'),
            'after' => '</div>',
            'link_before' => '<span class="page-number">',
            'link_after' => '</span>',
        ));
        ?>
    </div>
</article>
