<?php
/**
 * Template part for displaying checkout page content in page.php.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package krystal
 */

?>

<?php
$shop_style = esc_html(get_theme_mod('kr_shop_styles', 'right'));
$has_sidebar = is_active_sidebar('woosidebar');
?>

<div class="container">
    <?php if ($shop_style === 'right' && $has_sidebar): ?>
        <div id="checkout-wrapper" class="col-md-9">
            <?php get_template_part('template-parts/cart-checkout-content', 'checkout'); ?>
        </div>
        <div id="sidebar-wrapper" class="col-md-3">
            <?php get_sidebar('woosidebar'); ?>
        </div>
    <?php elseif ($shop_style === 'left' && $has_sidebar): ?>
        <div id="sidebar-wrapper" class="col-md-3">
            <?php get_sidebar('woosidebar'); ?>
        </div>
        <div id="checkout-wrapper" class="col-md-9">
            <?php get_template_part('template-parts/cart-checkout-content', 'checkout'); ?>
        </div>
    <?php else: ?>
        <div id="checkout-wrapper" class="col-md-12">
            <?php get_template_part('template-parts/cart-checkout-content', 'checkout'); ?>
        </div>
    <?php endif; ?>
</div>
