<?php
/**
 * Template part for displaying cart page content in page.php.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package krystal
 */

?>

<div class="container">
    <?php
    $shop_style = esc_html( get_theme_mod( 'kr_shop_styles', 'right' ) );
    $is_sidebar_active = is_active_sidebar( 'woosidebar' );
    $content_class = $is_sidebar_active ? 'col-md-9' : 'col-md-12';
    $sidebar_class = 'col-md-3';

    if ( $shop_style === 'right' && $is_sidebar_active ) : ?>
        <div id="cart-wrapper" class="<?php echo esc_attr( $content_class ); ?>">
            <?php get_template_part( 'template-parts/cart-checkout-content' ); ?>
        </div>
        <div id="sidebar-wrapper" class="<?php echo esc_attr( $sidebar_class ); ?>">
            <?php get_sidebar( 'woosidebar' ); ?>
        </div>

    <?php elseif ( $shop_style === 'left' && $is_sidebar_active ) : ?>
        <div id="sidebar-wrapper" class="<?php echo esc_attr( $sidebar_class ); ?>">
            <?php get_sidebar( 'woosidebar' ); ?>
        </div>
        <div id="cart-wrapper" class="<?php echo esc_attr( $content_class ); ?>">
            <?php get_template_part( 'template-parts/cart-checkout-content' ); ?>
        </div>

    <?php else : ?>
        <div id="cart-wrapper" class="col-md-12">
            <?php get_template_part( 'template-parts/cart-checkout-content' ); ?>
        </div>
    <?php endif; ?>
</div>
