<?php
/**
 * The template for displaying all single posts.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package krystal
 */

get_header();

?>

<div id="primary" class="content-area">
    <main id="main" class="site-main" role="main">
        <?php 
            if ( false === get_theme_mod( 'kr_page_title_section_hide', false ) ) {
                krystal_get_page_title( true, false, false, false );
            }
        ?>
        <div class="skiptarget">
            <div id="maincontent"></div>
        </div>
        <div class="content-inner">
            <div id="blog-section">
                <div class="container">
                    <div class="row">
                        <?php
                            $has_sidebar = is_active_sidebar( 'sidebar-1' );
                            $sidebar_position = esc_html( get_theme_mod( 'kr_blog_sidebar', 'right' ) );

                            // Main content area
                            if ( 'right' === $sidebar_position || 'left' === $sidebar_position ) {
                                echo '<div class="' . ( $has_sidebar ? 'col-md-9' : 'col-md-12' ) . '">';

                                // Start the loop
                                while ( have_posts() ) : the_post();
                                    get_template_part( 'template-parts/content', get_post_format() );
                                    the_post_navigation();

                                    if ( comments_open() || get_comments_number() ) :
                                        comments_template();
                                    endif;

                                endwhile;

                                echo '</div>';

                                // Sidebar area
                                if ( $has_sidebar ) {
                                    echo '<div class="col-md-3">';
                                    get_sidebar( 'sidebar-1' );
                                    echo '</div>';
                                }

                            } else {
                                // No sidebar on this layout, use full width
                                echo '<div class="col-md-12">';

                                // Start the loop
                                while ( have_posts() ) : the_post();
                                    get_template_part( 'template-parts/content', get_post_format() );
                                    the_post_navigation();

                                    if ( comments_open() || get_comments_number() ) :
                                        comments_template();
                                    endif;

                                endwhile;

                                echo '</div>';
                            }
                        ?>
                    </div>
                </div>
            </div>
        </div>        
    </main>
</div>

<?php
get_footer();
