<?php
/**
 * Footer widget area
 *
 * @package krystal
 */

// Return if no widgets are active in the first column
if ( !is_active_sidebar( 'footer-column1' ) ) {
    return;
}

// Get the number of footer widget columns selected by the user
$krystal_widget_num = esc_html(get_theme_mod('kr_footer_widgets', '4'));

// Set column classes based on the number of widget columns
$column_classes = [
    '4' => ['col-md-3', 'col-md-3', 'col-md-3', 'col-md-3'],
    '3' => ['col-md-4', 'col-md-4', 'col-md-4'],
    '2' => ['col-md-6', 'col-md-6'],
    '1' => ['col-md-12']
];

// Get the appropriate column classes for the selected widget number
$krystal_col_classes = isset($column_classes[$krystal_widget_num]) ? $column_classes[$krystal_widget_num] : $column_classes['4'];

// Loop through the footer columns and display widgets
for ($i = 1; $i <= 4; $i++) {
    $footer_column = 'footer-column' . $i;
    if ( is_active_sidebar( $footer_column ) ) :
        ?>
        <div class="widget-column <?php echo esc_attr($krystal_col_classes[$i - 1]); ?>">
            <?php dynamic_sidebar( $footer_column ); ?>
        </div>
        <?php
    endif;
}
?>
