<?php
/**
 * The template for displaying search results pages.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#search-result
 * @package krystal
 */

get_header(); ?>

<div id="primary" class="content-area">
    <main id="main" class="site-main" role="main">
        <?php 
            if (false === get_theme_mod('kr_page_title_section_hide', false)) {
                krystal_get_page_title(false, false, true, false);
            }
        ?>
        <div class="skiptarget">
            <div id="maincontent"></div>
        </div>

        <div class="content-blog searchpage">
            <div class="content-inner">
                <div class="container">
                    <div class="row">
                        <?php
                            $sidebar_position = esc_html(get_theme_mod('kr_blog_sidebar', 'right'));

                            // Render Sidebar and Content based on sidebar position
                            if ('right' === $sidebar_position) {
                                echo '<div class="col-md-9">';
                            } else {
                                echo '<div class="col-md-3">';
                                get_sidebar('sidebar-1');
                                echo '</div><div class="col-md-9">';
                            }
                        ?>

                        <div id="primary" class="content-area">
                            <?php if (have_posts()) : ?>
                                <div class="search-content">
                                    <h1 class="page-search"><?php printf(esc_html__('Search Results for: %s', 'krystal'), '<span>' . get_search_query() . '</span>'); ?></h1>
                                </div><!-- .page-header -->

                                <?php
                                // Start the Loop
                                while (have_posts()) : the_post();
                                    get_template_part('template-parts/content', 'search');
                                endwhile;

                                the_posts_navigation();
                            else :
                                get_template_part('template-parts/content', 'none');
                            endif;
                            ?>
                        </div>

                        <?php
                            // If sidebar is on the left, add it after content
                            if ('left' === $sidebar_position) {
                                get_sidebar('sidebar-1');
                            }
                        ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </main>
</div>

<?php get_footer(); ?>
