<?php
/**
 * The template for displaying all pages.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 * @package krystal
 */

get_header(); ?>

<div id="primary" class="content-area">
    <main id="main" class="site-main" role="main">
        <?php
            // Handle the page title visibility based on WooCommerce conditions.
            $is_woocommerce_page = krystal_is_woocommerce_activated() && (is_woocommerce() || is_cart() || is_checkout());
            $page_title_hide = get_theme_mod('kr_page_title_section_hide', false);
            $shop_page_title_hide = get_theme_mod('kr_shop_page_title_hide', false);
            
            if ($is_woocommerce_page && !$shop_page_title_hide) {
                krystal_get_page_title(false, false, false, false);
            } elseif (!$page_title_hide) {
                krystal_get_page_title(false, false, false, false);
            }
        ?>

        <div class="skiptarget">
            <div id="maincontent"></div>
        </div>

        <?php
            while (have_posts()) : the_post();

                // WooCommerce specific template loading
                if (krystal_is_woocommerce_activated()) {
                    if (is_page('cart') || is_cart()) {
                        get_template_part('template-parts/content', 'cart-page');
                    } elseif (is_page('checkout') || is_checkout()) {
                        get_template_part('template-parts/content', 'checkout-page');
                    } elseif (is_page('my-account') || is_account_page()) {
                        get_template_part('template-parts/content', 'myaccount-page');
                    } else {
                        get_template_part('template-parts/content', 'page');
                    }
                } else {
                    get_template_part('template-parts/content', 'page');
                }

                // Display comments if open or there are comments
                if (comments_open() || get_comments_number()) :
                    ?>
                    <div class="container">
                        <div class="row">
                            <div class="col-md-12">
                                <?php comments_template(); ?>
                            </div>
                        </div>
                    </div>
                    <?php
                endif;

            endwhile; // End of the loop.
        ?>        
    </main>
</div>

<?php get_footer(); ?>
