<?php
/**
 * The main template file.
 *
 * @package krystal
 */

get_header(); ?>

<div id="primary" class="content-area">
    <div id="main" class="site-main" role="main">    
        <?php 
            if (!get_theme_mod('kr_page_title_section_hide', false)) {
                krystal_get_page_title(true, false, false, false); 
            }
        ?>
        <div class="skiptarget">
            <div id="maincontent"></div>
        </div>
        <div class="content-inner">
            <div id="blog-section">
                <div class="container">
                    <div class="row">
                        <?php 
                            $sidebar_position = esc_html(get_theme_mod('kr_blog_sidebar', 'right'));
                            $is_sidebar_active = is_active_sidebar('sidebar-1');
                            $has_posts = have_posts();

                            // Begin column structure
                            if ($sidebar_position === 'right') {
                                $main_class = 'col-md-9';
                                $sidebar_class = 'col-md-3';
                            } else {
                                $main_class = 'col-md-9';
                                $sidebar_class = 'col-md-3';
                            }

                            // Output the main content and sidebar based on position
                            if ($is_sidebar_active) :
                                ?>
                                <div class="<?php echo esc_attr($main_class); ?>">
                                    <?php 
                                    if ($has_posts) :
                                        while (have_posts()) : the_post();
                                            get_template_part('template-parts/content', get_post_format());
                                        endwhile;
                                        the_posts_pagination();
                                    endif;
                                    ?>
                                </div>
                                <div class="<?php echo esc_attr($sidebar_class); ?>">
                                    <?php get_sidebar('sidebar-1'); ?>
                                </div>
                            <?php else : ?>
                                <div class="col-md-12">
                                    <?php 
                                    if ($has_posts) :
                                        while (have_posts()) : the_post();
                                            get_template_part('template-parts/content', get_post_format());
                                        endwhile;
                                        the_posts_pagination();
                                    endif;
                                    ?>
                                </div>
                            <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php get_footer(); ?>
